/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanEffectiveTypeProvider;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringObjectFactoryEffectiveTypeProvider
extends SpringBeanEffectiveTypeProvider {
    @Override
    public boolean processEffectiveTypes(@NotNull CommonSpringBean bean, @NotNull Processor<PsiType> processor2) {
        PsiType factoryEffectiveType;
        if (bean == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(1);
        }
        if ((factoryEffectiveType = SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryEffectiveType(bean.getBeanType())) != null) {
            return processor2.process((Object)factoryEffectiveType);
        }
        return true;
    }

    @Nullable
    public static PsiType getObjectFactoryEffectiveType(@Nullable PsiType beanType) {
        if (beanType instanceof PsiClassType) {
            PsiClassType type = (PsiClassType)beanType;
            if (SpringObjectFactoryEffectiveTypeProvider.isObjectFactory(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getObjectFactoryType(type);
            }
            if (SpringObjectFactoryEffectiveTypeProvider.isJavaxInjectProvider(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getJavaxInjectProviderType(type);
            }
            if (SpringObjectFactoryEffectiveTypeProvider.isJakartaInjectProvider(type)) {
                return SpringObjectFactoryEffectiveTypeProvider.getJakartaInjectProviderType(type);
            }
        }
        return null;
    }

    public static boolean isObjectFactory(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(2);
        }
        return SpringObjectFactoryEffectiveTypeProvider.isInheritor(psiClassType, "org.springframework.beans.factory.ObjectFactory");
    }

    public static boolean isJavaxInjectProvider(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(3);
        }
        return SpringObjectFactoryEffectiveTypeProvider.isInheritor(psiClassType, "javax.inject.Provider");
    }

    public static boolean isJakartaInjectProvider(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(4);
        }
        return SpringObjectFactoryEffectiveTypeProvider.isInheritor(psiClassType, "jakarta.inject.Provider");
    }

    private static boolean isInheritor(@NotNull PsiClassType psiClassType, @NotNull String fqn) {
        PsiClass resolve;
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(5);
        }
        if (fqn == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(6);
        }
        if ((resolve = psiClassType.resolve()) == null) {
            return false;
        }
        return JavaLibraryUtil.hasLibraryClass((Project)resolve.getProject(), (String)fqn) && InheritanceUtil.isInheritor((PsiClass)resolve, (String)fqn);
    }

    @Nullable
    public static PsiType getJavaxInjectProviderType(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(7);
        }
        return PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"javax.inject.Provider", (int)0, (boolean)false);
    }

    public static PsiType getJakartaInjectProviderType(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(8);
        }
        return PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"jakarta.inject.Provider", (int)0, (boolean)false);
    }

    @Nullable
    public static PsiType getObjectFactoryType(@NotNull PsiClassType psiClassType) {
        if (psiClassType == null) {
            SpringObjectFactoryEffectiveTypeProvider.$$$reportNull$$$0(9);
        }
        return PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.beans.factory.ObjectFactory", (int)0, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/SpringObjectFactoryEffectiveTypeProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processEffectiveTypes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isObjectFactory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isJavaxInjectProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isJakartaInjectProvider";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInheritor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getJavaxInjectProviderType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getJakartaInjectProviderType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getObjectFactoryType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

