/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.generate;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.spring.model.actions.generate.SpringComponentGeneratorKt;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/model/actions/generate/SpringComponentGenerator;", "", "project", "Lcom/intellij/openapi/project/Project;", "templateName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getTemplateName", "()Ljava/lang/String;", "generate", "Lcom/intellij/psi/PsiElement;", "fileName", "directory", "Lcom/intellij/psi/PsiDirectory;", "language", "Lcom/intellij/lang/Language;", "prepareTemplateProperties", "Ljava/util/Properties;", "chooseTemplate", "intellij.spring"})
public class SpringComponentGenerator {
    @NotNull
    private final Project project;
    @NotNull
    private final String templateName;

    public SpringComponentGenerator(@NotNull Project project, @NotNull String templateName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        this.project = project;
        this.templateName = templateName;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getTemplateName() {
        return this.templateName;
    }

    @RequiresWriteLock
    @Nullable
    public final PsiElement generate(@NotNull String fileName, @NotNull PsiDirectory directory, @Nullable Language language) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        FileTemplateManager templateManager = FileTemplateManager.getInstance((Project)this.project);
        Properties params = this.prepareTemplateProperties(fileName, directory, language);
        String string = this.chooseTemplate(fileName, language);
        if (string == null) {
            return null;
        }
        String templateName = string;
        FileTemplate fileTemplate = templateManager.getJ2eeTemplate(templateName);
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getJ2eeTemplate(...)");
        FileTemplate template = fileTemplate;
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, (Properties)params, (PsiDirectory)directory, null);
    }

    public static /* synthetic */ PsiElement generate$default(SpringComponentGenerator springComponentGenerator, String string, PsiDirectory psiDirectory, Language language, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generate");
        }
        if ((n & 4) != 0) {
            language = null;
        }
        return springComponentGenerator.generate(string, psiDirectory, language);
    }

    @NotNull
    protected Properties prepareTemplateProperties(@NotNull String fileName, @NotNull PsiDirectory directory, @Nullable Language language) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Properties properties = FileTemplateManager.getInstance((Project)this.project).getDefaultProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getDefaultProperties(...)");
        Properties params = properties;
        ((Map)params).put("NAME", StringsKt.substringBeforeLast$default((String)fileName, (String)".", null, (int)2, null));
        ((Map)params).put("MODIFIER", "");
        return params;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected String chooseTemplate(@NotNull String fileName, @Nullable Language language) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        if (((CharSequence)StringsKt.substringAfterLast((String)this.templateName, (char)'.', (String)"")).length() > 0) {
            return this.templateName;
        }
        fileExtension = StringsKt.substringAfterLast((String)fileName, (char)'.', (String)"");
        if (((CharSequence)fileExtension).length() > 0) {
            return this.templateName + "." + fileExtension;
        }
        v0 = language;
        v1 = var5_4 = v0 != null ? v0.getID() : null;
        if (var5_4 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var5_4.hashCode()) {
            case 0x22A222: {
                if (var5_4.equals("JAVA")) {
                    tmp = 1;
                }
                break;
            }
            case -1125574399: {
                if (var5_4.equals("kotlin")) {
                    tmp = 2;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v2 = "java";
                break;
            }
            case 2: {
                v2 = "kt";
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v2 = SpringComponentGeneratorKt.hasKotlinSupport(this.project) != false ? "kt" : "java";
            }
        }
        extension = v2;
        return this.templateName + "." + extension;
    }
}

