/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks.util;

import com.intellij.openapi.util.Pair;
import com.intellij.spring.model.actions.patterns.frameworks.util.StandardBeansDocLink;
import com.intellij.spring.model.actions.patterns.frameworks.util.StandardBeansDocLinks;
import com.intellij.spring.model.actions.patterns.frameworks.util.StandardBeansDocLinksManager;
import com.intellij.util.xmlb.XmlSerializer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class StandardBeansDocLinksManagerImpl
extends StandardBeansDocLinksManager {
    private final Map<String, Pair<String, String>> myDocLinks = new HashMap<String, Pair<String, String>>();
    @NonNls
    private static final String DOC_LINKS_RESOURCE_XML = "/resources/frameworks/docLinks.xml";

    public StandardBeansDocLinksManagerImpl() {
        Set<URL> resources = this.getDocLinkResources();
        for (URL resource : resources) {
            StandardBeansDocLinks docLinks = (StandardBeansDocLinks)XmlSerializer.deserialize((URL)resource, StandardBeansDocLinks.class);
            assert (docLinks.getDocLinks() != null);
            for (StandardBeansDocLink docLink : docLinks.getDocLinks()) {
                this.myDocLinks.put(docLink.getBeanId(), (Pair<String, String>)Pair.create((Object)docLink.getApiLink(), (Object)docLink.getReferenceLink()));
            }
        }
    }

    @Override
    protected Set<URL> getDocLinkResources() {
        HashSet<URL> resources = new HashSet<URL>();
        resources.add(StandardBeansDocLinksManager.class.getResource(DOC_LINKS_RESOURCE_XML));
        return resources;
    }

    @Override
    @Nullable
    public String getApiLink(String beanId) {
        Pair<String, String> pair = this.myDocLinks.get(beanId);
        return (String)Pair.getFirst(pair);
    }

    @Override
    @Nullable
    public String getReferenceLink(String beanId) {
        Pair<String, String> pair = this.myDocLinks.get(beanId);
        return (String)Pair.getSecond(pair);
    }
}

