/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.spring.factories.SpringFactoryBeansManager;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PsiMethodConverter;
import com.intellij.spring.model.converters.SpringBeanFactoryMethodConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.converters.SpringCreateStaticMethodQuickFix;
import com.intellij.spring.model.highlighting.xml.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanFactoryMethodConverterImpl
extends SpringBeanFactoryMethodConverter {
    @Override
    public PsiMethod fromString(@Nullable String methodName, @NotNull ConvertContext context) {
        if (context == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(0);
        }
        if ("aspectOf".equals(methodName)) {
            return SpringBeanFactoryMethodConverterImpl.createAspectOfLightMethod(context.getPsiManager());
        }
        return super.fromString(methodName, context);
    }

    @Override
    @Nullable
    protected PsiClass getPsiClass(ConvertContext context) {
        SpringBean springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context);
        return springBean instanceof AbstractDomSpringBean ? SpringBeanFactoryMethodConverterImpl.getFactoryClass((AbstractDomSpringBean)((Object)springBean)) : null;
    }

    @Override
    protected PsiMethodConverter.MethodAccepter getMethodAccepter(ConvertContext context, final boolean forCompletion) {
        final SpringBean springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context);
        final boolean fromFactoryBean = springBean.getFactoryBean().getValue() != null;
        return new PsiMethodConverter.MethodAccepter(){

            @Override
            public boolean accept(PsiMethod psiMethod) {
                if (psiMethod.isConstructor() || psiMethod.getReturnType() == null) {
                    return false;
                }
                PsiClass psiClass = psiMethod.getContainingClass();
                assert (psiClass != null);
                String containingClass = psiClass.getQualifiedName();
                return !(forCompletion && containingClass != null && containingClass.equals("java.lang.Object") || !SpringFactoryBeansManager.getInstance().isValidFactoryMethod(psiMethod, fromFactoryBean) || !forCompletion && !SpringBeanFactoryMethodConverterImpl.parametersResolved(springBean, psiMethod));
            }
        };
    }

    private static boolean parametersResolved(@NotNull SpringBean bean, @NotNull PsiMethod method) {
        if (bean == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(1);
        }
        if (method == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(2);
        }
        if (SpringAutowireUtil.isConstructorAutowire(bean)) {
            return true;
        }
        XmlElement beanXmlElement = bean.getXmlElement();
        if (beanXmlElement == null) {
            return false;
        }
        List resolvedMethods = (List)RecursionManager.doPreventingRecursion((Object)beanXmlElement, (boolean)true, () -> SpringConstructorArgResolveUtil.findMatchingMethods(bean));
        return resolvedMethods != null && resolvedMethods.contains(method);
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        String qualifiedName;
        SpringBean springBean;
        PsiClass psiClass;
        GenericDomValue element = (GenericDomValue)context.getInvocationElement();
        String elementName = element.getStringValue();
        if (elementName != null && !elementName.isEmpty() && (psiClass = SpringBeanFactoryMethodConverterImpl.getFactoryMethodClass(springBean = SpringBeanFactoryMethodConverterImpl.getSpringBean(context))) != null && !(psiClass instanceof PsiCompiledElement) && StringUtil.isNotEmpty((String)(qualifiedName = psiClass.getQualifiedName()))) {
            List pairs = ContainerUtil.map(SpringConstructorArgResolveUtil.suggestParamsForConstructorArgs(springBean), parameter -> Pair.create((Object)parameter.getType().getCanonicalText(), (Object)parameter.getName()));
            return new LocalQuickFix[]{SpringBeanFactoryMethodConverterImpl.getCreateNewMethodQuickFix(qualifiedName, elementName, pairs, springBean.getFactoryBean().getValue() == null)};
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }

    @Nullable
    private static PsiClass getFactoryMethodClass(SpringBean springBean) {
        SpringBeanPointer factoryBeanPointer = (SpringBeanPointer)springBean.getFactoryBean().getValue();
        if (factoryBeanPointer != null) {
            return PsiTypesUtil.getPsiClass((PsiType)factoryBeanPointer.getSpringBean().getBeanType(false));
        }
        return PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType(false));
    }

    private static LocalQuickFix getCreateNewMethodQuickFix(String beanClass, String elementName, List<Pair<String, String>> pairs, boolean isStatic) {
        return new SpringCreateStaticMethodQuickFix(beanClass, elementName, pairs, isStatic);
    }

    @NotNull
    private static SpringBean getSpringBean(ConvertContext context) {
        SpringBean bean = (SpringBean)SpringConverterUtil.getCurrentBean(context);
        assert (bean != null);
        SpringBean springBean = bean;
        if (springBean == null) {
            SpringBeanFactoryMethodConverterImpl.$$$reportNull$$$0(3);
        }
        return springBean;
    }

    @Override
    protected Object[] getVariants(ConvertContext context) {
        return ArrayUtil.append((Object[])super.getVariants(context), (Object)LookupElementBuilder.create((String)"aspectOf"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/SpringBeanFactoryMethodConverterImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringBean";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parametersResolved";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

