/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.UseExistingBeanFromOtherContextQuickFix;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UseExistingBeanQuickFixProvider
implements SpringBeanResolveQuickFixProvider {
    @Override
    @NotNull
    public List<LocalQuickFix> getQuickFixes(ConvertContext context, @NotNull Beans beans, @Nullable String beanId, List<PsiClassType> requiredClasses) {
        String parseBeanId;
        if (beans == null) {
            UseExistingBeanQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (requiredClasses.isEmpty()) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                UseExistingBeanQuickFixProvider.$$$reportNull$$$0(1);
            }
            return list;
        }
        GenericDomValue beanPointer = (GenericDomValue)context.getInvocationElement();
        String string = parseBeanId = beanId != null ? beanId : beanPointer.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)parseBeanId)) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                UseExistingBeanQuickFixProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        XmlFile file = context.getFile();
        SpringManager springManager = SpringManager.getInstance(file.getProject());
        SpringModel currentFileModel = springManager.getSpringModelByFile((PsiFile)file);
        if (currentFileModel == null || currentFileModel.getFileSet() == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                UseExistingBeanQuickFixProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        Module module = context.getModule();
        if (module == null) {
            List<LocalQuickFix> list = Collections.emptyList();
            if (list == null) {
                UseExistingBeanQuickFixProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        SmartList fixes = new SmartList();
        Set<SpringModel> springModels = springManager.getAllModels(module);
        block0: for (SpringModel model : springModels) {
            PsiClass beanClass;
            SpringBeanPointer<?> beanByName;
            if (model.getFileSet() == null || (beanByName = SpringModelSearchers.findBean(model, parseBeanId)) == null || (beanClass = beanByName.getBeanClass()) == null) continue;
            for (PsiClassType requiredClass : requiredClasses) {
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)beanClass, (PsiClass)requiredClass.resolve(), (boolean)true)) continue;
                fixes.add(new UseExistingBeanFromOtherContextQuickFix(parseBeanId, beanByName.getContainingFile(), model.getFileSet()));
                continue block0;
            }
        }
        SmartList smartList = fixes;
        if (smartList == null) {
            UseExistingBeanQuickFixProvider.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/converters/fixes/bean/UseExistingBeanQuickFixProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getQuickFixes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

