/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.create.containers;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.create.SpringComponentContainerProvider;
import com.intellij.spring.model.highlighting.create.containers.SourceRootInfo;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/spring/model/highlighting/create/containers/DirectorySelectionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lcom/intellij/spring/create/SpringComponentContainerProvider$Context;", "sourceRoots", "", "Lcom/intellij/spring/model/highlighting/create/containers/SourceRootInfo;", "defaultSourceRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/spring/create/SpringComponentContainerProvider$Context;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "sourceRootsComboBox", "Lcom/intellij/openapi/ui/ComboBox;", "packageNameField", "Lcom/intellij/refactoring/ui/PackageNameReferenceEditorCombo;", "getSelectedSourceRoot", "getSelectedDirectory", "", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nCustomDirectorySpringComponentContainerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomDirectorySpringComponentContainerProvider.kt\ncom/intellij/spring/model/highlighting/create/containers/DirectorySelectionDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,292:1\n1869#2,2:293\n*S KotlinDebug\n*F\n+ 1 CustomDirectorySpringComponentContainerProvider.kt\ncom/intellij/spring/model/highlighting/create/containers/DirectorySelectionDialog\n*L\n217#1:293,2\n*E\n"})
final class DirectorySelectionDialog
extends DialogWrapper {
    @NotNull
    private final ComboBox<SourceRootInfo> sourceRootsComboBox;
    @NotNull
    private final PackageNameReferenceEditorCombo packageNameField;

    public DirectorySelectionDialog(@NotNull Project project, @NotNull SpringComponentContainerProvider.Context context, @NotNull List<SourceRootInfo> sourceRoots, @Nullable VirtualFile defaultSourceRoot) {
        String relativePath;
        PsiDirectory contextDirectory;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceRoots, (String)"sourceRoots");
        super(project, true);
        this.sourceRootsComboBox = new ComboBox();
        this.setTitle(SpringBundle.message("spring.component.container.custom.package.dialog.title", new Object[0]));
        DefaultComboBoxModel<SourceRootInfo> sourceRootsModel = new DefaultComboBoxModel<SourceRootInfo>();
        Iterable $this$forEach$iv = sourceRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SourceRootInfo it = (SourceRootInfo)element$iv;
            boolean bl = false;
            sourceRootsModel.addElement(it);
        }
        this.sourceRootsComboBox.setModel((ComboBoxModel)sourceRootsModel);
        this.sourceRootsComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof SourceRootInfo) {
                    Icon icon = ((SourceRootInfo)value).isTestRoot() ? AllIcons.Modules.TestRoot : AllIcons.Modules.SourceRoot;
                    Intrinsics.checkNotNull((Object)icon);
                    Icon icon2 = icon;
                    this.setText(((SourceRootInfo)value).getSourceRoot().getName() + " " + (String)(((CharSequence)((SourceRootInfo)value).getModuleName()).length() > 0 ? "[" + ((SourceRootInfo)value).getModuleName() + "]" : ""));
                    this.setIcon(icon2);
                }
                Intrinsics.checkNotNull((Object)component);
                return component;
            }
        });
        PsiElement psiElement = context.getContext();
        PsiFile contextFile = psiElement != null ? psiElement.getContainingFile() : null;
        String defaultPackage = "";
        if (contextFile != null && (contextDirectory = contextFile.getContainingDirectory()) != null && defaultSourceRoot != null && (relativePath = VfsUtil.getRelativePath((VirtualFile)contextDirectory.getVirtualFile(), (VirtualFile)defaultSourceRoot)) != null) {
            defaultPackage = StringsKt.replace$default((String)relativePath, (char)'/', (char)'.', (boolean)false, (int)4, null);
        }
        this.packageNameField = new PackageNameReferenceEditorCombo(defaultPackage, project, "spring.component.package", SpringBundle.message("spring.component.container.custom.package.dialog.select.package", new Object[0]));
        if (defaultSourceRoot != null) {
            int n = sourceRootsModel.getSize();
            for (int i = 0; i < n; ++i) {
                SourceRootInfo sourceRoot = (SourceRootInfo)sourceRootsModel.getElementAt(i);
                if (!Intrinsics.areEqual((Object)sourceRoot.getSourceRoot().getPath(), (Object)defaultSourceRoot.getPath())) continue;
                this.sourceRootsComboBox.setSelectedIndex(i);
                break;
            }
        } else if (!((Collection)sourceRoots).isEmpty()) {
            this.sourceRootsComboBox.setSelectedIndex(0);
        }
        this.init();
    }

    public /* synthetic */ DirectorySelectionDialog(Project project, SpringComponentContainerProvider.Context context, List list, VirtualFile virtualFile, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            virtualFile = null;
        }
        this(project, context, list, virtualFile);
    }

    @NotNull
    public final VirtualFile getSelectedSourceRoot() {
        Object object = this.sourceRootsComboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.spring.model.highlighting.create.containers.SourceRootInfo");
        return ((SourceRootInfo)object).getSourceRoot();
    }

    @NotNull
    public final String getSelectedDirectory() {
        String string = this.packageNameField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel jPanel;
        JPanel $this$createCenterPanel_u24lambda_u241 = jPanel = FormBuilder.createFormBuilder().addLabeledComponent(SpringBundle.message("spring.component.container.custom.package.dialog.source.root", new Object[0]), (JComponent)this.sourceRootsComboBox).addLabeledComponent(SpringBundle.message("spring.component.container.custom.package.dialog.package", new Object[0]), (JComponent)this.packageNameField).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u241.setPreferredSize((Dimension)JBUI.size((int)500, (int)100));
        JPanel jPanel2 = jPanel;
        Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"apply(...)");
        return jPanel2;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.packageNameField;
    }
}

