/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringPresentationProvider;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LookupMethodInspection
extends SpringBeanInspectionBase {
    private static void checkLookupMethodReturnType(LookupMethod lookupMethod, PsiMethod method, DomElementAnnotationHolder holder) {
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            holder.createProblem(lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.constructor.not.allowed", new Object[0]), new LocalQuickFix[0]);
        } else if (!(returnType instanceof PsiClassType) || ((PsiClassType)returnType).resolve() == null) {
            holder.createProblem(lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.incorrect.return.type", new Object[0]), new LocalQuickFix[0]);
        } else {
            GenericAttributeValue<SpringBeanPointer<?>> bean = lookupMethod.getBean();
            SpringBeanPointer beanPointer = (SpringBeanPointer)bean.getValue();
            if (beanPointer != null) {
                PsiClass beanClass = beanPointer.getBeanClass();
                if (beanClass == null) {
                    String beanName = SpringPresentationProvider.getSpringBeanName(beanPointer);
                    holder.createProblem(bean, SpringBundle.message("spring.bean.lookup.method.bean.has.no.class", beanName), new LocalQuickFix[0]);
                } else {
                    PsiClass returnClass = ((PsiClassType)returnType).resolve();
                    assert (returnClass != null);
                    if (!SpringBeanCoreUtils.isEffectiveClassType(Collections.singletonList(returnType), beanPointer.getSpringBean()) && !InheritanceUtil.isInheritorOrSelf((PsiClass)beanClass, (PsiClass)returnClass, (boolean)true)) {
                        String beanName = SpringPresentationProvider.getSpringBeanName(beanPointer);
                        String message = SpringBundle.message("spring.bean.lookup.method.return.type.mismatch", beanName);
                        holder.createProblem(lookupMethod.getName(), message, new LocalQuickFix[0]);
                        holder.createProblem(bean, message, new LocalQuickFix[0]);
                    }
                }
            }
        }
    }

    private static void checkLookupMethodIdentifiers(LookupMethod lookupMethod, DomElementAnnotationHolder holder, PsiMethod method) {
        if (!method.hasModifierProperty("public") && !method.hasModifierProperty("protected")) {
            holder.createProblem(lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.must.be.public.or.protected", new Object[0]), new LocalQuickFix[0]);
        }
        if (method.hasModifierProperty("static")) {
            holder.createProblem(lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.must.be.not.static", new Object[0]), new LocalQuickFix[0]);
        }
        if (method.getParameterList().getParametersCount() > 0) {
            holder.createProblem(lookupMethod.getName(), SpringBundle.message("spring.bean.lookup.method.must.have.no.parameters", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        if (springBean == null) {
            LookupMethodInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            LookupMethodInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            LookupMethodInspection.$$$reportNull$$$0(2);
        }
        for (LookupMethod lookupMethod : springBean.getLookupMethods()) {
            PsiMethod method = (PsiMethod)lookupMethod.getName().getValue();
            if (method == null) continue;
            LookupMethodInspection.checkLookupMethodIdentifiers(lookupMethod, holder, method);
            LookupMethodInspection.checkLookupMethodReturnType(lookupMethod, method, holder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "springBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "beans";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/xml/LookupMethodInspection";
        objectArray[2] = "checkBean";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

