/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringPublicFactoryMethodInspection
extends SpringBeanInspectionBase {
    @Override
    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        GenericAttributeValue<PsiMethod> springBeanFactoryMethod;
        if (springBean == null) {
            SpringPublicFactoryMethodInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            SpringPublicFactoryMethodInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringPublicFactoryMethodInspection.$$$reportNull$$$0(2);
        }
        if (!DomUtil.hasXml(springBeanFactoryMethod = springBean.getFactoryMethod())) {
            return;
        }
        PsiMethod factoryMethod = (PsiMethod)springBeanFactoryMethod.getValue();
        if (factoryMethod != null && !factoryMethod.hasModifierProperty("public")) {
            holder.createProblem(springBeanFactoryMethod, HighlightSeverity.WARNING, SpringBundle.message("method.must.be.public", factoryMethod.getName()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "springBean";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "beans";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/model/highlighting/xml/SpringPublicFactoryMethodInspection";
        objectArray[2] = "checkBean";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

