/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.intentions;

import com.intellij.codeInspection.i18n.JavaCreatePropertyFix;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.ResolvedConstructorArgs;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.ConstructorArgIndexConverterImpl;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.values.PlaceholderUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.Prop;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringEntry;
import com.intellij.spring.model.xml.beans.SpringInjection;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringValue;
import com.intellij.spring.model.xml.beans.SpringValueHolder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardCodedStringToPlaceholderMoveIntention
extends JavaCreatePropertyFix {
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            HardCodedStringToPlaceholderMoveIntention.$$$reportNull$$$0(0);
        }
        if (!(psiFile instanceof XmlFile)) {
            return false;
        }
        if (psiFile instanceof JspFile) {
            return false;
        }
        if (!SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
            return false;
        }
        GenericDomValue<?> genericDomValue = HardCodedStringToPlaceholderMoveIntention.getValueElement(editor, psiFile);
        return genericDomValue != null && HardCodedStringToPlaceholderMoveIntention.isAvailable(genericDomValue, (SpringBean)genericDomValue.getParentOfType(SpringBean.class, false));
    }

    @Nullable
    private static GenericDomValue<?> getValueElement(Editor editor, PsiFile file) {
        DomElement domElement = DomUtil.getDomElement((Editor)editor, (PsiFile)file);
        return domElement instanceof GenericDomValue ? (GenericDomValue)domElement : null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiFile psiFile) {
        GenericDomValue<?> domElement;
        if (project == null) {
            HardCodedStringToPlaceholderMoveIntention.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            HardCodedStringToPlaceholderMoveIntention.$$$reportNull$$$0(2);
        }
        if ((domElement = HardCodedStringToPlaceholderMoveIntention.getValueElement(editor, psiFile)) == null) {
            return;
        }
        Set<SpringBeanPointer<?>> placeholderConfigurerBeans = HardCodedStringToPlaceholderMoveIntention.getPlaceholderConfigurerBeans(domElement);
        if (!placeholderConfigurerBeans.isEmpty()) {
            String suggestedKey = HardCodedStringToPlaceholderMoveIntention.suggestKey(domElement);
            Set<PropertiesFile> propertiesFiles = PlaceholderUtils.getInstance().getResources(placeholderConfigurerBeans);
            XmlElement element = domElement.getXmlElement();
            if (element == null) {
                return;
            }
            Couple property = this.invokeAction(project, psiFile, (PsiElement)element, suggestedKey, domElement.getStringValue(), new ArrayList<PropertiesFile>(propertiesFiles));
            if (property == null) {
                return;
            }
            String createdKey = (String)property.getFirst();
            Pair<String, String> pair = HardCodedStringToPlaceholderMoveIntention.getPrefixAndSuffix(placeholderConfigurerBeans);
            WriteAction.run(() -> domElement.setStringValue((String)pair.first + createdKey + (String)pair.second));
        }
    }

    @NotNull
    public String getText() {
        String string = SpringBundle.message("bean.property.extract.name", new Object[0]);
        if (string == null) {
            HardCodedStringToPlaceholderMoveIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            HardCodedStringToPlaceholderMoveIntention.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static boolean isAvailable(GenericDomValue<?> valueElement, @Nullable SpringBean springBean) {
        if (valueElement == null || springBean == null) {
            return false;
        }
        String s = valueElement.getStringValue();
        if (StringUtil.isEmptyOrSpaces((String)s) || HardCodedStringToPlaceholderMoveIntention.isMultiline(s)) {
            return false;
        }
        Set<SpringBeanPointer<?>> placeholderConfigurerBeans = HardCodedStringToPlaceholderMoveIntention.getPlaceholderConfigurerBeans(valueElement);
        return !placeholderConfigurerBeans.isEmpty() && (!(valueElement instanceof SpringValue) || !DomUtil.hasXml(((SpringValue)valueElement).getType())) && !PlaceholderUtils.getInstance().isPlaceholder(s, new ArrayList(placeholderConfigurerBeans)) && !HardCodedStringToPlaceholderMoveIntention.isExcludedProperties(springBean, valueElement);
    }

    private static boolean isExcludedProperties(@Nullable SpringBean springBean, GenericDomValue<?> valueHolder) {
        SpringProperty springProperty;
        if (springBean == null) {
            return false;
        }
        PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)springBean.getBeanType());
        if (beanClass != null && Holder.myExcludedProperties.get(beanClass.getQualifiedName()) != null && (springProperty = (SpringProperty)valueHolder.getParentOfType(SpringProperty.class, false)) != null) {
            return Holder.myExcludedProperties.get(beanClass.getQualifiedName()).contains(springProperty.getName().getStringValue());
        }
        return false;
    }

    @Nullable
    private static String suggestKey(GenericDomValue<?> domElement) {
        String key;
        if (domElement instanceof Prop && (key = ((Prop)domElement).getKey().getStringValue()) != null) {
            return key;
        }
        LinkedList<String> keyFragments = new LinkedList<String>();
        for (SpringInjection current = (SpringInjection)domElement.getParentOfType(SpringInjection.class, false); current != null; current = (SpringInjection)current.getParentOfType(SpringInjection.class, true)) {
            keyFragments.addFirst(HardCodedStringToPlaceholderMoveIntention.createKeyFragment(current));
        }
        DomSpringBean topLevelBean = HardCodedStringToPlaceholderMoveIntention.findTopLevelBean(domElement);
        keyFragments.addFirst(HardCodedStringToPlaceholderMoveIntention.createPrefixFromBean(topLevelBean));
        String key2 = StringUtil.join(keyFragments, (String)".");
        return StringUtil.isEmptyOrSpaces((String)key2) ? HardCodedStringToPlaceholderMoveIntention.suggestValue(domElement.getStringValue()) : key2;
    }

    @Nullable
    private static String createPrefixFromBean(@Nullable DomSpringBean bean) {
        if (bean != null) {
            String beanName = bean.getBeanName();
            if (beanName != null) {
                return beanName;
            }
            PsiClass beanClass = PsiTypesUtil.getPsiClass((PsiType)bean.getBeanType());
            if (beanClass != null) {
                Project project = bean.getManager().getProject();
                JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
                PsiClassType classType = PsiTypesUtil.getClassType((PsiClass)beanClass);
                SuggestedNameInfo nameInfo = styleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, (PsiType)classType);
                if (nameInfo.names.length > 0) {
                    return nameInfo.names[0];
                }
            }
        }
        return null;
    }

    @Nullable
    private static DomSpringBean findTopLevelBean(@NotNull DomElement domElement) {
        if (domElement == null) {
            HardCodedStringToPlaceholderMoveIntention.$$$reportNull$$$0(5);
        }
        for (DomSpringBean current = (DomSpringBean)domElement.getParentOfType(DomSpringBean.class, false); current != null; current = (DomSpringBean)current.getParentOfType(DomSpringBean.class, true)) {
            if (!(current.getParent() instanceof Beans)) continue;
            return current;
        }
        return null;
    }

    @Nullable
    private static String createKeyFragment(@NotNull SpringValueHolder holder) {
        SpringBean bean;
        if (holder == null) {
            HardCodedStringToPlaceholderMoveIntention.$$$reportNull$$$0(6);
        }
        if (holder instanceof SpringProperty) {
            return ((SpringProperty)holder).getName().getStringValue();
        }
        if (holder instanceof ConstructorArg && (bean = (SpringBean)holder.getParent()) != null) {
            ConstructorArg constructorArg = (ConstructorArg)holder;
            GenericAttributeValue<Integer> index = constructorArg.getIndex();
            PsiParameter parameter = null;
            if (index.getValue() != null) {
                parameter = ConstructorArgIndexConverterImpl.resolve(index, bean);
            } else {
                ResolvedConstructorArgs resolvedArgs = bean.getResolvedConstructorArgs();
                PsiMethod resolvedMethod = resolvedArgs.getResolvedMethod();
                if (resolvedMethod != null) {
                    parameter = resolvedArgs.getResolvedArgs(resolvedMethod).get(constructorArg);
                }
            }
            if (parameter != null) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
                if (method instanceof PsiCompiledElement) {
                    JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)holder.getManager().getProject());
                    SuggestedNameInfo nameInfo = styleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, parameter.getType());
                    return (String)ArrayUtil.getFirstElement((Object[])nameInfo.names);
                }
                return parameter.getName();
            }
        }
        if (holder instanceof SpringEntry) {
            SpringEntry entry = (SpringEntry)holder;
            String keyValue = entry.getKeyAttr().getStringValue();
            if (keyValue != null) {
                return HardCodedStringToPlaceholderMoveIntention.suggestValue(keyValue);
            }
            String value = entry.getKey().getValue().getStringValue();
            if (value != null) {
                return HardCodedStringToPlaceholderMoveIntention.suggestValue(value);
            }
        }
        return null;
    }

    private static String suggestValue(String value) {
        if (value == null) {
            return "";
        }
        for (String myEscape : Holder.myEscapes) {
            value = value.replace(myEscape, ".");
        }
        while (value.contains("..")) {
            value = value.replace("..", ".");
        }
        value = value.trim();
        value = StringUtil.trimStart((String)value, (String)".");
        value = StringUtil.trimEnd((String)value, (String)".");
        return value;
    }

    private static Pair<String, String> getPrefixAndSuffix(Collection<SpringBeanPointer<?>> springBeans) {
        for (SpringBeanPointer<?> pointer : springBeans) {
            Object bean = pointer.getSpringBean();
            if (!(bean instanceof DomSpringBean)) continue;
            return PlaceholderUtils.getInstance().getPlaceholderPrefixAndSuffix((DomSpringBean)bean);
        }
        return Pair.create((Object)"${", (Object)"}");
    }

    private static boolean isMultiline(String s) {
        return s.trim().indexOf(10) >= 0;
    }

    private static Set<SpringBeanPointer<?>> getPlaceholderConfigurerBeans(DomElement domElement) {
        SpringModel model = SpringConverterUtil.getSpringModel(domElement);
        if (model == null) {
            return Collections.emptySet();
        }
        return SpringModelVisitorUtils.getPlaceholderConfigurers(model);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/intentions/HardCodedStringToPlaceholderMoveIntention";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/intentions/HardCodedStringToPlaceholderMoveIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTopLevelBean";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createKeyFragment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        private static final Map<String, List<String>> myExcludedProperties = Map.of("org.springframework.beans.factory.config.PlaceholderConfigurerSupport", List.of("placeholderPrefix", "placeholderSuffix"));
        private static final String[] myEscapes = new String[]{":", "_", "/", "\\", "#", "$", "{", "}"};

        private Holder() {
        }
    }
}

