/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.utils;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamReferenceContributorKt;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.spring.SpringApiBundle;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/model/jam/utils/SpringResourceLocationsUtil;", "", "<init>", "()V", "checkResourceLocation", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "attributeElement", "Lcom/intellij/jam/JamStringAttributeElement;", "intellij.spring.core"})
public final class SpringResourceLocationsUtil {
    @NotNull
    public static final SpringResourceLocationsUtil INSTANCE = new SpringResourceLocationsUtil();

    private SpringResourceLocationsUtil() {
    }

    public final void checkResourceLocation(@NotNull ProblemsHolder holder, @NotNull JamStringAttributeElement<?> attributeElement) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter(attributeElement, (String)"attributeElement");
        PsiLiteral psiLiteral = attributeElement.getPsiLiteral();
        if (psiLiteral == null) {
            return;
        }
        PsiLiteral psiLiteral2 = psiLiteral;
        for (PsiReference psiReference : psiLiteral2.getReferences()) {
            String string;
            PsiElement psiElement;
            UInjectionHost uInjectionHost;
            Intrinsics.checkNotNull((Object)psiReference);
            PsiReference unwrapped = JamReferenceContributorKt.unwrapReference((PsiReference)psiReference);
            if (unwrapped.isSoft() || !(unwrapped instanceof FileReference)) continue;
            ResolveResult[] resolveResultArray = ((FileReference)unwrapped).multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray, (String)"multiResolve(...)");
            if (!(((Object[])resolveResultArray).length == 0)) continue;
            UInjectionHost uInjectionHost2 = uInjectionHost = (UInjectionHost)UastContextKt.toUElement((PsiElement)((PsiElement)psiLiteral2), UInjectionHost.class);
            Object object = psiElement = uInjectionHost2 != null ? uInjectionHost2.getSourcePsi() : null;
            if (psiElement == null) continue;
            String pathValue = uInjectionHost.evaluateToString();
            if (pathValue != null && !PlaceholderTextRanges.getPlaceholderRanges((String)pathValue, (String)"${", (String)"}").isEmpty()) {
                return;
            }
            if (((FileReference)unwrapped).isLast()) {
                var14_14 = new Object[]{((FileReference)unwrapped).getText()};
                String string2 = SpringApiBundle.message("model.file.error.message", var14_14);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            } else {
                var14_14 = new Object[]{((FileReference)unwrapped).getText()};
                String string3 = SpringApiBundle.message("model.directory.error.message", var14_14);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            }
            String message = string;
            LocalQuickFix[] localQuickFixArray = ((FileReference)unwrapped).getQuickFixes();
            holder.registerProblem(psiElement, ((FileReference)unwrapped).getRangeInElement(), message, Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
        }
    }
}

