/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.scope;

import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.scope.SpringBeanScope;
import com.intellij.spring.model.scope.SpringBeanScopeManager;
import com.intellij.spring.model.scope.SpringCustomBeanScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanScopeManagerImpl
extends SpringBeanScopeManager {
    @Override
    public List<SpringBeanScope> getCustomBeanScopes(@Nullable PsiElement element) {
        SpringCustomBeanScope customBeanScope;
        PsiClass scopeClass;
        if (element == null || DumbService.isDumb((Project)element.getProject())) {
            return Collections.emptyList();
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return Collections.emptyList();
        }
        GlobalSearchScope searchScope = SpringGlobalSearchScopes.runtime(module, false);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)element.getProject());
        PsiFile containingFile = element.getContainingFile();
        Set<SpringModel> models = SpringManager.getInstance(element.getProject()).getSpringModelsByFile(containingFile);
        SmartList customScopes = new SmartList();
        SpringCustomBeanScope[] springCustomBeanScopeArray = (SpringCustomBeanScope[])SpringCustomBeanScope.EP_NAME.getExtensions();
        int n = springCustomBeanScopeArray.length;
        for (int i = 0; i < n && ((scopeClass = javaPsiFacade.findClass((customBeanScope = springCustomBeanScopeArray[i]).getScopeClassName(), searchScope)) == null || customBeanScope.process((List<SpringBeanScope>)customScopes, models, scopeClass, element)); ++i) {
        }
        customScopes.addAll(ContainerUtil.map(SpringBeanScopeManagerImpl.getRegisteredScopes(module, models), s -> new SpringBeanScope((String)s)));
        return customScopes;
    }

    @NotNull
    private static Collection<String> getRegisteredScopes(Module module, @NotNull Set<SpringModel> models) {
        PsiClass beanFactoryPostProcessorClass;
        if (models == null) {
            SpringBeanScopeManagerImpl.$$$reportNull$$$0(0);
        }
        if ((beanFactoryPostProcessorClass = SpringCommonUtils.findLibraryClass(module, "org.springframework.beans.factory.config.BeanFactoryPostProcessor")) == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringBeanScopeManagerImpl.$$$reportNull$$$0(1);
            }
            return set;
        }
        PsiClass factory = SpringCommonUtils.findLibraryClass(module, "org.springframework.beans.factory.config.ConfigurableBeanFactory");
        if (factory == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringBeanScopeManagerImpl.$$$reportNull$$$0(2);
            }
            return set;
        }
        PsiMethod[] registerScopeMethods = factory.findMethodsByName("registerScope", false);
        if (registerScopeMethods.length != 1) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                SpringBeanScopeManagerImpl.$$$reportNull$$$0(3);
            }
            return set;
        }
        SpringModelSearchParameters.BeanClass searchParams = SpringModelSearchParameters.byClass(beanFactoryPostProcessorClass).withInheritors();
        HashSet<String> scopes = new HashSet<String>();
        PsiMethod registerScopeMethod = registerScopeMethods[0];
        for (SpringModel model : models) {
            for (SpringBeanPointer<?> pointer : SpringModelSearchers.findBeans((CommonSpringModel)model, searchParams)) {
                PsiMethod[] postProcessBeanFactories;
                PsiClass beanClass = pointer.getBeanClass();
                if (beanClass == null || (postProcessBeanFactories = beanClass.findMethodsByName("postProcessBeanFactory", false)).length <= 0) continue;
                MethodReferencesSearch.search((PsiMethod)registerScopeMethod, (SearchScope)new LocalSearchScope((PsiElement)postProcessBeanFactories[0]), (boolean)true).asIterable().forEach(psiReference -> {
                    Pair evaluatedExpression;
                    PsiExpression[] expressions;
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
                    if (methodCallExpression != null && (expressions = methodCallExpression.getArgumentList().getExpressions()).length > 0 && (evaluatedExpression = StringExpressionHelper.evaluateExpression((PsiElement)expressions[0])) != null) {
                        ContainerUtil.addIfNotNull((Collection)scopes, (Object)((String)evaluatedExpression.getSecond()));
                    }
                });
            }
        }
        HashSet<String> hashSet = scopes;
        if (hashSet == null) {
            SpringBeanScopeManagerImpl.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/scope/SpringBeanScopeManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/scope/SpringBeanScopeManagerImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegisteredScopes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRegisteredScopes";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

