/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.contexts.model.CombinedSpringModel;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringAutoConfiguredModels;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.testContexts.ContextConfiguration;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestingAnnotationsProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UastUtils;

public class SpringModelUtilsImpl
extends SpringModelUtils {
    @Override
    @NotNull
    public CommonSpringModel getSpringModel(@NotNull SpringModelElement modelElement) {
        Project project;
        SpringModel file;
        if (modelElement == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(0);
        }
        CommonSpringModel commonSpringModel = (file = SpringManager.getInstance(project = modelElement.getManager().getProject()).getSpringModelByFile((PsiFile)DomUtil.getFile((DomElement)modelElement))) != null ? file : SpringModel.UNKNOWN;
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(1);
        }
        return commonSpringModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getSpringModel(@Nullable PsiElement element) {
        if (element == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(2);
            }
            return commonSpringModel;
        }
        if (element instanceof XmlElement) {
            SpringModel modelForFile;
            PsiFile file = element.getContainingFile();
            if (file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)file) && (modelForFile = SpringManager.getInstance(element.getProject()).getSpringModelByFile(file)) != null) {
                SpringModel springModel = modelForFile;
                if (springModel == null) {
                    SpringModelUtilsImpl.$$$reportNull$$$0(3);
                }
                return springModel;
            }
        } else {
            UClass psiClass = (UClass)UastUtils.findContaining((PsiElement)element, UClass.class);
            if (psiClass != null) {
                CommonSpringModel commonSpringModel = this.getPsiClassSpringModel(psiClass.getJavaPsi());
                if (commonSpringModel == null) {
                    SpringModelUtilsImpl.$$$reportNull$$$0(4);
                }
                return commonSpringModel;
            }
        }
        CommonSpringModel commonSpringModel = this.getModuleCombinedSpringModel(element);
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(5);
        }
        return commonSpringModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getPsiClassSpringModel(@NotNull PsiClass psiClass) {
        CommonSpringModel testingModel;
        if (psiClass == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(6);
        }
        if (!psiClass.isValid()) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(7);
            }
            return commonSpringModel;
        }
        if (ProjectRootsUtil.isInTestSource((PsiFile)psiClass.getContainingFile().getOriginalFile()) && (testingModel = this.getSpringTestingModel(psiClass)) != null) {
            CommonSpringModel commonSpringModel = testingModel;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(8);
            }
            return commonSpringModel;
        }
        if (SpringCommonUtils.isConfigurationOrMeta(psiClass)) {
            return this.getAnnoConfigurationSpringModel(psiClass);
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getOriginalFile().getVirtualFile();
        if (virtualFile == null || virtualFile.getFileSystem() instanceof JarFileSystem) {
            Project project = psiClass.getProject();
            return SpringModelUtilsImpl.getCombinedModelForProject(project);
        }
        CommonSpringModel commonSpringModel = this.getModuleCombinedSpringModel((PsiElement)psiClass);
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(9);
        }
        return commonSpringModel;
    }

    @Nullable
    public CommonSpringModel getSpringTestingModel(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(10);
        }
        if (SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass)) {
            return SpringTestContextUtil.getInstance().getSpringTestingModel(psiClass);
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module != null && !module.isDisposed() && SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            SpringModelSearchParameters.BeanClass params = SpringModelSearchParameters.byClass(psiClass);
            HashSet<CommonSpringModel> tests = new HashSet<CommonSpringModel>();
            for (CommonSpringModel model : this.getTestingModels(module)) {
                if (!SpringModelSearchers.doesBeanExist(model, params)) continue;
                tests.add(model);
            }
            if (!tests.isEmpty()) {
                return new CombinedSpringModelImpl(tests, null);
            }
        }
        return null;
    }

    @NotNull
    private CommonSpringModel getAnnoConfigurationSpringModel(@NotNull PsiClass psiClass) {
        SpringModelSearchParameters.BeanClass params;
        CommonSpringModel springModel;
        if (psiClass == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(11);
        }
        if (SpringModelSearchers.doesBeanExist(springModel = this.getModuleCombinedSpringModel((PsiElement)psiClass), params = SpringModelSearchParameters.byClass(psiClass))) {
            CommonSpringModel commonSpringModel = springModel;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(12);
            }
            return commonSpringModel;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(13);
            }
            return commonSpringModel;
        }
        LocalAnnotationModel model = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
        CommonSpringModel commonSpringModel = model != null ? model : SpringModel.UNKNOWN;
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(14);
        }
        return commonSpringModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getModuleCombinedSpringModel(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(15);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null || module.isDisposed()) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(16);
            }
            return commonSpringModel;
        }
        SpringModel springModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
        if (springModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(17);
        }
        return springModel;
    }

    @Override
    @NotNull
    public CommonSpringModel getSpringModelByBean(@Nullable CommonSpringBean springBean) {
        if (springBean == null) {
            CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(18);
            }
            return commonSpringModel;
        }
        if (springBean instanceof SpringModelElement) {
            CommonSpringModel commonSpringModel = this.getSpringModel((SpringModelElement)((Object)springBean));
            if (commonSpringModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(19);
            }
            return commonSpringModel;
        }
        Module module = springBean.getModule();
        if (module != null) {
            SpringModel springModel = SpringManager.getInstance(module.getProject()).getCombinedModel(module);
            if (springModel == null) {
                SpringModelUtilsImpl.$$$reportNull$$$0(20);
            }
            return springModel;
        }
        CommonSpringModel commonSpringModel = SpringModel.UNKNOWN;
        if (commonSpringModel == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(21);
        }
        return commonSpringModel;
    }

    @Override
    public boolean isTestContext(Module module, PsiFile file) {
        for (CommonSpringModel model : this.getTestingModels(module)) {
            if (!SpringModelVisitorUtils.hasConfigFile(model, file)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Set<CommonSpringModel> getTestingModels(@NotNull Module module) {
        if (module == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(22);
        }
        HashSet<CommonSpringModel> testingModels = new HashSet<CommonSpringModel>();
        JamService jamService = JamService.getJamService((Project)module.getProject());
        for (PsiClass contextConfigurationAnno : SpringModelUtilsImpl.getTestingAnnotations(module)) {
            String qualifiedName = contextConfigurationAnno.getQualifiedName();
            if (StringUtil.isEmptyOrSpaces((String)qualifiedName)) continue;
            for (ContextConfiguration configuration : jamService.getJamClassElements(ContextConfiguration.CONTEXT_CONFIGURATION_JAM_KEY, qualifiedName, GlobalSearchScope.moduleScope((Module)module))) {
                CommonSpringModel model = SpringTestContextUtil.getInstance().getSpringTestingModel(configuration.getPsiElement());
                if (model == SpringModel.UNKNOWN) continue;
                testingModels.add(model);
            }
        }
        HashSet<CommonSpringModel> hashSet = testingModels;
        if (hashSet == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(23);
        }
        return hashSet;
    }

    public static Collection<PsiClass> getTestingAnnotations(@NotNull Module module) {
        if (module == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(24);
        }
        HashSet<PsiClass> classes = new HashSet<PsiClass>();
        for (SpringTestingAnnotationsProvider provider : SpringTestingAnnotationsProvider.EP_NAME.getExtensionList()) {
            classes.addAll(provider.getTestingAnnotations(module));
        }
        return classes;
    }

    @Override
    public boolean isUsedConfigurationFile(@NotNull PsiFile configurationFile, boolean checkTestFiles) {
        Project project;
        if (configurationFile == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(25);
        }
        if (DumbService.isDumb((Project)(project = configurationFile.getProject()))) {
            return false;
        }
        VirtualFile virtualFile = configurationFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            return false;
        }
        ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)module).getFileIndex();
        if (!moduleFileIndex.isInContent(virtualFile)) {
            return false;
        }
        if (!checkTestFiles && moduleFileIndex.isInTestSourceContent(virtualFile)) {
            return true;
        }
        Ref result2 = Ref.create((Object)Boolean.FALSE);
        ModuleUtilCore.visitMeAndDependentModules((Module)module, depModule -> {
            boolean found = SpringFileSetService.getInstance().findFileSet(depModule, configurationFile) != null || checkTestFiles && this.isTestContext(depModule, configurationFile);
            result2.set((Object)found);
            return !found;
        });
        return (Boolean)result2.get();
    }

    @NotNull
    private static CombinedSpringModel getCombinedModelForProject(Project project) {
        LinkedHashSet<SpringModel> allCombinedModels = new LinkedHashSet<SpringModel>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            Set<SpringModel> allModels = SpringManager.getInstance(project).getAllModelsWithoutDependencies(module);
            allCombinedModels.addAll(allModels);
        }
        return new CombinedSpringModelImpl(allCombinedModels, null);
    }

    @Override
    public boolean hasAutoConfiguredModels(@Nullable Module module) {
        return module != null && SpringAutoConfiguredModels.hasAutoConfiguredModels(module);
    }

    @Override
    @NotNull
    public SpringModel getCombinedSpringModel(@NotNull Set<? extends CommonSpringModel> models, @NotNull Module module) {
        if (models == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(26);
        }
        if (module == null) {
            SpringModelUtilsImpl.$$$reportNull$$$0(27);
        }
        return new CombinedSpringModelImpl(models, module);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 8, 9, 12, 13, 14, 16, 17, 18, 19, 20, 21, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringModelUtilsImpl";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationFile";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "models";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringModelUtilsImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModel";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiClassSpringModel";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnoConfigurationSpringModel";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleCombinedSpringModel";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModelByBean";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestingModels";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSpringModel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPsiClassSpringModel";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSpringTestingModel";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAnnoConfigurationSpringModel";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModuleCombinedSpringModel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestingModels";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTestingAnnotations";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isUsedConfigurationFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getCombinedSpringModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7, 8, 9, 12, 13, 14, 16, 17, 18, 19, 20, 21, 23 -> new IllegalStateException(string);
        };
    }
}

