/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.persistence.integration;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.helpers.PersistenceUnitModelHelper;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.PackageListConverter;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.spring.model.xml.beans.SpringPropertyDefinition;
import com.intellij.spring.persistence.integration.SpringPersistencePackage;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ReadOnlyGenericValue;
import com.intellij.util.xml.impl.ConvertContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="com.intellij.spring.SpringApiIcons.SpringConfig")
public abstract class SpringXmlPersistencePackage
extends SpringPersistencePackage<DomSpringBeanPointer>
implements PersistencePackage,
PersistenceUnitModelHelper {
    @NonNls
    public static final String DATASOURCE = "dataSource";
    @NonNls
    public static final String PACKAGES_TO_SCAN = "packagesToScan";
    @NonNls
    public static final String PERSISTENCE_UNIT_NAME = "persistenceUnitName";
    @NonNls
    public static final String MAPPING_RESOURCES = "mappingResources";
    protected final CachedValue<List<GenericValue<PersistenceMappings>>> myMappings;
    private final CachedValue<Properties> myProperties;

    public SpringXmlPersistencePackage(DomSpringBeanPointer bean, Module module) {
        super(bean, module);
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.getPsiManager().getProject());
        this.myProperties = cachedValuesManager.createCachedValue(() -> this.getPersistenceUnitPropertiesInner(), false);
        this.myMappings = cachedValuesManager.createCachedValue(() -> CachedValueProvider.Result.create(this.computeMappingFiles(PersistenceMappings.class), (Object[])this.getCacheDependencies().toArray()), false);
    }

    private <V extends PersistenceMappings> List<GenericValue<V>> computeMappingFiles(Class<V> mappingsClass) {
        ArrayList mappings = new ArrayList();
        for (String propertyName : this.getMappingResourcesProperties()) {
            this.addMappings(mappings, mappingsClass, SpringPropertyUtils.findPropertyByName(this.getBean(), propertyName), false);
        }
        for (String propertyName : this.getMappingResourcesDirectoryProperties()) {
            this.addMappings(mappings, mappingsClass, SpringPropertyUtils.findPropertyByName(this.getBean(), propertyName), true);
        }
        return ContainerUtil.map(mappings, ReadOnlyGenericValue::getInstance);
    }

    @NotNull
    protected Collection<String> getMappingResourcesProperties() {
        Set<String> set = Collections.singleton(MAPPING_RESOURCES);
        if (set == null) {
            SpringXmlPersistencePackage.$$$reportNull$$$0(0);
        }
        return set;
    }

    protected Collection<String> getMappingResourcesDirectoryProperties() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public <V extends PersistenceMappings> List<? extends GenericValue<V>> getMappingFiles(Class<V> mappingsClass) {
        ArrayList<GenericValue> result2 = new ArrayList<GenericValue>();
        for (GenericValue o : (List)this.myMappings.getValue()) {
            if (!mappingsClass.isInstance(o.getValue())) continue;
            result2.add(o);
        }
        ArrayList<GenericValue> arrayList = result2;
        if (arrayList == null) {
            SpringXmlPersistencePackage.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Properties getPersistenceUnitProperties() {
        Properties properties = (Properties)this.myProperties.getValue();
        if (properties == null) {
            SpringXmlPersistencePackage.$$$reportNull$$$0(2);
        }
        return properties;
    }

    @NotNull
    protected abstract CachedValueProvider.Result<Properties> getPersistenceUnitPropertiesInner();

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            SpringXmlPersistencePackage.$$$reportNull$$$0(3);
        }
        return (T)this.getBean().getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            SpringXmlPersistencePackage.$$$reportNull$$$0(4);
        }
        this.getBean().putUserData(key, value);
    }

    @Override
    public GenericValue<String> getName() {
        SpringPropertyDefinition name = SpringPropertyUtils.findPropertyByName(this.getBean(), PERSISTENCE_UNIT_NAME);
        GenericDomValue<?> valueElement = name == null ? null : name.getValueElement();
        return valueElement != null && DomUtil.hasXml(valueElement) ? valueElement : this.getBean().getId();
    }

    @Override
    @Nullable
    public XmlTag getXmlTag() {
        return this.getBean().getXmlTag();
    }

    public DomSpringBean getBean() {
        return (DomSpringBean)((DomSpringBeanPointer)this.getBeanPointer()).getSpringBean();
    }

    protected <V extends PersistenceMappings> void addMappings(Collection<V> result2, Class<V> mappingsClass, SpringPropertyDefinition property, boolean directory) {
        if (!(property instanceof SpringProperty)) {
            return;
        }
        if (directory) {
            for (PsiDirectory psiDirectory : SpringResourcesUtil.getInstance().getResourceItems((SpringProperty)property, (Condition<PsiFileSystemItem>)FileReferenceSet.DIRECTORY_FILTER)) {
                this.addMappingsFromDirectory(result2, mappingsClass, psiDirectory);
            }
        } else {
            for (PsiFile psiFile : SpringResourcesUtil.getInstance().getResourceItems((SpringProperty)property, (Condition<PsiFileSystemItem>)FileReferenceSet.FILE_FILTER)) {
                ContainerUtil.addIfNotNull(result2, (Object)((PersistenceMappings)JamCommonUtil.getRootElement((PsiFile)psiFile, mappingsClass)));
            }
        }
    }

    @Override
    @NotNull
    public List<? extends PersistenceListener> getPersistentListeners() {
        List<PersistenceListener> list = super.getPersistentListeners();
        if (list == null) {
            SpringXmlPersistencePackage.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public GenericValue<String> getDataSourceName() {
        SpringBeanPointer<?> springBean;
        SpringPropertyDefinition property = SpringPropertyUtils.findPropertyByName(this.getBean(), DATASOURCE);
        if (property != null && (springBean = SpringPropertyUtils.findReferencedBean(property)) != null) {
            String name = springBean.getName();
            return StringUtil.isNotEmpty((String)name) ? ReadOnlyGenericValue.getInstance((Object)name) : null;
        }
        return null;
    }

    protected List<GenericValue<PsiPackage>> getPackagesToScan() {
        ArrayList<GenericValue<PsiPackage>> result2 = new ArrayList<GenericValue<PsiPackage>>();
        SpringPropertyDefinition packagesToScan = SpringPropertyUtils.findPropertyByName(this.getBean(), PACKAGES_TO_SCAN);
        if (packagesToScan instanceof SpringProperty) {
            SpringPropertyUtils.processSpringValues((SpringProperty)packagesToScan, (PairProcessor<? super GenericDomValue, ? super String>)((PairProcessor)(genericDomValue, s) -> {
                Object value = genericDomValue.getValue();
                Collection collection = value instanceof Collection ? (Collection)value : new PackageListConverter().fromString((String)s, ConvertContextFactory.createConvertContext((DomElement)genericDomValue));
                GlobalSearchScope scope = this.getBean().getResolveScope();
                for (Object pkg : collection) {
                    if (!(pkg instanceof PsiPackage)) continue;
                    SpringXmlPersistencePackage.processAllSubPackages((PsiPackage)pkg, scope, this.getPackagesCollectProcessor(result2));
                }
                return true;
            }));
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/persistence/integration/SpringXmlPersistencePackage";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingResourcesProperties";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFiles";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistenceUnitProperties";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/persistence/integration/SpringXmlPersistencePackage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPersistentListeners";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

