/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.profiles;

import com.intellij.facet.ProjectFacetListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.profiles.SpringProfilesService;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/profiles/SpringProfilesFacetListener;", "Lcom/intellij/facet/ProjectFacetListener;", "Lcom/intellij/spring/facet/SpringFacet;", "<init>", "()V", "facetAdded", "", "facet", "facetConfigurationChanged", "setActiveProfiles", "intellij.spring.core"})
final class SpringProfilesFacetListener
implements ProjectFacetListener<SpringFacet> {
    public void facetAdded(@NotNull SpringFacet facet) {
        Intrinsics.checkNotNullParameter((Object)((Object)facet), (String)"facet");
        this.setActiveProfiles(facet);
    }

    public void facetConfigurationChanged(@NotNull SpringFacet facet) {
        Intrinsics.checkNotNullParameter((Object)((Object)facet), (String)"facet");
        this.setActiveProfiles(facet);
    }

    private final void setActiveProfiles(SpringFacet facet) {
        Module module = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        Module module2 = module;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        SpringProfilesService profilesService = SpringProfilesService.Companion.getInstance(project);
        Set<String> activeProfiles = profilesService.getActiveProfiles(module2);
        if (activeProfiles.isEmpty()) {
            return;
        }
        Set<SpringFileSet> set = SpringFileSetService.getInstance().getAllSets(facet);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getAllSets(...)");
        Set<SpringFileSet> fileSets = set;
        if (fileSets.isEmpty()) {
            return;
        }
        for (SpringFileSet fileSet : fileSets) {
            fileSet.setActiveProfiles(activeProfiles);
        }
        profilesService.setActiveProfiles(module2, SetsKt.emptySet());
        SpringProfileUtils.notifyProfilesChanged(module2.getProject());
    }
}

