/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiFileIndexKt;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.PairProcessor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringSpiManagerImpl
extends SpringSpiManager {
    private final Module myModule;

    public SpringSpiManagerImpl(Module module) {
        this.myModule = module;
    }

    @Override
    public List<PropertiesFileImpl> getSpringFactoriesFiles(boolean includeTests) {
        return SpringCommonUtils.findConfigFilesInMetaInf(this.myModule, includeTests, "spring.factories", PropertiesFileImpl.class);
    }

    @Override
    public List<PsiClass> getClassesListValue(boolean includeTests, @NotNull String key) {
        if (key == null) {
            SpringSpiManagerImpl.$$$reportNull$$$0(0);
        }
        return SpringSpiFileIndexKt.getSpiIndexClasses(this.myModule.getProject(), this.getScope(includeTests), key);
    }

    @Override
    public List<PsiClass> getClassesListValue(@NotNull String key, @NotNull GlobalSearchScope scope) {
        if (key == null) {
            SpringSpiManagerImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            SpringSpiManagerImpl.$$$reportNull$$$0(2);
        }
        return SpringSpiFileIndexKt.getSpiIndexClasses(this.myModule.getProject(), scope, key);
    }

    @Override
    public boolean processClassesListValues(boolean includeTests, @Nullable String valueHint, PairProcessor<IProperty, PsiClass> processor2) {
        return SpringSpiFileIndexKt.processSpiIndexValues(this.myModule.getProject(), this.getScope(includeTests), valueHint, processor2);
    }

    @NotNull
    private GlobalSearchScope getScope(boolean includeTests) {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleRuntimeScope((Module)this.myModule, (boolean)includeTests);
        if (globalSearchScope == null) {
            SpringSpiManagerImpl.$$$reportNull$$$0(3);
        }
        return globalSearchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/spi/SpringSpiManagerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/spi/SpringSpiManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClassesListValue";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

