/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.lineProfiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profiler.PerformanceHintsManagerListener;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.lineProfiler.Dump;
import com.intellij.profiler.lineProfiler.LineProfilerBundle;
import com.intellij.profiler.lineProfiler.LineProfilerServiceKt;
import com.intellij.profiler.lineProfiler.LineProfilerState;
import com.intellij.profiler.lineProfiler.data.LineProfilerEventData;
import com.intellij.profiler.lineProfiler.data.LinesGroup;
import com.intellij.profiler.lineProfiler.data.SingleLineGroup;
import com.intellij.profiler.lineProfiler.lineMapping.IdLineMapping;
import com.intellij.profiler.lineProfiler.lineMapping.LineMapping;
import com.intellij.profiler.lineProfiler.lineMapping.LineMappingService;
import com.intellij.profiler.lineProfiler.lineMapping.LinesMapper;
import com.intellij.profiler.lineProfiler.lineMapping.MappingTask;
import com.intellij.profiler.lineProfiler.ui.LineHighlighter;
import com.intellij.profiler.ultimate.jfr.JFRProfilerData;
import com.intellij.profiler.ultimate.jfr.events.JfrEventGroup;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u0001:B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J\u0018\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J \u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\"\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u000b2\b\b\u0001\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\r\u0010\u000e\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b(J\u001d\u0010)\u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u0018\u0010-\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\fH\u0002J\u0010\u0010/\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u000bH\u0002J\u0010\u00101\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u000bH\u0002J\u0010\u00102\u001a\u00020\u00132\u0006\u00100\u001a\u00020\u000bH\u0002J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+H\u0002J\u000f\u00105\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b6J)\u00107\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010*\u001a\u00020+2\n\b\u0002\u00108\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b9R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006;"}, d2={"Lcom/intellij/profiler/lineProfiler/LineProfilerService;", "Lcom/intellij/profiler/PerformanceHintsManagerListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "dumps", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/profiler/lineProfiler/Dump;", "currentKey", "showAnnotations", "", "eventChoice", "Lcom/intellij/profiler/ultimate/jfr/events/JfrEventGroup;", "dispose", "", "isAvailable", "()Z", "onProfilerDumpOpen", "data", "Lcom/intellij/profiler/api/ProfilerData;", "dumpKey", "onProfilerDumpClosed", "onProfilerDumpSelectionChange", "show", "onEventSelectionChange", "newEventName", "", "closeAnnotationsInEditor", "editor", "Lcom/intellij/openapi/editor/Editor;", "closeAnnotationsInEditor$intellij_profiler_lineProfiler", "showAnnotations$intellij_profiler_lineProfiler", "hideAnnotations", "hideAnnotations$intellij_profiler_lineProfiler", "hasOpenMarkers", "hasOpenMarkers$intellij_profiler_lineProfiler", "canShowMarkers", "psiFile", "Lcom/intellij/psi/PsiFile;", "canShowMarkers$intellij_profiler_lineProfiler", "openDump", "newDump", "closeDump", "key", "hideDump", "resetClosedKey", "getLines", "Lcom/intellij/profiler/lineProfiler/data/LinesGroup;", "getCurrentDump", "getCurrentDump$intellij_profiler_lineProfiler", "showHeatMap", "dump", "showHeatMap$intellij_profiler_lineProfiler", "Companion", "intellij.profiler.lineProfiler"})
@SourceDebugExtension(value={"SMAP\nLineProfilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/LineProfilerService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,308:1\n1869#2,2:309\n1#3:311\n*S KotlinDebug\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/LineProfilerService\n*L\n125#1:309,2\n*E\n"})
public final class LineProfilerService
implements PerformanceHintsManagerListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<Object, Dump> dumps;
    @Nullable
    private Object currentKey;
    private boolean showAnnotations;
    @Nullable
    private JfrEventGroup eventChoice;

    public LineProfilerService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.dumps = new ConcurrentHashMap();
        this.showAnnotations = true;
    }

    public void dispose() {
        block2: {
            Set set = this.dumps.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.closeDump(it);
            }
            if (ApplicationManager.getApplication().isDisposed()) break block2;
            LineMappingService lineMappingService = LineMappingService.Companion.getInstanceOrNull();
            if (lineMappingService != null) {
                lineMappingService.clear(this.project);
            }
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public void onProfilerDumpOpen(@NotNull ProfilerData data, @NotNull Project project, @NotNull Object dumpKey) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dumpKey, (String)"dumpKey");
        if (data instanceof JFRProfilerData) {
            LineProfilerState state = new LineProfilerState((JFRProfilerData)data);
            JfrEventGroup jfrEventGroup = this.eventChoice;
            if (jfrEventGroup != null) {
                JfrEventGroup jfrEventGroup2;
                JfrEventGroup it = jfrEventGroup2 = jfrEventGroup;
                boolean bl = false;
                state.setCurrentGroup(it);
                this.eventChoice = null;
            }
            this.showAnnotations = true;
            this.openDump(dumpKey, new Dump(state, project, dumpKey, this.coroutineScope));
        } else {
            Object object = this.currentKey;
            if (object == null) {
                return;
            }
            Object currentKey = object;
            this.hideDump(currentKey);
            this.resetClosedKey(currentKey);
        }
    }

    public void onProfilerDumpClosed(@NotNull Project project, @NotNull Object dumpKey) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dumpKey, (String)"dumpKey");
        this.closeDump(dumpKey);
    }

    public void onProfilerDumpSelectionChange(@NotNull Project project, @NotNull Object dumpKey, boolean show) {
        boolean isCurrent;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dumpKey, (String)"dumpKey");
        boolean bl = isCurrent = dumpKey == this.currentKey;
        if (show == isCurrent) {
            return;
        }
        if (show) {
            Dump dump = this.dumps.get(dumpKey);
            if (dump == null) {
                return;
            }
            Dump dump2 = dump;
            dump2.clearMappings();
            this.openDump(dumpKey, dump2);
        } else {
            this.hideDump(dumpKey);
            this.resetClosedKey(dumpKey);
        }
    }

    public void onEventSelectionChange(@NotNull Project project, @NotNull Object dumpKey, @NlsSafe @NotNull String newEventName) {
        Object v0;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dumpKey, (String)"dumpKey");
            Intrinsics.checkNotNullParameter((Object)newEventName, (String)"newEventName");
            Iterable iterable = (Iterable)JfrEventGroup.getEntries();
            for (Object t : iterable) {
                JfrEventGroup it = (JfrEventGroup)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getGroupName(), (Object)newEventName)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        JfrEventGroup jfrEventGroup = v0;
        if (jfrEventGroup == null) {
            return;
        }
        JfrEventGroup group = jfrEventGroup;
        Object key = this.currentKey;
        if (key == null || key != dumpKey) {
            this.eventChoice = group;
            return;
        }
        Dump dump = this.dumps.get(key);
        if (dump == null) {
            return;
        }
        Dump dump2 = dump;
        dump2.getState().setCurrentGroup(group);
        this.openDump(key, dump2);
    }

    public final void closeAnnotationsInEditor$intellij_profiler_lineProfiler(@NotNull Editor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Dump dump = this.getCurrentDump$intellij_profiler_lineProfiler();
            if (dump == null) break block0;
            dump.closeEditor(editor);
        }
    }

    public final void showAnnotations$intellij_profiler_lineProfiler() {
        this.showAnnotations = true;
        Object object = this.currentKey;
        if (object == null) {
            return;
        }
        Object key = object;
        Dump dump = this.dumps.get(key);
        if (dump == null) {
            return;
        }
        Dump dump2 = dump;
        this.openDump(key, dump2);
    }

    public final void hideAnnotations$intellij_profiler_lineProfiler() {
        block0: {
            Object object;
            this.showAnnotations = false;
            Object object2 = this.currentKey;
            if (object2 == null) break block0;
            Object it = object = object2;
            boolean bl = false;
            this.hideDump(it);
        }
    }

    public final boolean hasOpenMarkers$intellij_profiler_lineProfiler(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Object object = this.getCurrentDump$intellij_profiler_lineProfiler();
        return object != null && (object = ((Dump)object).getOpenEditors()) != null ? object.contains(editor) : false;
    }

    public final boolean canShowMarkers$intellij_profiler_lineProfiler(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        LinesGroup linesGroup = this.getLines(editor, psiFile);
        Map<Integer, SingleLineGroup> map = linesGroup != null ? linesGroup.getLines() : null;
        return !(map == null || map.isEmpty());
    }

    private final void openDump(Object dumpKey, Dump newDump) {
        Object object;
        Object object2 = this.currentKey;
        if (object2 != null) {
            Object it = object = object2;
            boolean bl = false;
            this.hideDump(it);
        }
        ((Map)this.dumps).put(dumpKey, newDump);
        this.currentKey = dumpKey;
        if (!this.showAnnotations) {
            return;
        }
        Project project = this.project;
        object = LineProfilerBundle.message("loading.progress.label", new Object[0]);
        new Task.Backgroundable(this, newDump, project, (String)object){
            final /* synthetic */ LineProfilerService this$0;
            final /* synthetic */ Dump $newDump;
            {
                this.this$0 = $receiver;
                this.$newDump = $newDump;
                super($super_call_param$1, $super_call_param$2, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Object object = this.this$0.getCurrentDump$intellij_profiler_lineProfiler();
                if (object != null && (object = ((Dump)object).getState()) != null) {
                    ((LineProfilerState)object).calculateLineData$intellij_profiler_lineProfiler(indicator);
                }
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.$newDump.getProject());
                for (VirtualFile file : fileEditorManager.getOpenFiles()) {
                    List allEditors;
                    Intrinsics.checkNotNull((Object)file);
                    if (LineProfilerServiceKt.access$findPsiFile(file, this.$newDump.getProject()) == null) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager.getAllEditorList(file), (String)"getAllEditorList(...)");
                    for (E e : allEditors) {
                        PsiFile psiFile;
                        Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                        FileEditor editor = (FileEditor)e;
                        if (!(editor instanceof TextEditor)) continue;
                        Editor editor2 = ((TextEditor)editor).getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                        this.this$0.showHeatMap$intellij_profiler_lineProfiler(editor2, psiFile, this.$newDump);
                    }
                }
            }
        }.queue();
    }

    private final void closeDump(Object key) {
        this.hideDump(key);
        this.resetClosedKey(key);
        this.dumps.remove(key);
    }

    private final void hideDump(Object key) {
        Dump dump = this.dumps.get(key);
        if (dump == null) {
            return;
        }
        Dump dump2 = dump;
        Iterator<Editor> iterator = dump2.getOpenEditors().iterator();
        while (iterator.hasNext()) {
            Editor editor;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            dump2.closeEditor(editor);
        }
    }

    private final void resetClosedKey(Object key) {
        if (this.currentKey == key) {
            this.currentKey = null;
        }
    }

    private final LinesGroup getLines(Editor editor, PsiFile psiFile) {
        Dump dump = this.getCurrentDump$intellij_profiler_lineProfiler();
        if (dump == null) {
            return null;
        }
        Dump dump2 = dump;
        if (editor.getEditorKind() != EditorKind.MAIN_EDITOR) {
            return null;
        }
        LineProfilerEventData lineProfilerEventData = dump2.getState().getCurrentData();
        if (lineProfilerEventData == null) {
            return null;
        }
        LineProfilerEventData currentData = lineProfilerEventData;
        HashSet fqns = LineProfilerServiceKt.access$getTopLevelClasses(psiFile);
        if (fqns.isEmpty()) {
            return null;
        }
        LinesGroup originalLines = currentData.getMergedLines(fqns, dump2.getState().getTopLevelNames());
        if (originalLines.getLines().isEmpty()) {
            return null;
        }
        return originalLines;
    }

    @Nullable
    public final Dump getCurrentDump$intellij_profiler_lineProfiler() {
        Dump dump;
        Object object = this.currentKey;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            dump = this.dumps.get(it);
        } else {
            dump = null;
        }
        return dump;
    }

    public final void showHeatMap$intellij_profiler_lineProfiler(@NotNull Editor editor, @NotNull PsiFile psiFile, @Nullable Dump dump) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!this.showAnnotations) {
            return;
        }
        if (dump == null) {
            return;
        }
        if (dump.getKey() != this.currentKey) {
            return;
        }
        LinesGroup linesGroup = this.getLines(editor, psiFile);
        if (linesGroup == null) {
            return;
        }
        LinesGroup originalLines = linesGroup;
        LinesMapper linesMapper = dump.getOrCreateMapper(editor);
        LineMapping mapping = linesMapper.mapLinesFast();
        if (mapping == null) {
            String string = psiFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            MappingTask task = new MappingTask(string, linesMapper, (Function1<? super LineMapping, Unit>)((Function1)arg_0 -> LineProfilerService.showHeatMap$lambda$6(dump, editor, arg_0)));
            LineMappingService.Companion.getInstance().submit(task, this.project);
            mapping = IdLineMapping.INSTANCE;
        }
        LineHighlighter.update$default(dump.getOrCreateHighlighter(editor, originalLines, mapping, (Function0<? extends DocumentListener>)((Function0)() -> LineProfilerService.showHeatMap$lambda$7(linesMapper, dump, editor))), null, null, 3, null);
    }

    public static /* synthetic */ void showHeatMap$intellij_profiler_lineProfiler$default(LineProfilerService lineProfilerService, Editor editor, PsiFile psiFile, Dump dump, int n, Object object) {
        if ((n & 4) != 0) {
            dump = lineProfilerService.getCurrentDump$intellij_profiler_lineProfiler();
        }
        lineProfilerService.showHeatMap$intellij_profiler_lineProfiler(editor, psiFile, dump);
    }

    private static final Unit showHeatMap$lambda$6(Dump $dump, Editor $editor, LineMapping it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            LineHighlighter lineHighlighter = $dump.getHighlighter($editor);
            if (lineHighlighter == null) break block0;
            LineHighlighter.update$default(lineHighlighter, it, null, 2, null);
        }
        return Unit.INSTANCE;
    }

    private static final DocumentListener showHeatMap$lambda$7(LinesMapper $linesMapper, Dump $dump, Editor $editor) {
        return new DocumentListener($linesMapper, $dump, $editor){
            final /* synthetic */ LinesMapper $linesMapper;
            final /* synthetic */ Dump $dump;
            final /* synthetic */ Editor $editor;
            {
                this.$linesMapper = $linesMapper;
                this.$dump = $dump;
                this.$editor = $editor;
            }

            public void documentChanged(DocumentEvent event) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$linesMapper.clear();
                    LineHighlighter lineHighlighter = this.$dump.getHighlighter(this.$editor);
                    if (lineHighlighter == null) break block1;
                    LineMapping lineMapping = this.$linesMapper.mapLinesFast();
                    if (lineMapping == null) {
                        lineMapping = IdLineMapping.INSTANCE;
                    }
                    lineHighlighter.update(lineMapping, event);
                }
            }
        };
    }

    @JvmStatic
    @NotNull
    public static final LineProfilerService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @Nullable
    public static final LineProfilerService getInstanceOrNull(@NotNull Project project) {
        return Companion.getInstanceOrNull(project);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/lineProfiler/LineProfilerService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/profiler/lineProfiler/LineProfilerService;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceOrNull", "intellij.profiler.lineProfiler"})
    @SourceDebugExtension(value={"SMAP\nLineProfilerService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/LineProfilerService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,308:1\n30#2,2:309\n58#2:311\n*S KotlinDebug\n*F\n+ 1 LineProfilerService.kt\ncom/intellij/profiler/lineProfiler/LineProfilerService$Companion\n*L\n280#1:309,2\n283#1:311\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LineProfilerService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LineProfilerService> serviceClass$iv = LineProfilerService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LineProfilerService)object;
        }

        @JvmStatic
        @Nullable
        public final LineProfilerService getInstanceOrNull(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
            boolean $i$f$serviceIfCreated = false;
            return (LineProfilerService)$this$serviceIfCreated$iv.getServiceIfCreated(LineProfilerService.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

