import React from 'react';
import { Operation } from './Operation';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { OPERATIONS_TEXT } from '../../constants';
export var Operations = function () {
    var operations = useSpec().operations().all();
    var config = useConfig();
    if (!Object.keys(operations).length) {
        return null;
    }
    var operationsList = operations.map(function (operation) {
        var _a;
        var channel = operation.channels().all()[0];
        var channelAddress = (_a = channel === null || channel === void 0 ? void 0 : channel.address()) !== null && _a !== void 0 ? _a : '';
        var operationId = CommonHelpers.getOperationIdentifier({
            operation: operation,
            config: config,
        });
        var type = CommonHelpers.getOperationType(operation);
        return (React.createElement("li", { className: "mb-12", key: "".concat(type, "-").concat(operation.id()), id: operationId },
            React.createElement(Operation, { type: type, operation: operation, channelName: channelAddress, channel: channel })));
    });
    return (React.createElement("section", { id: "".concat(CommonHelpers.getIdentifier('operations', config)), className: "mt-16" },
        React.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, OPERATIONS_TEXT),
        React.createElement("ul", null, operationsList)));
};
//# sourceMappingURL=Operations.js.map