/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.ws;

import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.CallbackHandler;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.ws.WsCallbackBasedSocket;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocketQueued;", "Lorg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocket;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "getWebSockets", "Lkotlin/Function0;", "", "Lorg/java_websocket/WebSocket;", "channel", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;)V", "logger", "Lorg/slf4j/Logger;", "messages", "Ljava/util/concurrent/ArrayBlockingQueue;", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "messageReceived", "", "msg", "startListening", "Ljava/lang/Thread;", "mainListenerThread", "ws-server"})
final class WsCallbackBasedSocketQueued
extends WsCallbackBasedSocket {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ArrayBlockingQueue<RawMessage> messages;

    public WsCallbackBasedSocketQueued(@NotNull KernelLoggerFactory loggerFactory, @NotNull Function0<? extends Iterable<? extends WebSocket>> getWebSockets, @NotNull JupyterSocketType channel) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter(getWebSockets, (String)"getWebSockets");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        super(loggerFactory, getWebSockets, channel);
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        this.messages = new ArrayBlockingQueue(256);
    }

    @Override
    public void messageReceived(@NotNull RawMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.messages.offer(msg);
    }

    @NotNull
    public final Thread startListening(@NotNull Thread mainListenerThread) {
        Intrinsics.checkNotNullParameter((Object)mainListenerThread, (String)"mainListenerThread");
        return ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)("WsCallbackBasedSocketQueued(" + this.getChannel() + ")"), (int)0, () -> WsCallbackBasedSocketQueued.startListening$lambda$0(this, mainListenerThread), (int)23, null);
    }

    private static final Unit startListening$lambda$0(WsCallbackBasedSocketQueued this$0, Thread $mainListenerThread) {
        try {
            while (true) {
                RawMessage message = this$0.messages.take();
                CallbackHandler<RawMessage> callbackHandler = this$0.getCallbacks();
                Intrinsics.checkNotNull((Object)message);
                callbackHandler.runCallbacks((Object)message);
            }
        }
        catch (InterruptedException interruptedException) {
            $mainListenerThread.interrupt();
        }
        catch (Throwable e) {
            this$0.logger.error("Error during message processing", e);
        }
        return Unit.INSTANCE;
    }
}

