/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.repel;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.geom.repel.DoubleVectorExtensions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/repel/DoubleCircle;", "", "center", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "radius", "", "(Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;D)V", "getCenter", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "getRadius", "()D", "intersects", "", "line", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleSegment;", "plot-base"})
public final class DoubleCircle {
    @NotNull
    private final DoubleVector center;
    private final double radius;

    public DoubleCircle(@NotNull DoubleVector center, double radius) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        this.center = center;
        this.radius = radius;
    }

    @NotNull
    public final DoubleVector getCenter() {
        return this.center;
    }

    public final double getRadius() {
        return this.radius;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean intersects(@NotNull DoubleSegment line2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line");
        if (line2.getStart().subtract(this.center).length() <= this.radius) return true;
        if (line2.getEnd().subtract(this.center).length() <= this.radius) {
            return true;
        }
        DoubleVector d = line2.getEnd().subtract(line2.getStart());
        DoubleVector f = line2.getStart().subtract(this.center);
        double a2 = DoubleVectorExtensions.INSTANCE.dot(d, d);
        double b2 = (double)2 * DoubleVectorExtensions.INSTANCE.dot(f, d);
        double c = DoubleVectorExtensions.INSTANCE.dot(f, f) - this.radius * this.radius;
        double discriminant = b2 * b2 - (double)4 * a2 * c;
        double sqrtDiscriminant = Math.sqrt(discriminant);
        double t1 = (-b2 - sqrtDiscriminant) / ((double)2 * a2);
        double t2 = (-b2 + sqrtDiscriminant) / ((double)2 * a2);
        if (0.0 <= t1) {
            if (t1 <= 1.0) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        if (!(0.0 <= t2)) return false;
        if (!(t2 <= 1.0)) return false;
        return true;
    }
}

