/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.freemarker.psi.FtlCompositeElement;
import com.intellij.freemarker.psi.FtlCompositeElementTypes;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlReferenceExpression;
import com.intellij.freemarker.psi.FtlTokenType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nullable;

public class FtlNameValuePair
extends FtlCompositeElement {
    public FtlNameValuePair(ASTNode node) {
        super(node);
    }

    @Nullable
    public PsiElement getNameElement() {
        PsiElement attrName = this.findChildByType(FtlCompositeElementTypes.ATTRIBUTE_NAME);
        if (attrName != null) {
            return attrName;
        }
        return (PsiElement)this.findChildByClass(FtlReferenceExpression.class);
    }

    public boolean isAssignment() {
        FtlTokenType op = this.getOperationToken();
        return op == FtlElementTypes.EQ || op == FtlElementTypes.OPERATION_ASSIGNMENT;
    }

    @Nullable
    public FtlTokenType getOperationToken() {
        PsiElement child = this.getNameElement();
        if (child == null) {
            return null;
        }
        while ((child = child.getNextSibling()) instanceof PsiWhiteSpace || child instanceof PsiErrorElement) {
        }
        IElementType type = PsiUtilCore.getElementType((PsiElement)child);
        if (TokenSet.create((IElementType[])new IElementType[]{FtlElementTypes.EQ, FtlElementTypes.PLUS_PLUS, FtlElementTypes.MINUS_MINUS, FtlElementTypes.OPERATION_ASSIGNMENT}).contains(type)) {
            return (FtlTokenType)type;
        }
        return null;
    }

    @Nullable
    public PsiElement getValueElement() {
        return this.isAssignment() ? this.getLastChild() : null;
    }

    @Nullable
    public String getName() {
        PsiElement element = this.getNameElement();
        return element == null ? null : element.getText();
    }

    public void setPairName(String name) throws IncorrectOperationException {
        PsiElement element = this.getNameElement();
        assert (element != null);
        PsiReference reference = element.getReference();
        if (reference != null) {
            reference.handleElementRename(name);
        }
    }
}

