/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonProperty;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonCommonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.CallSite;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class PackageJsonUtil {
    @NlsSafe
    public static final String FILE_NAME = "package.json";
    @NlsSafe
    public static final String DEPENDENCIES = "dependencies";
    @NlsSafe
    public static final String DEV_DEPENDENCIES = "devDependencies";
    @ApiStatus.Internal
    public static final String MODULE_TYPE = "module";
    @ApiStatus.Internal
    public static final String COMMONJS_TYPE = "commonjs";
    public static final List<String> PROD_DEV_DEPENDENCIES = List.of("dependencies", "devDependencies");
    private static final Logger LOG = Logger.getInstance(PackageJsonUtil.class);

    private PackageJsonUtil() {
    }

    @Deprecated
    @Contract(value="null -> null")
    @Nullable
    public static JsonFile asPackageJsonFile(@Nullable PsiFile file) {
        return PackageJsonCommonUtil.asPackageJsonFile((PsiFile)file);
    }

    @Deprecated
    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable PsiFile file) {
        return PackageJsonCommonUtil.isPackageJsonFile((PsiFile)file);
    }

    public static void processUpPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(0);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(2);
        }
        JSProjectUtil.processDirectoriesUpToContentRoot(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)directory -> {
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(directory);
            return packageJson == null || processor.process((Object)packageJson);
        }));
    }

    @Nullable
    public static <T> T processUpPackageJsonFilesAndFindFirst(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Function<? super VirtualFile, T> packageJsonProcessor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(3);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(4);
        }
        if (packageJsonProcessor == null) {
            PackageJsonUtil.$$$reportNull$$$0(5);
        }
        Ref result2 = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<? super VirtualFile>)((Processor)packageJson -> {
            result2.set(packageJsonProcessor.fun(packageJson));
            return result2.isNull();
        }));
        return (T)result2.get();
    }

    @Nullable
    public static VirtualFile findUpPackageJson(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(6);
        }
        Ref ref2 = Ref.create();
        PackageJsonUtil.processUpPackageJsonFilesInAllScope(fileOrDir, (Processor<? super VirtualFile>)((Processor)file -> {
            ref2.set(file);
            return false;
        }));
        return (VirtualFile)ref2.get();
    }

    public static void processUpPackageJsonFilesInAllScope(@NotNull VirtualFile fileOrDir, @NotNull Processor<? super VirtualFile> processor) {
        VirtualFile dir;
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(8);
        }
        VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
        if (dir == null) {
            return;
        }
        while (dir != null) {
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(dir);
            if (packageJson != null && !processor.process((Object)packageJson)) {
                return;
            }
            dir = dir.getParent();
        }
    }

    @Deprecated
    @NotNull
    public static List<JsonProperty> getDependencies(@NotNull JsonFile packageJson, @NotNull Collection<String> enclosingParentAttributes) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(9);
        }
        if (enclosingParentAttributes == null) {
            PackageJsonUtil.$$$reportNull$$$0(10);
        }
        List list = PackageJsonCommonUtil.getDependencies((JsonFile)packageJson, enclosingParentAttributes);
        if (list == null) {
            PackageJsonUtil.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Deprecated
    @Nullable
    public static JsonProperty findDependencyByName(@NotNull JsonFile packageJson, @NotNull String dependencyName) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(12);
        }
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(13);
        }
        return PackageJsonCommonUtil.findDependencyByName((JsonFile)packageJson, (String)dependencyName);
    }

    public static boolean isPackageJsonWithTopLevelProperty(@NotNull VirtualFile packageJson, String property) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(14);
        }
        return PackageJsonCommonUtil.isPackageJsonFile((VirtualFile)packageJson) && PackageJsonData.getOrCreate(packageJson).getTopLevelProperties().contains(property);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(15);
        }
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
        if (packageJsonData == null) {
            PackageJsonUtil.$$$reportNull$$$0(16);
        }
        return packageJsonData;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(17);
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return null;
        }
        VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(project.getBaseDir());
        return packageJson == null ? null : PackageJsonData.getOrCreate(packageJson);
    }

    public static ThreeState isVersionGreaterOrEqualMajor(@NotNull String versionText, int major) {
        if (versionText == null) {
            PackageJsonUtil.$$$reportNull$$$0(18);
        }
        if ("latest".equals(versionText)) {
            return ThreeState.YES;
        }
        String[] parts = versionText.split("\\s-\\s");
        if (parts.length == 2) {
            String part = parts[1];
            if (PackageJsonUtil.isAny((part = StringUtil.trimStart((String)part, (String)"v")).charAt(0))) {
                return ThreeState.YES;
            }
            int parsedMajor = PackageJsonUtil.getMajorVersion(part);
            if (parsedMajor >= 0) {
                return parsedMajor >= major ? ThreeState.YES : ThreeState.NO;
            }
            return ThreeState.UNSURE;
        }
        ArrayList<Pair> versionWords = new ArrayList<Pair>();
        StringBuilder sb = new StringBuilder();
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < versionText.length(); ++i) {
            char ch = versionText.charAt(i);
            if (Character.isDigit(ch) || '.' == ch || '*' == ch || 'v' == ch || 'x' == ch || 'X' == ch) {
                sb.append(ch);
                continue;
            }
            if (!sb.isEmpty()) {
                versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
                sb.setLength(0);
                prefixBuilder.setLength(0);
            }
            prefixBuilder.append(ch);
        }
        if (!sb.isEmpty()) {
            versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
        }
        if (versionWords.isEmpty()) {
            return ThreeState.UNSURE;
        }
        boolean greaterThanLess = false;
        boolean lessThanGreater = false;
        for (Pair pair : versionWords) {
            int parsedMajor;
            String word = (String)pair.getSecond();
            word = StringUtil.trimStart((String)word, (String)"v");
            String prefix = (String)pair.getFirst();
            if (!PackageJsonUtil.isPrefixValid(prefix)) {
                return ThreeState.UNSURE;
            }
            if (word.isEmpty()) continue;
            if (PackageJsonUtil.isAny(word.charAt(0))) {
                lessThanGreater = true;
            }
            if ((parsedMajor = PackageJsonUtil.getMajorVersion(word)) < 0) continue;
            if (parsedMajor >= major) {
                char before;
                if (parsedMajor == major && (before = PackageJsonUtil.getVersionComparator(prefix)) == '<') {
                    return ThreeState.NO;
                }
                lessThanGreater = true;
                continue;
            }
            if (PackageJsonUtil.getVersionComparator(prefix) != '>') continue;
            greaterThanLess = true;
        }
        if (greaterThanLess || lessThanGreater) {
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static int getMajorVersion(@NotNull String version2) {
        int idx;
        if (version2 == null) {
            PackageJsonUtil.$$$reportNull$$$0(19);
        }
        if ((idx = version2.indexOf(".")) < 0) {
            return StringUtil.parseInt((String)version2, (int)-1);
        }
        return StringUtil.parseInt((String)version2.substring(0, idx), (int)-1);
    }

    private static boolean isPrefixValid(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(20);
        }
        if (prefix.isEmpty()) {
            return true;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch) || ch == '<' || ch == '>' || ch == '=' || ch == '~' || ch == '^' || ch == '|') continue;
            return false;
        }
        return true;
    }

    private static boolean isAny(char first) {
        return first == '*' || first == 'x' || first == 'X';
    }

    private static char getVersionComparator(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(21);
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '=' && i > 0) {
                return prefix.charAt(i - 1);
            }
            return ch;
        }
        return ' ';
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findChildPackageJsonFile(@Nullable VirtualFile dir) {
        VirtualFile packageJson;
        if (dir != null && dir.isValid() && (packageJson = dir.findChild(FILE_NAME)) != null && packageJson.isValid() && !packageJson.isDirectory()) {
            return packageJson;
        }
        return null;
    }

    @NotNull
    public static String guessDefaultBinaryNameOfDependency(@NotNull NodePackage pkg) {
        if (pkg == null) {
            PackageJsonUtil.$$$reportNull$$$0(22);
        }
        Path pathToPachageJson = null;
        try {
            pathToPachageJson = Path.of(pkg.getSystemDependentPath(), FILE_NAME);
        }
        catch (InvalidPathException ignored) {
            LOG.debug("Cannot guess default binary name of dependency for '" + pkg.getName() + "' because of invalid path: '" + pkg.getSystemDependentPath() + "'");
        }
        VirtualFile packageJson = null;
        if (pathToPachageJson != null) {
            packageJson = LocalFileSystem.getInstance().findFileByNioFile(pathToPachageJson);
        }
        return PackageJsonUtil.guessDefaultBinaryNameOfDependency(packageJson, pkg.getName());
    }

    @NotNull
    public static String guessDefaultBinaryNameOfDependency(@Nullable VirtualFile dependencyPackageJson, @NotNull String dependencyName) {
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(23);
        }
        List<String> declaredBinaryNames = PackageJsonUtil.getDeclaredBinaryNames(dependencyPackageJson);
        List<String> candidateBinaryNames = PackageJsonUtil.getCandidateBinaryNames(dependencyName);
        for (String candidateBinaryName : candidateBinaryNames) {
            if (!declaredBinaryNames.contains(candidateBinaryName)) continue;
            String string = candidateBinaryName;
            if (string == null) {
                PackageJsonUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        if (declaredBinaryNames.size() == 1) {
            String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(declaredBinaryNames));
            if (string == null) {
                PackageJsonUtil.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = Objects.requireNonNull((String)ContainerUtil.getFirstItem(candidateBinaryNames));
        if (string == null) {
            PackageJsonUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static @Unmodifiable List<String> getDeclaredBinaryNames(@Nullable VirtualFile packageJson) {
        if (packageJson == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PackageJsonUtil.$$$reportNull$$$0(27);
            }
            return list;
        }
        PackageJsonData data2 = PackageJsonData.getOrCreate(packageJson);
        List list = ContainerUtil.filter(data2.getBinaryNameToPathMap().keySet(), Objects::nonNull);
        if (list == null) {
            PackageJsonUtil.$$$reportNull$$$0(28);
        }
        return list;
    }

    @NotNull
    private static List<String> getCandidateBinaryNames(@NotNull String dependencyName) {
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(29);
        }
        if (!NodeModuleSearchUtil.isScopedPackageName(dependencyName)) {
            List<String> list = Collections.singletonList(dependencyName);
            if (list == null) {
                PackageJsonUtil.$$$reportNull$$$0(30);
            }
            return list;
        }
        String scope2 = Objects.requireNonNull(NodeModuleSearchUtil.getScopeByScopedPackageName(dependencyName));
        String name = Objects.requireNonNull(NodeModuleSearchUtil.getNameByScopedPackageName(dependencyName));
        List<CallSite> list = List.of(name, scope2 + "-" + name);
        if (list == null) {
            PackageJsonUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 16, 24, 25, 26, 27, 28, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonProcessor";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingParentAttributes";
                break;
            }
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 13: 
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateData";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "guessDefaultBinaryNameOfDependency";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredBinaryNames";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidateBinaryNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFilesAndFindFirst";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findUpPackageJson";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFilesInAllScope";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 11: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyByName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPackageJsonWithTopLevelProperty";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateData";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelPackageJsonData";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqualMajor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixValid";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getVersionComparator";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "guessDefaultBinaryNameOfDependency";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getCandidateBinaryNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 16, 24, 25, 26, 27, 28, 30, 31 -> new IllegalStateException(string);
        };
    }
}

