/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.stubs.factories;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSElementTypesImpl;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.psi.JSElementType;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.impl.JSCallExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSParenthesizedExpressionImpl;
import com.intellij.lang.javascript.psi.impl.JSReturnStatementImpl;
import com.intellij.lang.javascript.psi.stubs.JSReturnStatementStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSReturnStatementStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.stubs.factories.JSStubFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00032\u0010\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\n\u0018\u00010\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/stubs/factories/JSReturnStatementStubFactory;", "Lcom/intellij/lang/javascript/stubs/factories/JSStubFactory;", "Lcom/intellij/lang/javascript/psi/stubs/JSReturnStatementStub;", "Lcom/intellij/lang/javascript/psi/JSReturnStatement;", "<init>", "()V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "isAcceptableLanguage", "language", "Lcom/intellij/lang/Language;", "isIIFE", "expressionNode", "intellij.javascript.analysis.impl"})
public final class JSReturnStatementStubFactory
extends JSStubFactory<JSReturnStatementStub, JSReturnStatement> {
    public JSReturnStatementStubFactory() {
        super(JSReturnStatementStubFactory::_init_$lambda$0);
    }

    @NotNull
    public JSReturnStatementStub createStub(@NotNull JSReturnStatement psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return new JSReturnStatementStubImpl(psi, parentStub);
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Language language = JSTreeUtil.getLanguage((ASTNode)node);
        if (!this.isAcceptableLanguage(language)) {
            return false;
        }
        ASTNode expressionNode = JSReturnStatementImpl.getExpressionNode((ASTNode)node);
        return expressionNode != null && (expressionNode.getElementType() == JSElementTypes.OBJECT_LITERAL_EXPRESSION || JSElementTypes.FUNCTION_EXPRESSIONS.contains(expressionNode.getElementType()) || this.isIIFE(expressionNode));
    }

    private final boolean isAcceptableLanguage(Language language) {
        if (!(language instanceof JSLanguageDialect)) {
            return false;
        }
        return !((JSLanguageDialect)language).getOptionHolder().isECMA4;
    }

    private final boolean isIIFE(ASTNode expressionNode) {
        if (expressionNode.getElementType() != JSElementTypes.CALL_EXPRESSION) {
            return false;
        }
        ASTNode methodExpression = JSCallExpressionImpl.getMethodExpression((ASTNode)expressionNode);
        while (methodExpression != null && methodExpression.getElementType() == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            methodExpression = JSParenthesizedExpressionImpl.getInnerExpression((ASTNode)methodExpression);
        }
        return methodExpression != null && JSElementTypes.FUNCTION_EXPRESSIONS.contains(methodExpression.getElementType());
    }

    private static final JSElementType _init_$lambda$0() {
        return JSElementTypesImpl.RETURN_STATEMENT;
    }
}

