/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicatorBase;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import com.intellij.openapi.util.registry.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyProgressIndicator
extends EmptyProgressIndicatorBase
implements StandardProgressIndicator {
    @Nullable
    private volatile Throwable myCancellationRequester;
    private static final Throwable PLACEHOLDER = new Throwable("Dummy throwable that indicates cancellation of EmptyProgressIndicator.\nSet `ide.rich.cancellation.traces` to `true` to get real origin of cancellation.");

    @ApiStatus.Obsolete
    @Contract(pure=true)
    public EmptyProgressIndicator() {
    }

    @ApiStatus.Obsolete
    public EmptyProgressIndicator(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            EmptyProgressIndicator.$$$reportNull$$$0(0);
        }
        super(modalityState);
    }

    @Override
    public void start() {
        super.start();
        this.myCancellationRequester = null;
    }

    @Override
    public final void cancel() {
        this.myCancellationRequester = Registry.is("ide.rich.cancellation.traces", false) ? new Throwable("Origin of cancellation of " + this) : PLACEHOLDER;
        ProgressManager.canceled(this);
    }

    @Nullable
    final Throwable getCancellationCause() {
        return this.myCancellationRequester;
    }

    @Override
    public final boolean isCanceled() {
        return this.myCancellationRequester != null;
    }

    @Deprecated
    @NotNull
    public static ProgressIndicator notNullize(@Nullable ProgressIndicator indicator) {
        return indicator != null ? indicator : new EmptyProgressIndicator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/EmptyProgressIndicator", "<init>"));
    }
}

