/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.secret;

import com.intellij.kubernetes.view.ui.secret.SecretEntry;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0004\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/view/ui/secret/FileSecretEntry;", "Lcom/intellij/kubernetes/view/ui/secret/SecretEntry;", "key", "", "path", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "Ljava/nio/file/Path;", "getPath", "()Ljava/nio/file/Path;", "fileBytes", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
public final class FileSecretEntry
extends SecretEntry {
    public FileSecretEntry(@NotNull String key, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        super(key, path, null);
    }

    @NotNull
    public final Path getPath() {
        Path path = Paths.get(this.getPresentationValue(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    @Nullable
    public final Object fileBytes(@NotNull Continuation<? super byte[]> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super byte[]>, Object>(this, null){
            int label;
            final /* synthetic */ FileSecretEntry this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        LinkOption[] linkOptionArray = new LinkOption[]{};
                        if (!Files.exists(this.this$0.getPath(), Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                            File file = this.this$0.getPath().toFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
                            throw new NoSuchFileException(file, null, "failed add a secret entry, because the selected value file doesn't exist", 2, null);
                        }
                        byte[] byArray = Files.readAllBytes(this.this$0.getPath());
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
                        return byArray;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super byte[]> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }
}

