/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.dependencies;

import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.FileTreeDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ModuleDependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.ReferenceTo;
import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencySpecImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.FileTreeDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.dependencies.PlatformArtifactDependencyModelImpl;
import com.android.tools.idea.gradle.dsl.model.ext.PropertyUtil;
import com.android.tools.idea.gradle.dsl.parser.dependencies.DependenciesDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslClosure;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslMethodCall;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractDependenciesModel
extends GradleDslBlockModel
implements DependenciesModel {
    public static final Logger LOG = Logger.getInstance(AbstractDependenciesModel.class);
    private static final Map<String, Function<ArtifactDependencySpec, String>> COMPONENT_MAP = ImmutableMap.builder().put((Object)"name", ArtifactDependencySpec::getName).put((Object)"group", ArtifactDependencySpec::getGroup).put((Object)"version", ArtifactDependencySpec::getVersion).put((Object)"ext", ArtifactDependencySpec::getExtension).put((Object)"classifier", ArtifactDependencySpec::getClassifier).build();

    public AbstractDependenciesModel(@NotNull DependenciesDslElement dslElement) {
        if (dslElement == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(0);
        }
        super(dslElement);
    }

    @Override
    @NotNull
    public List<DependencyModel> all() {
        return this.all(null, this.getAllFetcher());
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts(@NotNull String configurationName) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(1);
        }
        return this.all(configurationName, this.getArtifactFetcher());
    }

    protected abstract Fetcher<ArtifactDependencyModel> getArtifactFetcher();

    protected abstract Fetcher<ModuleDependencyModel> getModuleFetcher();

    protected abstract Fetcher<FileTreeDependencyModel> getFileTreeFetcher();

    protected abstract Fetcher<FileDependencyModel> getFileFetcher();

    protected Fetcher<DependencyModel> getAllFetcher() {
        return (configurationName, element, resolved, configurationElement, maintainer, dest) -> {
            this.getArtifactFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
            this.getModuleFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
            this.getFileFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
            this.getFileTreeFetcher().fetch(configurationName, element, resolved, configurationElement, maintainer, dest);
        };
    }

    @Override
    @NotNull
    public List<ArtifactDependencyModel> artifacts() {
        return this.all(null, this.getArtifactFetcher());
    }

    @Override
    public boolean containsArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(2);
        }
        if (dependency == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(3);
        }
        for (ArtifactDependencyModel artifactDependencyModel : this.artifacts(configurationName)) {
            if (!ArtifactDependencySpecImpl.create(artifactDependencyModel).equals(dependency)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull String compactNotation) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(4);
        }
        if (compactNotation == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(5);
        }
        this.addArtifact(configurationName, compactNotation, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull String compactNotation, @NotNull List<ArtifactDependencySpec> excludes) {
        ArtifactDependencySpecImpl dependency;
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(6);
        }
        if (compactNotation == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(7);
        }
        if (excludes == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(8);
        }
        if ((dependency = ArtifactDependencySpecImpl.create(compactNotation)) == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            LOG.warn(msg);
            return;
        }
        this.addArtifact(configurationName, dependency, excludes);
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(9);
        }
        if (reference == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(10);
        }
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference, @NotNull List<ArtifactDependencySpec> excludes) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(11);
        }
        if (reference == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(12);
        }
        if (excludes == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(13);
        }
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, excludes);
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(14);
        }
        if (dependency == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(15);
        }
        this.addArtifact(configurationName, dependency, Collections.emptyList());
    }

    @Override
    public void addArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, @NotNull List<ArtifactDependencySpec> excludes) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(16);
        }
        if (dependency == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(17);
        }
        if (excludes == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(18);
        }
        ArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, dependency, excludes);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull String compactNotation, boolean enforced) {
        ArtifactDependencySpecImpl dependency;
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(19);
        }
        if (compactNotation == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(20);
        }
        if ((dependency = ArtifactDependencySpecImpl.create(compactNotation)) == null) {
            String msg = String.format("'%1$s' is not a valid artifact dependency", compactNotation);
            LOG.warn(msg);
            return;
        }
        this.addPlatformArtifact(configurationName, dependency, enforced);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull ReferenceTo reference, boolean enforced) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(21);
        }
        if (reference == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(22);
        }
        PlatformArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, reference, enforced);
    }

    @Override
    public void addPlatformArtifact(@NotNull String configurationName, @NotNull ArtifactDependencySpec dependency, boolean enforced) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(23);
        }
        if (dependency == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(24);
        }
        PlatformArtifactDependencyModelImpl.createNew(this.myDslElement, configurationName, dependency, enforced);
    }

    @Override
    public boolean replaceArtifactByPsiElement(@NotNull PsiElement psiElement, @NotNull ArtifactDependencySpec dependency) {
        GradleDslElement element;
        if (psiElement == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(25);
        }
        if (dependency == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(26);
        }
        if ((element = this.findByPsiElement(psiElement)) == null) {
            return false;
        }
        this.getDependencyReplacer().performDependencyReplace(psiElement, element, dependency);
        return true;
    }

    @Nullable
    protected abstract GradleDslElement findByPsiElement(@NotNull PsiElement var1);

    protected abstract DependencyReplacer getDependencyReplacer();

    @Override
    @NotNull
    public List<ModuleDependencyModel> modules() {
        return this.all(null, this.getModuleFetcher());
    }

    @Override
    public void addModule(@NotNull String configurationName, @NotNull String path) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(27);
        }
        if (path == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(28);
        }
        this.addModule(configurationName, path, null);
    }

    @Override
    @NotNull
    @TestOnly
    public List<FileTreeDependencyModel> fileTrees() {
        return this.all(null, this.getFileTreeFetcher());
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(29);
        }
        if (dir == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(30);
        }
        this.addFileTree(configurationName, dir, null, null);
    }

    @Override
    public void addFileTree(@NotNull String configurationName, @NotNull String dir, @Nullable List<String> includes, @Nullable List<String> excludes) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(31);
        }
        if (dir == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(32);
        }
        FileTreeDependencyModelImpl.createNew(this.myDslElement, configurationName, dir, includes, excludes);
    }

    @Override
    @NotNull
    @TestOnly
    public List<FileDependencyModel> files() {
        return this.all(null, this.getFileFetcher());
    }

    @Override
    public void addFile(@NotNull String configurationName, @NotNull String file) {
        if (configurationName == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(33);
        }
        if (file == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(34);
        }
        FileDependencyModelImpl.createNew(this.myDslElement, configurationName, file);
    }

    @Override
    public void remove(@NotNull DependencyModel dependency) {
        if (dependency == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(35);
        }
        if (!(dependency instanceof DependencyModelImpl)) {
            LOG.warn("Tried to remove an unknown dependency type: " + String.valueOf(dependency));
            return;
        }
        GradleDslElement dependencyElement = ((DependencyModelImpl)dependency).getDslElement();
        GradleDslElement parent = dependencyElement.getParent();
        if (parent instanceof GradleDslMethodCall) {
            GradleDslMethodCall methodCall = (GradleDslMethodCall)parent;
            List<GradleDslExpression> arguments = methodCall.getArguments();
            if (arguments.size() == 1 && arguments.get(0).equals(dependencyElement)) {
                this.myDslElement.removeProperty(methodCall);
            } else {
                methodCall.remove(dependencyElement);
            }
        } else if (parent instanceof GradleDslExpressionList) {
            List<GradleDslExpression> expressions = ((GradleDslExpressionList)parent).getExpressions();
            if (expressions.size() == 1 && expressions.get(0).equals(dependencyElement)) {
                if (parent.getParent() instanceof GradleDslMethodCall) {
                    this.myDslElement.removeProperty(parent.getParent());
                } else {
                    this.myDslElement.removeProperty(parent);
                }
            } else {
                ((GradleDslExpressionList)parent).removeElement(dependencyElement);
            }
        } else {
            this.myDslElement.removeProperty(dependencyElement);
        }
    }

    @NotNull
    private <T extends DependencyModel> List<T> all(@Nullable String configurationName, @NotNull Fetcher<T> fetcher) {
        if (fetcher == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(36);
        }
        ArrayList dependencies = new ArrayList();
        for (GradleDslElement element : configurationName != null ? this.myDslElement.getPropertyElementsByName(configurationName) : this.myDslElement.getAllPropertyElements()) {
            this.collectFrom(element.getName(), element, fetcher, dependencies);
        }
        ArrayList arrayList = dependencies;
        if (arrayList == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    protected abstract <T extends DependencyModel> void collectFrom(@NotNull String var1, @NotNull GradleDslElement var2, @NotNull Fetcher<T> var3, @NotNull List<T> var4);

    @NotNull
    protected static GradleDslElement resolveElement(@NotNull GradleDslElement element) {
        if (element == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(38);
        }
        GradleDslElement resolved = element;
        GradleDslElement foundElement = PropertyUtil.followElement(element);
        if (foundElement instanceof GradleDslExpression) {
            resolved = foundElement;
        }
        GradleDslElement gradleDslElement = resolved;
        if (gradleDslElement == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(39);
        }
        return gradleDslElement;
    }

    protected static boolean isChildOfParent(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(40);
        }
        if (parent == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(41);
        }
        ArrayList childElements = Lists.newArrayList((Object[])new PsiElement[]{parent});
        while (!childElements.isEmpty()) {
            PsiElement element = (PsiElement)childElements.remove(0);
            if (element.equals((Object)child)) {
                return true;
            }
            childElements.addAll(Arrays.asList(element.getChildren()));
        }
        return false;
    }

    protected static void updateGradleExpressionMapWithDependency(@NotNull GradleDslExpressionMap map, @NotNull ArtifactDependencySpec dependency) {
        String value;
        if (map == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(42);
        }
        if (dependency == null) {
            AbstractDependenciesModel.$$$reportNull$$$0(43);
        }
        LinkedHashMap<String, Function<ArtifactDependencySpec, String>> properties = new LinkedHashMap<String, Function<ArtifactDependencySpec, String>>(COMPONENT_MAP);
        for (Map.Entry<String, GradleDslElement> entry : map.getPropertyElements().entrySet()) {
            if (properties.containsKey(entry.getKey())) {
                value = (String)((Function)properties.get(entry.getKey())).fun((Object)dependency);
                if (value == null) continue;
                map.setNewLiteral(entry.getKey(), value);
                properties.remove(entry.getKey());
                continue;
            }
            map.removeProperty(entry.getKey());
        }
        for (Map.Entry<String, GradleDslElement> entry : properties.entrySet()) {
            value = (String)((Function)entry.getValue()).fun((Object)dependency);
            if (value != null) {
                map.addNewLiteral(entry.getKey(), value);
                continue;
            }
            map.removeProperty(entry.getKey());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 37, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dslElement";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 29: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 3: 
            case 15: 
            case 17: 
            case 24: 
            case 26: 
            case 35: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 5: 
            case 7: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactNotation";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludes";
                break;
            }
            case 10: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetcher";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/model/dependencies/AbstractDependenciesModel";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/model/dependencies/AbstractDependenciesModel";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "all";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "artifacts";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsArtifact";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addArtifact";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addPlatformArtifact";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceArtifactByPsiElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addModule";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addFileTree";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 37: 
            case 39: {
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "resolveElement";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isChildOfParent";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "updateGradleExpressionMapWithDependency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 37, 39 -> new IllegalStateException(string);
        };
    }

    public static interface Fetcher<T extends DependencyModel> {
        public void fetch(@NotNull String var1, @NotNull GradleDslElement var2, @NotNull GradleDslElement var3, @Nullable GradleDslClosure var4, @NotNull DependencyModelImpl.Maintainer var5, @NotNull List<? super T> var6);
    }

    public static interface DependencyReplacer {
        public void performDependencyReplace(@NotNull PsiElement var1, @NotNull GradleDslElement var2, @NotNull ArtifactDependencySpec var3);
    }
}

