/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 36027917474637L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-1731827910 - -30168, 1731827910 - 31526, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1731827910 - -30169, 1731827910 - 19439, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 79922734077131L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.W();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-1982695890 - -((char)-9112), 1982695890 - (char)-2624, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-1982695890 - -((char)-9111), 1982564820 + (char)-1121, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-1982695890 - -((char)-9118), -1982564820 + -((char)-734), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                int[] nArray;
                l2 = 17248019769881L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.W();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(568843800 + (char)-12757, 568843800 + (char)-5926, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(568843800 + (char)-12760, 568843800 + (char)-21396, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(568843800 + (char)-12759, 568843800 + (char)-11605, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(568843800 + (char)-12746, -568843800 + -((char)-13311), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(568843800 + (char)-12745, -568843800 + -((char)-22993), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(568843800 + (char)-12748, 568843800 + (char)-9143, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(568843800 + (char)-12746, -568843800 + -((char)-13311), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(568843800 + (char)-12747, -568974870 - -((char)-7253), (int)l2));
            if (ActionTimestamp.W() == null) {
                SshAgentIpcService.W(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l2 = 108642106508099L;
                    nArray = SshAgentIpcService.W();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l2;
        block27: {
            block28: {
                l2 = 6539182982280L;
                int[] nArray2 = SshAgentIpcService.W();
                this.assertConnectionThread();
                Object object3 = this.lock;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            nArray = nArray2;
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2052162990 + 32045, -2052162990 + -((char)-23066), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2052162990 + 32049, -2052162990 + -32476, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2052162990 + 32044, 2052162990 + (char)-26981, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(2052162990 + 32049, -2052162990 + -32476, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2052162990 + 32043, -2052162990 + -31815, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2052162990 + 32045, -2052162990 + -((char)-23066), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2052162990 + 32049, -2052162990 + -32476, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2052162990 + 32042, 2052162990 + (char)-17735, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2052162990 + 32045, -2052162990 + -((char)-23066), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2052162990 + 32049, -2052162990 + -32476, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2052162990 + 32025, 2052162990 + (char)-29216, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(2052162990 + 32049, -2052162990 + -32476, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2052162990 + 32024, -2052162990 + -((char)-13805), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(2052162990 + 32049, -2052162990 + -32476, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2052162990 + 32043, -2052162990 + -31815, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2052162990 + 32045, -2052162990 + -((char)-23066), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(2052162990 + 32049, -2052162990 + -32476, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2052162990 + 32023, -2052162990 + -((char)-24040), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 78534505656062L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1028637360 + 7476, -1028637360 - -1373, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 58382498544446L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1008059370 + 17979, -1008059370 + -22881, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "I\u00d9\u00b0JW\u00b4\u00a5\u0080\u001a\u00d3\u00f9S\u008fW\u0088\"_p\u009f\u0014\u009a\u00fb\u00ca\b\u0003>RTfO\u00b3\u0014\u0004F8\u008b\u00a4\u0083\u00e7_";
                        var4_3 = "I\u00d9\u00b0JW\u00b4\u00a5\u0080\u001a\u00d3\u00f9S\u008fW\u0088\"_p\u009f\u0014\u009a\u00fb\u00ca\b\u0003>RTfO\u00b3\u0014\u0004F8\u008b\u00a4\u0083\u00e7_".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 59;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 107;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 87;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 124;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 71;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 101;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 89;
                                        break;
                                    }
                                    default: {
                                        v11 = 105;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x311A) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 61;
                            case 1 -> 108;
                            case 2 -> 184;
                            case 3 -> 192;
                            case 4 -> 14;
                            case 5 -> 12;
                            case 6 -> 72;
                            case 7 -> 185;
                            case 8 -> 122;
                            case 9 -> 136;
                            case 10 -> 69;
                            case 11 -> 197;
                            case 12 -> 159;
                            case 13 -> 221;
                            case 14 -> 203;
                            case 15 -> 33;
                            case 16 -> 174;
                            case 17 -> 0;
                            case 18 -> 28;
                            case 19 -> 59;
                            case 20 -> 143;
                            case 21 -> 170;
                            case 22 -> 212;
                            case 23 -> 190;
                            case 24 -> 154;
                            case 25 -> 220;
                            case 26 -> 37;
                            case 27 -> 225;
                            case 28 -> 18;
                            case 29 -> 165;
                            case 30 -> 121;
                            case 31 -> 205;
                            case 32 -> 114;
                            case 33 -> 202;
                            case 34 -> 70;
                            case 35 -> 213;
                            case 36 -> 78;
                            case 37 -> 139;
                            case 38 -> 124;
                            case 39 -> 88;
                            case 40 -> 236;
                            case 41 -> 148;
                            case 42 -> 105;
                            case 43 -> 253;
                            case 44 -> 227;
                            case 45 -> 162;
                            case 46 -> 3;
                            case 47 -> 217;
                            case 48 -> 109;
                            case 49 -> 210;
                            case 50 -> 182;
                            case 51 -> 138;
                            case 52 -> 97;
                            case 53 -> 131;
                            case 54 -> 233;
                            case 55 -> 235;
                            case 56 -> 102;
                            case 57 -> 32;
                            case 58 -> 117;
                            case 59 -> 216;
                            case 60 -> 234;
                            case 61 -> 93;
                            case 62 -> 181;
                            case 63 -> 130;
                            case 64 -> 125;
                            case 65 -> 82;
                            case 66 -> 21;
                            case 67 -> 26;
                            case 68 -> 8;
                            case 69 -> 92;
                            case 70 -> 55;
                            case 71 -> 118;
                            case 72 -> 111;
                            case 73 -> 50;
                            case 74 -> 104;
                            case 75 -> 229;
                            case 76 -> 232;
                            case 77 -> 11;
                            case 78 -> 230;
                            case 79 -> 19;
                            case 80 -> 98;
                            case 81 -> 168;
                            case 82 -> 247;
                            case 83 -> 58;
                            case 84 -> 167;
                            case 85 -> 218;
                            case 86 -> 157;
                            case 87 -> 146;
                            case 88 -> 29;
                            case 89 -> 57;
                            case 90 -> 119;
                            case 91 -> 128;
                            case 92 -> 80;
                            case 93 -> 15;
                            case 94 -> 46;
                            case 95 -> 10;
                            case 96 -> 252;
                            case 97 -> 188;
                            case 98 -> 228;
                            case 99 -> 107;
                            case 100 -> 75;
                            case 101 -> 71;
                            case 102 -> 135;
                            case 103 -> 34;
                            case 104 -> 43;
                            case 105 -> 240;
                            case 106 -> 195;
                            case 107 -> 17;
                            case 108 -> 95;
                            case 109 -> 66;
                            case 110 -> 155;
                            case 111 -> 20;
                            case 112 -> 254;
                            case 113 -> 147;
                            case 114 -> 42;
                            case 115 -> 22;
                            case 116 -> 68;
                            case 117 -> 242;
                            case 118 -> 39;
                            case 119 -> 45;
                            case 120 -> 91;
                            case 121 -> 127;
                            case 122 -> 24;
                            case 123 -> 40;
                            case 124 -> 2;
                            case 125 -> 175;
                            case 126 -> 65;
                            case 127 -> 208;
                            case 128 -> 193;
                            case 129 -> 113;
                            case 130 -> 169;
                            case 131 -> 226;
                            case 132 -> 64;
                            case 133 -> 116;
                            case 134 -> 63;
                            case 135 -> 163;
                            case 136 -> 158;
                            case 137 -> 237;
                            case 138 -> 160;
                            case 139 -> 137;
                            case 140 -> 134;
                            case 141 -> 23;
                            case 142 -> 199;
                            case 143 -> 126;
                            case 144 -> 47;
                            case 145 -> 13;
                            case 146 -> 123;
                            case 147 -> 44;
                            case 148 -> 150;
                            case 149 -> 191;
                            case 150 -> 101;
                            case 151 -> 194;
                            case 152 -> 200;
                            case 153 -> 4;
                            case 154 -> 189;
                            case 155 -> 215;
                            case 156 -> 248;
                            case 157 -> 60;
                            case 158 -> 245;
                            case 159 -> 120;
                            case 160 -> 241;
                            case 161 -> 38;
                            case 162 -> 103;
                            case 163 -> 76;
                            case 164 -> 249;
                            case 165 -> 198;
                            case 166 -> 186;
                            case 167 -> 219;
                            case 168 -> 211;
                            case 169 -> 244;
                            case 170 -> 36;
                            case 171 -> 87;
                            case 172 -> 201;
                            case 173 -> 31;
                            case 174 -> 16;
                            case 175 -> 207;
                            case 176 -> 151;
                            case 177 -> 250;
                            case 178 -> 145;
                            case 179 -> 96;
                            case 180 -> 35;
                            case 181 -> 52;
                            case 182 -> 171;
                            case 183 -> 110;
                            case 184 -> 83;
                            case 185 -> 183;
                            case 186 -> 140;
                            case 187 -> 133;
                            case 188 -> 176;
                            case 189 -> 178;
                            case 190 -> 224;
                            case 191 -> 74;
                            case 192 -> 81;
                            case 193 -> 196;
                            case 194 -> 62;
                            case 195 -> 161;
                            case 196 -> 149;
                            case 197 -> 251;
                            case 198 -> 27;
                            case 199 -> 49;
                            case 200 -> 209;
                            case 201 -> 86;
                            case 202 -> 231;
                            case 203 -> 54;
                            case 204 -> 166;
                            case 205 -> 180;
                            case 206 -> 9;
                            case 207 -> 173;
                            case 208 -> 246;
                            case 209 -> 90;
                            case 210 -> 25;
                            case 211 -> 115;
                            case 212 -> 84;
                            case 213 -> 153;
                            case 214 -> 48;
                            case 215 -> 223;
                            case 216 -> 89;
                            case 217 -> 112;
                            case 218 -> 156;
                            case 219 -> 79;
                            case 220 -> 6;
                            case 221 -> 129;
                            case 222 -> 7;
                            case 223 -> 179;
                            case 224 -> 206;
                            case 225 -> 177;
                            case 226 -> 85;
                            case 227 -> 5;
                            case 228 -> 204;
                            case 229 -> 99;
                            case 230 -> 51;
                            case 231 -> 243;
                            case 232 -> 132;
                            case 233 -> 1;
                            case 234 -> 142;
                            case 235 -> 67;
                            case 236 -> 94;
                            case 237 -> 141;
                            case 238 -> 144;
                            case 239 -> 255;
                            case 240 -> 172;
                            case 241 -> 100;
                            case 242 -> 222;
                            case 243 -> 164;
                            case 244 -> 53;
                            case 245 -> 30;
                            case 246 -> 41;
                            case 247 -> 56;
                            case 248 -> 77;
                            case 249 -> 239;
                            case 250 -> 152;
                            case 251 -> 187;
                            case 252 -> 106;
                            case 253 -> 214;
                            case 254 -> 238;
                            default -> 73;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray == null) {
                ActionTimestamp.W(new ActionTimestamp[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 66806462472082L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.W();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1753847670 - 32181, -1753847670 - -26348, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(1753847670 - 32177, -1753847670 - -30690, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1753847670 - 32152, 1753847670 - (char)-27164, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1753847670 - 32181, -1753847670 - -26348, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(1753847670 - 32177, -1753847670 - -30690, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(1753847670 - 32157, -1753847670 - -13363, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l2 = 89555770920876L;
                        int[] nArray2 = SshAgentIpcService.W();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(-1407822870 + -18948, -1407822870 - -5289, (int)l2));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(-1407822870 + -18949, -1407822870 + -9773, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l2;
        block25: {
            block26: {
                l2 = 41433361547041L;
                int[] nArray2 = SshAgentIpcService.W();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(187954380 + 17574, -187954380 + -7023, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(187954380 + 17578, -187954380 + -19029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(187954380 + 17565, 187954380 + 28147, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(187954380 + 17578, -187954380 + -19029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(187954380 + 17572, -187954380 + -17810, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(187954380 + 17574, -187954380 + -7023, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(187954380 + 17578, -187954380 + -19029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(187954380 + 17562, -187954380 + -27033, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(187954380 + 17574, -187954380 + -7023, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(187954380 + 17578, -187954380 + -19029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(187954380 + 17563, 187954380 + 24150, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(187954380 + 17574, -187954380 + -7023, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(187954380 + 17578, -187954380 + -19029, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(187954380 + 17560, 187954380 + 30151, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int[] nArray;
                block16: {
                    l2 = 36801192009922L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                nArray = SshAgentIpcService.W();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29847), 1912180230 + (char)-24032, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29851), 1912180230 + (char)-28362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29836), -1912180230 + -((char)-21076), (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29831), -1912180230 + -((char)-24301), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29847), 1912180230 + (char)-24032, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29851), 1912180230 + (char)-28362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29830), -1912180230 + -30413, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29847), 1912180230 + (char)-24032, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29851), 1912180230 + (char)-28362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29833), 1912180230 + (char)-26391, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29847), 1912180230 + (char)-24032, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29851), 1912180230 + (char)-28362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29832), 1912180230 + (char)-23555, (int)l2));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29847), 1912180230 + (char)-24032, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29851), 1912180230 + (char)-28362, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29891), 1912180230 + 30830, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1912180230 + -((char)-29890), 1912180230 + (char)-7683, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0096\u008c\u00b9\u0081_\u00adLX\u0014\u00f1\u001dmT;\u009fo\u0004B\u0010vi0-T5\u001aG9]\u0006\u00c4\u00ac\u00f3\u0085|l\u0018)\u000f\u0016&\u00d6\u0014\u00d0\u00b5}[\u009epK\u00f1i,\u0014\r\u00d6\u0089\u00ee\u0093h\u00e3\tZ\u00aa\u00e6#\u00a3+f\u001a\u0097\u0005\u00d1!Q42\b\u0086\u00f9\u00bb^Mp\b\u0001\u0014\u0082\u009b{\u001f\u0094\u00fe\u00af\u00bf4\u00ba\u0013\u0088\u00d6\u00b23+\u00e4W\u001f\u001d\u0005\u00d5\u00a5\u00d1\u00a4\"\u001e9\u00baY#\u00aep}Cm\u0091\u00d7\u00ae.\ng74\u00ff\u0000#\u0098\u00e9\u00aaa<\u00e2-\u0086#D\u0010s\u00f1\u00f4\u008fL\u00d7\u00d7NE\u0082_19\u00ac*|\t\u00c2\u0095#\u00d5H\u00d2=\u00ba\u0012\u0010\u009e\u0098I\u00a2\u00fbr!\u00fa\u009b\u0014\u0084\u00e3B\u00f6E7?BI>]O\u00b6\u00c4\u00f7+\u00d6Z\u00bd \u009e\u009b\u009cn\u00ef6\u00e4\u00d0C\u00d8Rbl\u00eb\u00e3\u00cc\u00be{\u00b0\u008b|\u00b0'\u00afj\u00b7(L'\u008b\u008auC$\u008a\u00af\u0002\u0099\u000bhX\u0085\u00d2\u00a2\u00e9ap\u00e4\u0013\u00d2\b\u00e4\u008f\u00f7\u0090\u00c4\u00a99:\fk,\u0016\u00ff\u00e5&\u00f3\u00cc\u00e8\u009a\u00b86F\u0083@\u000brF\u0097\u0087\u00fafPc\u00ab\u0091T\u00b2\u00e3\u00b7g\rZ\u00a5\u00c6u\u00d0\u00e1\u0017h\u0087\u0003\u001b\u00b88\u00cf\u00db\u00fa\u00f2<\u009dn\u0012\u00e4u\u0015;x\u00f0\u00d1\u0081\u00f6\u009b\u00d4\u0092.\u00fd[}\u00e6h\u007f\u00fc\u0014\u00eb\u0090_\u0011*\u008a\u0082N\u00f8\u001fn\u001f\u00b3\u0097\u00f3\u00e6\u00d6\u0091\u0018\u00cby\u00e5\u00fb~\u00d6\by\u00f0\u00d4\b\u00c9\fWv\u00e2\u00d0\u00e1\f\u00a7\u00e4.\u000b.\u008a\u00be+\u00f0\u00bcQ\u009f\u00bc\u00fc8\u0015 ,\u007f\u00fc\u00cf.Z\u00b0\u00e3\u00f9\u001bh\tc\u0095\u00fd\u00ea\u00da{4\n)&h\u00bay\u00d2;\u00f2*\u009c\u00bc\u00e9\u000b\u00ed\u00a9\u008a\u00f7\u00ad\u0087\u0095A\u0011]\u008aD6\u00df\u00ac\u0095!#|\u0001\u00a9YP/w;\u008co\u001b\u0007\u00c9\u008bM\u001f\b\u00aa2\u0007\u00e2\u00fbL}\u00cf\t\u00dc(\u00c6\u00a6\u00ea\u0081hNS\u00a3\u00d8ZK\u00e1\u009au&\u00ef?)i\u00d7\u00ef\u00b1:\u0012\u00b0\u00a9\u00ca \u00da\u00f5\u00d8\u00c2\u00c6J#\u00e0\u00a3\u00bf\u0085\f\u000fc5\u0010\u00da\u00dfI\u0000\u0080\u00c7\u00b3\t\u008dr\u00ac\u00a5\"X\u00d1uN+\u00dd\u00cd\u00f6{'\u0015xq\u00cb}u\u00b8\u00fe\u00bd,\u00fe\u00f0\u00d7\u00a1\u000e7fV\\iqO&c\u000e.\u0001\u00b9\\\u00ea\u0099\u00a6\u009a\u0013\u00f0\u0093\u00e5-\u00ab\u001b\u00c2\b#xB\u00a8&\u00e0T8\u00f6\u00fd\u00d1\u009eO\u00c9V\u00c3\u00dd\u0017\u00c9\u00a3Bm\u00f7\u00c3\f\n\u00a8Y\u00aaUg\u00e9Q\u00e2\u0011\u001a\u0018kE\u0016\u00dc\u00e5\u0080\u00f3\u00bb\u00f0\u009a\u00a06\u00a2\u00b4\u00dd\u00adsN\u00ae\u00df\u00df\u00f1\u00dbt)\u00b0Yh_\u0088\u00ff\u00b9\u00b2\u00f5\u00af\u00c4iL\u00ec!$\u00a6\u0088+e\u00fc\u00c9~\u00da\u00dd\u009eLQn\u00e7.\b\u00c6\u00a6hD\u00aer\u00b7F|\t\u00f6\u001b\u00a5\u001a\u0092\u00e40'\u000e";
                var4_3 = "\u0096\u008c\u00b9\u0081_\u00adLX\u0014\u00f1\u001dmT;\u009fo\u0004B\u0010vi0-T5\u001aG9]\u0006\u00c4\u00ac\u00f3\u0085|l\u0018)\u000f\u0016&\u00d6\u0014\u00d0\u00b5}[\u009epK\u00f1i,\u0014\r\u00d6\u0089\u00ee\u0093h\u00e3\tZ\u00aa\u00e6#\u00a3+f\u001a\u0097\u0005\u00d1!Q42\b\u0086\u00f9\u00bb^Mp\b\u0001\u0014\u0082\u009b{\u001f\u0094\u00fe\u00af\u00bf4\u00ba\u0013\u0088\u00d6\u00b23+\u00e4W\u001f\u001d\u0005\u00d5\u00a5\u00d1\u00a4\"\u001e9\u00baY#\u00aep}Cm\u0091\u00d7\u00ae.\ng74\u00ff\u0000#\u0098\u00e9\u00aaa<\u00e2-\u0086#D\u0010s\u00f1\u00f4\u008fL\u00d7\u00d7NE\u0082_19\u00ac*|\t\u00c2\u0095#\u00d5H\u00d2=\u00ba\u0012\u0010\u009e\u0098I\u00a2\u00fbr!\u00fa\u009b\u0014\u0084\u00e3B\u00f6E7?BI>]O\u00b6\u00c4\u00f7+\u00d6Z\u00bd \u009e\u009b\u009cn\u00ef6\u00e4\u00d0C\u00d8Rbl\u00eb\u00e3\u00cc\u00be{\u00b0\u008b|\u00b0'\u00afj\u00b7(L'\u008b\u008auC$\u008a\u00af\u0002\u0099\u000bhX\u0085\u00d2\u00a2\u00e9ap\u00e4\u0013\u00d2\b\u00e4\u008f\u00f7\u0090\u00c4\u00a99:\fk,\u0016\u00ff\u00e5&\u00f3\u00cc\u00e8\u009a\u00b86F\u0083@\u000brF\u0097\u0087\u00fafPc\u00ab\u0091T\u00b2\u00e3\u00b7g\rZ\u00a5\u00c6u\u00d0\u00e1\u0017h\u0087\u0003\u001b\u00b88\u00cf\u00db\u00fa\u00f2<\u009dn\u0012\u00e4u\u0015;x\u00f0\u00d1\u0081\u00f6\u009b\u00d4\u0092.\u00fd[}\u00e6h\u007f\u00fc\u0014\u00eb\u0090_\u0011*\u008a\u0082N\u00f8\u001fn\u001f\u00b3\u0097\u00f3\u00e6\u00d6\u0091\u0018\u00cby\u00e5\u00fb~\u00d6\by\u00f0\u00d4\b\u00c9\fWv\u00e2\u00d0\u00e1\f\u00a7\u00e4.\u000b.\u008a\u00be+\u00f0\u00bcQ\u009f\u00bc\u00fc8\u0015 ,\u007f\u00fc\u00cf.Z\u00b0\u00e3\u00f9\u001bh\tc\u0095\u00fd\u00ea\u00da{4\n)&h\u00bay\u00d2;\u00f2*\u009c\u00bc\u00e9\u000b\u00ed\u00a9\u008a\u00f7\u00ad\u0087\u0095A\u0011]\u008aD6\u00df\u00ac\u0095!#|\u0001\u00a9YP/w;\u008co\u001b\u0007\u00c9\u008bM\u001f\b\u00aa2\u0007\u00e2\u00fbL}\u00cf\t\u00dc(\u00c6\u00a6\u00ea\u0081hNS\u00a3\u00d8ZK\u00e1\u009au&\u00ef?)i\u00d7\u00ef\u00b1:\u0012\u00b0\u00a9\u00ca \u00da\u00f5\u00d8\u00c2\u00c6J#\u00e0\u00a3\u00bf\u0085\f\u000fc5\u0010\u00da\u00dfI\u0000\u0080\u00c7\u00b3\t\u008dr\u00ac\u00a5\"X\u00d1uN+\u00dd\u00cd\u00f6{'\u0015xq\u00cb}u\u00b8\u00fe\u00bd,\u00fe\u00f0\u00d7\u00a1\u000e7fV\\iqO&c\u000e.\u0001\u00b9\\\u00ea\u0099\u00a6\u009a\u0013\u00f0\u0093\u00e5-\u00ab\u001b\u00c2\b#xB\u00a8&\u00e0T8\u00f6\u00fd\u00d1\u009eO\u00c9V\u00c3\u00dd\u0017\u00c9\u00a3Bm\u00f7\u00c3\f\n\u00a8Y\u00aaUg\u00e9Q\u00e2\u0011\u001a\u0018kE\u0016\u00dc\u00e5\u0080\u00f3\u00bb\u00f0\u009a\u00a06\u00a2\u00b4\u00dd\u00adsN\u00ae\u00df\u00df\u00f1\u00dbt)\u00b0Yh_\u0088\u00ff\u00b9\u00b2\u00f5\u00af\u00c4iL\u00ec!$\u00a6\u0088+e\u00fc\u00c9~\u00da\u00dd\u009eLQn\u00e7.\b\u00c6\u00a6hD\u00aer\u00b7F|\t\u00f6\u001b\u00a5\u001a\u0092\u00e40'\u000e".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 69;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "F\u00e4p.M\u0017\u00c7i\u00fc\u0012#\u0018v\u0004\u00a0\u00ffP9c\u0011f\u00be\u0018,|\u009a/RT\u0014K\u00f5\u00fc\u008f\u00cf\"7u\u008f\u00f8\t\u00b2\u0019\u0090\u00b7D\u00a0\u00af\u00a8\u0086";
                    var4_3 = "F\u00e4p.M\u0017\u00c7i\u00fc\u0012#\u0018v\u0004\u00a0\u00ffP9c\u0011f\u00be\u0018,|\u009a/RT\u0014K\u00f5\u00fc\u008f\u00cf\"7u\u008f\u00f8\t\u00b2\u0019\u0090\u00b7D\u00a0\u00af\u00a8\u0086".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 67;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 110;
                            break;
                        }
                        case 1: {
                            v15 = 70;
                            break;
                        }
                        case 2: {
                            v15 = 69;
                            break;
                        }
                        case 3: {
                            v15 = 20;
                            break;
                        }
                        case 4: {
                            v15 = 3;
                            break;
                        }
                        case 5: {
                            v15 = 90;
                            break;
                        }
                        default: {
                            v15 = 4;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFC65F) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 239;
                case 1 -> 220;
                case 2 -> 150;
                case 3 -> 3;
                case 4 -> 160;
                case 5 -> 115;
                case 6 -> 86;
                case 7 -> 80;
                case 8 -> 163;
                case 9 -> 89;
                case 10 -> 198;
                case 11 -> 207;
                case 12 -> 14;
                case 13 -> 248;
                case 14 -> 212;
                case 15 -> 194;
                case 16 -> 172;
                case 17 -> 54;
                case 18 -> 120;
                case 19 -> 166;
                case 20 -> 221;
                case 21 -> 219;
                case 22 -> 21;
                case 23 -> 50;
                case 24 -> 5;
                case 25 -> 83;
                case 26 -> 43;
                case 27 -> 114;
                case 28 -> 52;
                case 29 -> 8;
                case 30 -> 25;
                case 31 -> 40;
                case 32 -> 190;
                case 33 -> 228;
                case 34 -> 11;
                case 35 -> 141;
                case 36 -> 125;
                case 37 -> 227;
                case 38 -> 44;
                case 39 -> 184;
                case 40 -> 216;
                case 41 -> 17;
                case 42 -> 132;
                case 43 -> 213;
                case 44 -> 153;
                case 45 -> 49;
                case 46 -> 183;
                case 47 -> 41;
                case 48 -> 67;
                case 49 -> 2;
                case 50 -> 128;
                case 51 -> 19;
                case 52 -> 236;
                case 53 -> 237;
                case 54 -> 9;
                case 55 -> 127;
                case 56 -> 104;
                case 57 -> 165;
                case 58 -> 177;
                case 59 -> 170;
                case 60 -> 24;
                case 61 -> 103;
                case 62 -> 73;
                case 63 -> 99;
                case 64 -> 117;
                case 65 -> 47;
                case 66 -> 20;
                case 67 -> 65;
                case 68 -> 148;
                case 69 -> 56;
                case 70 -> 46;
                case 71 -> 71;
                case 72 -> 72;
                case 73 -> 93;
                case 74 -> 168;
                case 75 -> 121;
                case 76 -> 75;
                case 77 -> 22;
                case 78 -> 60;
                case 79 -> 0;
                case 80 -> 134;
                case 81 -> 33;
                case 82 -> 144;
                case 83 -> 162;
                case 84 -> 26;
                case 85 -> 68;
                case 86 -> 199;
                case 87 -> 164;
                case 88 -> 57;
                case 89 -> 84;
                case 90 -> 70;
                case 91 -> 130;
                case 92 -> 178;
                case 93 -> 55;
                case 94 -> 226;
                case 95 -> 131;
                case 96 -> 157;
                case 97 -> 78;
                case 98 -> 82;
                case 99 -> 145;
                case 100 -> 232;
                case 101 -> 246;
                case 102 -> 146;
                case 103 -> 53;
                case 104 -> 169;
                case 105 -> 110;
                case 106 -> 12;
                case 107 -> 101;
                case 108 -> 77;
                case 109 -> 122;
                case 110 -> 192;
                case 111 -> 174;
                case 112 -> 238;
                case 113 -> 100;
                case 114 -> 181;
                case 115 -> 186;
                case 116 -> 214;
                case 117 -> 27;
                case 118 -> 241;
                case 119 -> 229;
                case 120 -> 124;
                case 121 -> 231;
                case 122 -> 61;
                case 123 -> 171;
                case 124 -> 211;
                case 125 -> 210;
                case 126 -> 176;
                case 127 -> 109;
                case 128 -> 200;
                case 129 -> 42;
                case 130 -> 243;
                case 131 -> 118;
                case 132 -> 235;
                case 133 -> 208;
                case 134 -> 39;
                case 135 -> 201;
                case 136 -> 249;
                case 137 -> 36;
                case 138 -> 187;
                case 139 -> 135;
                case 140 -> 161;
                case 141 -> 242;
                case 142 -> 62;
                case 143 -> 107;
                case 144 -> 255;
                case 145 -> 156;
                case 146 -> 63;
                case 147 -> 129;
                case 148 -> 230;
                case 149 -> 139;
                case 150 -> 206;
                case 151 -> 253;
                case 152 -> 224;
                case 153 -> 23;
                case 154 -> 233;
                case 155 -> 140;
                case 156 -> 180;
                case 157 -> 225;
                case 158 -> 149;
                case 159 -> 147;
                case 160 -> 193;
                case 161 -> 91;
                case 162 -> 108;
                case 163 -> 158;
                case 164 -> 48;
                case 165 -> 179;
                case 166 -> 38;
                case 167 -> 223;
                case 168 -> 116;
                case 169 -> 240;
                case 170 -> 94;
                case 171 -> 59;
                case 172 -> 126;
                case 173 -> 6;
                case 174 -> 245;
                case 175 -> 151;
                case 176 -> 76;
                case 177 -> 137;
                case 178 -> 88;
                case 179 -> 79;
                case 180 -> 74;
                case 181 -> 18;
                case 182 -> 182;
                case 183 -> 254;
                case 184 -> 215;
                case 185 -> 234;
                case 186 -> 96;
                case 187 -> 34;
                case 188 -> 98;
                case 189 -> 32;
                case 190 -> 189;
                case 191 -> 197;
                case 192 -> 111;
                case 193 -> 167;
                case 194 -> 64;
                case 195 -> 203;
                case 196 -> 113;
                case 197 -> 1;
                case 198 -> 4;
                case 199 -> 106;
                case 200 -> 196;
                case 201 -> 87;
                case 202 -> 133;
                case 203 -> 217;
                case 204 -> 35;
                case 205 -> 175;
                case 206 -> 13;
                case 207 -> 142;
                case 208 -> 95;
                case 209 -> 66;
                case 210 -> 155;
                case 211 -> 15;
                case 212 -> 143;
                case 213 -> 154;
                case 214 -> 90;
                case 215 -> 136;
                case 216 -> 51;
                case 217 -> 30;
                case 218 -> 7;
                case 219 -> 222;
                case 220 -> 152;
                case 221 -> 218;
                case 222 -> 85;
                case 223 -> 119;
                case 224 -> 69;
                case 225 -> 29;
                case 226 -> 173;
                case 227 -> 81;
                case 228 -> 45;
                case 229 -> 250;
                case 230 -> 252;
                case 231 -> 205;
                case 232 -> 138;
                case 233 -> 185;
                case 234 -> 37;
                case 235 -> 31;
                case 236 -> 204;
                case 237 -> 209;
                case 238 -> 202;
                case 239 -> 58;
                case 240 -> 251;
                case 241 -> 102;
                case 242 -> 16;
                case 243 -> 247;
                case 244 -> 28;
                case 245 -> 92;
                case 246 -> 123;
                case 247 -> 188;
                case 248 -> 195;
                case 249 -> 105;
                case 250 -> 97;
                case 251 -> 244;
                case 252 -> 191;
                case 253 -> 10;
                case 254 -> 112;
                default -> 159;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 139109227348302L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(468444180 - (char)-25471, -468444180 - -((char)-21679), (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l2 = 31558514569854L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.W();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(905169420 - 21866, -905169420 - -((char)-20637), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(905169420 - 21867, 905169420 - (char)-17662, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(905169420 - 21868, 905169420 - (char)-32639, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00ac\u0018\u0081H\u00da,\u0012N\u0010\u009b\u00db\u0096\u0091\u0082\u00ac\u00e0\u0007\u00f7\u00d4Ry K/\u00d4";
                    var4_3 = "\u00ac\u0018\u0081H\u00da,\u0012N\u0010\u009b\u00db\u0096\u0091\u0082\u00ac\u00e0\u0007\u00f7\u00d4Ry K/\u00d4".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 118;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "A\u0081S\u0014\u009f5\u00fd}\u00d3\u00e7]4l\u00d0~\u00fa\u009e\u0013!\u0083e(\u00bf\u0084v\u00cfE\u00ea\u00fd#\u0093\u0000\u001d\u00c5\u00cbqZ:\u00beF\u0093h5\u00b9\u0094\u00d4O\u00165\u007f\u00e7\"i\u00e33\u0090\"ln";
                        var4_3 = "A\u0081S\u0014\u009f5\u00fd}\u00d3\u00e7]4l\u00d0~\u00fa\u009e\u0013!\u0083e(\u00bf\u0084v\u00cfE\u00ea\u00fd#\u0093\u0000\u001d\u00c5\u00cbqZ:\u00beF\u0093h5\u00b9\u0094\u00d4O\u00165\u007f\u00e7\"i\u00e33\u0090\"ln".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 92;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 29;
                                break;
                            }
                            case 1: {
                                v15 = 77;
                                break;
                            }
                            case 2: {
                                v15 = 1;
                                break;
                            }
                            case 3: {
                                v15 = 123;
                                break;
                            }
                            case 4: {
                                v15 = 92;
                                break;
                            }
                            case 5: {
                                v15 = 90;
                                break;
                            }
                            default: {
                                v15 = 84;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF86DD) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 4;
                    case 1 -> 34;
                    case 2 -> 1;
                    case 3 -> 204;
                    case 4 -> 21;
                    case 5 -> 226;
                    case 6 -> 53;
                    case 7 -> 198;
                    case 8 -> 105;
                    case 9 -> 121;
                    case 10 -> 161;
                    case 11 -> 68;
                    case 12 -> 52;
                    case 13 -> 162;
                    case 14 -> 206;
                    case 15 -> 39;
                    case 16 -> 107;
                    case 17 -> 152;
                    case 18 -> 114;
                    case 19 -> 193;
                    case 20 -> 195;
                    case 21 -> 14;
                    case 22 -> 247;
                    case 23 -> 244;
                    case 24 -> 142;
                    case 25 -> 61;
                    case 26 -> 85;
                    case 27 -> 192;
                    case 28 -> 160;
                    case 29 -> 87;
                    case 30 -> 168;
                    case 31 -> 101;
                    case 32 -> 202;
                    case 33 -> 227;
                    case 34 -> 252;
                    case 35 -> 71;
                    case 36 -> 84;
                    case 37 -> 127;
                    case 38 -> 108;
                    case 39 -> 95;
                    case 40 -> 65;
                    case 41 -> 233;
                    case 42 -> 229;
                    case 43 -> 77;
                    case 44 -> 153;
                    case 45 -> 117;
                    case 46 -> 97;
                    case 47 -> 88;
                    case 48 -> 249;
                    case 49 -> 110;
                    case 50 -> 210;
                    case 51 -> 187;
                    case 52 -> 83;
                    case 53 -> 184;
                    case 54 -> 41;
                    case 55 -> 177;
                    case 56 -> 240;
                    case 57 -> 167;
                    case 58 -> 78;
                    case 59 -> 248;
                    case 60 -> 66;
                    case 61 -> 174;
                    case 62 -> 22;
                    case 63 -> 72;
                    case 64 -> 6;
                    case 65 -> 130;
                    case 66 -> 124;
                    case 67 -> 120;
                    case 68 -> 207;
                    case 69 -> 55;
                    case 70 -> 59;
                    case 71 -> 151;
                    case 72 -> 128;
                    case 73 -> 250;
                    case 74 -> 136;
                    case 75 -> 254;
                    case 76 -> 79;
                    case 77 -> 163;
                    case 78 -> 5;
                    case 79 -> 186;
                    case 80 -> 164;
                    case 81 -> 185;
                    case 82 -> 9;
                    case 83 -> 89;
                    case 84 -> 56;
                    case 85 -> 203;
                    case 86 -> 92;
                    case 87 -> 201;
                    case 88 -> 15;
                    case 89 -> 90;
                    case 90 -> 219;
                    case 91 -> 173;
                    case 92 -> 100;
                    case 93 -> 115;
                    case 94 -> 208;
                    case 95 -> 199;
                    case 96 -> 239;
                    case 97 -> 215;
                    case 98 -> 213;
                    case 99 -> 45;
                    case 100 -> 159;
                    case 101 -> 221;
                    case 102 -> 19;
                    case 103 -> 197;
                    case 104 -> 44;
                    case 105 -> 133;
                    case 106 -> 241;
                    case 107 -> 119;
                    case 108 -> 20;
                    case 109 -> 102;
                    case 110 -> 38;
                    case 111 -> 253;
                    case 112 -> 148;
                    case 113 -> 216;
                    case 114 -> 134;
                    case 115 -> 30;
                    case 116 -> 69;
                    case 117 -> 243;
                    case 118 -> 33;
                    case 119 -> 255;
                    case 120 -> 246;
                    case 121 -> 76;
                    case 122 -> 29;
                    case 123 -> 31;
                    case 124 -> 96;
                    case 125 -> 98;
                    case 126 -> 224;
                    case 127 -> 13;
                    case 128 -> 26;
                    case 129 -> 176;
                    case 130 -> 209;
                    case 131 -> 73;
                    case 132 -> 18;
                    case 133 -> 10;
                    case 134 -> 231;
                    case 135 -> 54;
                    case 136 -> 183;
                    case 137 -> 16;
                    case 138 -> 7;
                    case 139 -> 149;
                    case 140 -> 242;
                    case 141 -> 23;
                    case 142 -> 182;
                    case 143 -> 70;
                    case 144 -> 126;
                    case 145 -> 50;
                    case 146 -> 165;
                    case 147 -> 47;
                    case 148 -> 156;
                    case 149 -> 43;
                    case 150 -> 189;
                    case 151 -> 86;
                    case 152 -> 109;
                    case 153 -> 143;
                    case 154 -> 91;
                    case 155 -> 251;
                    case 156 -> 172;
                    case 157 -> 82;
                    case 158 -> 35;
                    case 159 -> 37;
                    case 160 -> 131;
                    case 161 -> 139;
                    case 162 -> 27;
                    case 163 -> 12;
                    case 164 -> 94;
                    case 165 -> 230;
                    case 166 -> 211;
                    case 167 -> 138;
                    case 168 -> 217;
                    case 169 -> 3;
                    case 170 -> 118;
                    case 171 -> 42;
                    case 172 -> 93;
                    case 173 -> 28;
                    case 174 -> 245;
                    case 175 -> 40;
                    case 176 -> 81;
                    case 177 -> 171;
                    case 178 -> 99;
                    case 179 -> 64;
                    case 180 -> 60;
                    case 181 -> 74;
                    case 182 -> 196;
                    case 183 -> 145;
                    case 184 -> 169;
                    case 185 -> 205;
                    case 186 -> 62;
                    case 187 -> 32;
                    case 188 -> 111;
                    case 189 -> 141;
                    case 190 -> 80;
                    case 191 -> 232;
                    case 192 -> 170;
                    case 193 -> 48;
                    case 194 -> 225;
                    case 195 -> 67;
                    case 196 -> 57;
                    case 197 -> 235;
                    case 198 -> 49;
                    case 199 -> 188;
                    case 200 -> 157;
                    case 201 -> 46;
                    case 202 -> 123;
                    case 203 -> 223;
                    case 204 -> 2;
                    case 205 -> 234;
                    case 206 -> 220;
                    case 207 -> 218;
                    case 208 -> 24;
                    case 209 -> 63;
                    case 210 -> 144;
                    case 211 -> 200;
                    case 212 -> 158;
                    case 213 -> 51;
                    case 214 -> 17;
                    case 215 -> 236;
                    case 216 -> 166;
                    case 217 -> 228;
                    case 218 -> 8;
                    case 219 -> 137;
                    case 220 -> 212;
                    case 221 -> 106;
                    case 222 -> 238;
                    case 223 -> 180;
                    case 224 -> 125;
                    case 225 -> 104;
                    case 226 -> 36;
                    case 227 -> 190;
                    case 228 -> 222;
                    case 229 -> 11;
                    case 230 -> 25;
                    case 231 -> 147;
                    case 232 -> 103;
                    case 233 -> 175;
                    case 234 -> 58;
                    case 235 -> 140;
                    case 236 -> 122;
                    case 237 -> 194;
                    case 238 -> 116;
                    case 239 -> 179;
                    case 240 -> 146;
                    case 241 -> 129;
                    case 242 -> 135;
                    case 243 -> 237;
                    case 244 -> 75;
                    case 245 -> 0;
                    case 246 -> 214;
                    case 247 -> 181;
                    case 248 -> 132;
                    case 249 -> 113;
                    case 250 -> 178;
                    case 251 -> 191;
                    case 252 -> 155;
                    case 253 -> 150;
                    case 254 -> 112;
                    default -> 154;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 4800335870373L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "]p^jw G\u0004\tZzM`:bZ\u0018<";
                    var5_4 = "]p^jw G\u0004\tZzM`:bZ\u0018<".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 80;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 102;
                                    break;
                                }
                                case 1: {
                                    v11 = 69;
                                    break;
                                }
                                case 2: {
                                    v11 = 124;
                                    break;
                                }
                                case 3: {
                                    v11 = 84;
                                    break;
                                }
                                case 4: {
                                    v11 = 66;
                                    break;
                                }
                                case 5: {
                                    v11 = 28;
                                    break;
                                }
                                default: {
                                    v11 = 36;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 135356750941555L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "ddZ;j1s\u0004bzV!\nne]!f3kDdT\tne]!f3kHn\ric@,l>qHiG&m7";
                    var5_4 = "ddZ;j1s\u0004bzV!\nne]!f3kDdT\tne]!f3kHn\ric@,l>qHiG&m7".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 85;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0003\u000b1Q\u0007S\u0015\u0006\u0003\u000b1Q\u000bY";
                        var5_4 = "\u0003\u000b1Q\u0007S\u0015\u0006\u0003\u000b1Q\u000bY".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 56;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 120;
                                break;
                            }
                            case 1: {
                                v15 = 95;
                                break;
                            }
                            case 2: {
                                v15 = 102;
                                break;
                            }
                            case 3: {
                                v15 = 26;
                                break;
                            }
                            case 4: {
                                v15 = 86;
                                break;
                            }
                            case 5: {
                                v15 = 5;
                                break;
                            }
                            default: {
                                v15 = 74;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 90868855733002L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(0xDDDF222 - 12990, 0xDDDF222 - 18568, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 50945537887779L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0004}\u00da\u00906\u0003\u00a2\u00d3\u00ba\u0005\u00a7q\u0088\u00d5\u009f\r\u00dc\u00cf\u00d1HA\u00a2\u00f8\u00f4\u00b3F\u0089r\u001d\u0010\u00d2\u0007\u00d7\u00ba\u00bei,\u00b0\u00e0J\u0000\u00be\u00ca\u00f8},\u0005\u00c0\u00bfd\f\u00023^\u0019\u00a6\u00afE\u008fcxt\u00ae\u0019\u000b/\u001f\u00ed\u00cf\u0099\u00bc\u00be\u0007\u00df\u0095)C\u001d\u00e8\u00ea\u00aa\u00eb\u00c9f\u00af\u0083\u009d\u00f0\u0018B\u00f2\u0015\u00cc-k\b\u00036\u0000FB{\u00f4:";
                    var4_3 = "\u0004}\u00da\u00906\u0003\u00a2\u00d3\u00ba\u0005\u00a7q\u0088\u00d5\u009f\r\u00dc\u00cf\u00d1HA\u00a2\u00f8\u00f4\u00b3F\u0089r\u001d\u0010\u00d2\u0007\u00d7\u00ba\u00bei,\u00b0\u00e0J\u0000\u00be\u00ca\u00f8},\u0005\u00c0\u00bfd\f\u00023^\u0019\u00a6\u00afE\u008fcxt\u00ae\u0019\u000b/\u001f\u00ed\u00cf\u0099\u00bc\u00be\u0007\u00df\u0095)C\u001d\u00e8\u00ea\u00aa\u00eb\u00c9f\u00af\u0083\u009d\u00f0\u0018B\u00f2\u0015\u00cc-k\b\u00036\u0000FB{\u00f4:".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 96;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0088\u00d7\u00c3\u00ffc\u009e\u00c8\u0011#!'\u008cq\u00e1UPL\u00c4O\u00bd&\u0086m\u001a\u0001\u00f0\u00b0\u00f1\u0007\u00a5\u001e\\\u00d6\u00f5\u0011\u0093\u001bM-\u000e\u00a9\u0085\u0001\u0083\u000ecK\u00c7\u00cf\u00f8 \u00b1\u00ec\u0007\u00ed\u00d8\u0016\u00fd\u0092\u0082\u001e-\"\u00b1a(\u00fb\u00e7\u00cd<\u0090\u00b7\u00c3\u0096\u009a`\u00939P;+\u0094\u00ect\u00f2\u007f[Q\u00ae\u00bb!W\u008a";
                        var4_3 = "\u0088\u00d7\u00c3\u00ffc\u009e\u00c8\u0011#!'\u008cq\u00e1UPL\u00c4O\u00bd&\u0086m\u001a\u0001\u00f0\u00b0\u00f1\u0007\u00a5\u001e\\\u00d6\u00f5\u0011\u0093\u001bM-\u000e\u00a9\u0085\u0001\u0083\u000ecK\u00c7\u00cf\u00f8 \u00b1\u00ec\u0007\u00ed\u00d8\u0016\u00fd\u0092\u0082\u001e-\"\u00b1a(\u00fb\u00e7\u00cd<\u0090\u00b7\u00c3\u0096\u009a`\u00939P;+\u0094\u00ect\u00f2\u007f[Q\u00ae\u00bb!W\u008a".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 17;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 65;
                                break;
                            }
                            case 1: {
                                v15 = 124;
                                break;
                            }
                            case 2: {
                                v15 = 54;
                                break;
                            }
                            case 3: {
                                v15 = 57;
                                break;
                            }
                            case 4: {
                                v15 = 122;
                                break;
                            }
                            case 5: {
                                v15 = 102;
                                break;
                            }
                            default: {
                                v15 = 15;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x446E) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 73;
                    case 1 -> 206;
                    case 2 -> 44;
                    case 3 -> 52;
                    case 4 -> 105;
                    case 5 -> 37;
                    case 6 -> 88;
                    case 7 -> 160;
                    case 8 -> 208;
                    case 9 -> 11;
                    case 10 -> 8;
                    case 11 -> 51;
                    case 12 -> 230;
                    case 13 -> 144;
                    case 14 -> 123;
                    case 15 -> 156;
                    case 16 -> 71;
                    case 17 -> 26;
                    case 18 -> 98;
                    case 19 -> 69;
                    case 20 -> 232;
                    case 21 -> 77;
                    case 22 -> 148;
                    case 23 -> 70;
                    case 24 -> 199;
                    case 25 -> 164;
                    case 26 -> 9;
                    case 27 -> 16;
                    case 28 -> 227;
                    case 29 -> 252;
                    case 30 -> 173;
                    case 31 -> 35;
                    case 32 -> 42;
                    case 33 -> 95;
                    case 34 -> 224;
                    case 35 -> 195;
                    case 36 -> 204;
                    case 37 -> 76;
                    case 38 -> 36;
                    case 39 -> 113;
                    case 40 -> 251;
                    case 41 -> 120;
                    case 42 -> 243;
                    case 43 -> 225;
                    case 44 -> 181;
                    case 45 -> 0;
                    case 46 -> 106;
                    case 47 -> 132;
                    case 48 -> 140;
                    case 49 -> 116;
                    case 50 -> 49;
                    case 51 -> 153;
                    case 52 -> 119;
                    case 53 -> 57;
                    case 54 -> 203;
                    case 55 -> 61;
                    case 56 -> 82;
                    case 57 -> 198;
                    case 58 -> 34;
                    case 59 -> 79;
                    case 60 -> 17;
                    case 61 -> 137;
                    case 62 -> 194;
                    case 63 -> 145;
                    case 64 -> 159;
                    case 65 -> 158;
                    case 66 -> 166;
                    case 67 -> 165;
                    case 68 -> 74;
                    case 69 -> 101;
                    case 70 -> 143;
                    case 71 -> 87;
                    case 72 -> 191;
                    case 73 -> 183;
                    case 74 -> 100;
                    case 75 -> 68;
                    case 76 -> 215;
                    case 77 -> 48;
                    case 78 -> 237;
                    case 79 -> 89;
                    case 80 -> 23;
                    case 81 -> 235;
                    case 82 -> 201;
                    case 83 -> 172;
                    case 84 -> 246;
                    case 85 -> 149;
                    case 86 -> 111;
                    case 87 -> 19;
                    case 88 -> 47;
                    case 89 -> 4;
                    case 90 -> 65;
                    case 91 -> 41;
                    case 92 -> 179;
                    case 93 -> 134;
                    case 94 -> 115;
                    case 95 -> 110;
                    case 96 -> 255;
                    case 97 -> 50;
                    case 98 -> 221;
                    case 99 -> 176;
                    case 100 -> 67;
                    case 101 -> 169;
                    case 102 -> 253;
                    case 103 -> 13;
                    case 104 -> 139;
                    case 105 -> 86;
                    case 106 -> 93;
                    case 107 -> 6;
                    case 108 -> 46;
                    case 109 -> 180;
                    case 110 -> 108;
                    case 111 -> 150;
                    case 112 -> 94;
                    case 113 -> 157;
                    case 114 -> 63;
                    case 115 -> 220;
                    case 116 -> 209;
                    case 117 -> 152;
                    case 118 -> 124;
                    case 119 -> 85;
                    case 120 -> 21;
                    case 121 -> 171;
                    case 122 -> 129;
                    case 123 -> 107;
                    case 124 -> 128;
                    case 125 -> 66;
                    case 126 -> 90;
                    case 127 -> 193;
                    case 128 -> 22;
                    case 129 -> 59;
                    case 130 -> 38;
                    case 131 -> 241;
                    case 132 -> 167;
                    case 133 -> 162;
                    case 134 -> 240;
                    case 135 -> 249;
                    case 136 -> 7;
                    case 137 -> 97;
                    case 138 -> 242;
                    case 139 -> 244;
                    case 140 -> 236;
                    case 141 -> 233;
                    case 142 -> 136;
                    case 143 -> 109;
                    case 144 -> 103;
                    case 145 -> 197;
                    case 146 -> 245;
                    case 147 -> 138;
                    case 148 -> 217;
                    case 149 -> 239;
                    case 150 -> 25;
                    case 151 -> 223;
                    case 152 -> 231;
                    case 153 -> 31;
                    case 154 -> 43;
                    case 155 -> 10;
                    case 156 -> 30;
                    case 157 -> 55;
                    case 158 -> 114;
                    case 159 -> 200;
                    case 160 -> 126;
                    case 161 -> 1;
                    case 162 -> 187;
                    case 163 -> 178;
                    case 164 -> 182;
                    case 165 -> 142;
                    case 166 -> 121;
                    case 167 -> 202;
                    case 168 -> 28;
                    case 169 -> 186;
                    case 170 -> 218;
                    case 171 -> 127;
                    case 172 -> 54;
                    case 173 -> 247;
                    case 174 -> 212;
                    case 175 -> 238;
                    case 176 -> 3;
                    case 177 -> 20;
                    case 178 -> 117;
                    case 179 -> 99;
                    case 180 -> 163;
                    case 181 -> 62;
                    case 182 -> 81;
                    case 183 -> 78;
                    case 184 -> 104;
                    case 185 -> 130;
                    case 186 -> 154;
                    case 187 -> 189;
                    case 188 -> 133;
                    case 189 -> 146;
                    case 190 -> 33;
                    case 191 -> 222;
                    case 192 -> 168;
                    case 193 -> 155;
                    case 194 -> 190;
                    case 195 -> 53;
                    case 196 -> 64;
                    case 197 -> 96;
                    case 198 -> 102;
                    case 199 -> 80;
                    case 200 -> 125;
                    case 201 -> 118;
                    case 202 -> 60;
                    case 203 -> 18;
                    case 204 -> 196;
                    case 205 -> 2;
                    case 206 -> 177;
                    case 207 -> 32;
                    case 208 -> 84;
                    case 209 -> 234;
                    case 210 -> 27;
                    case 211 -> 58;
                    case 212 -> 175;
                    case 213 -> 147;
                    case 214 -> 207;
                    case 215 -> 213;
                    case 216 -> 185;
                    case 217 -> 39;
                    case 218 -> 92;
                    case 219 -> 135;
                    case 220 -> 122;
                    case 221 -> 205;
                    case 222 -> 75;
                    case 223 -> 141;
                    case 224 -> 131;
                    case 225 -> 29;
                    case 226 -> 254;
                    case 227 -> 226;
                    case 228 -> 188;
                    case 229 -> 219;
                    case 230 -> 228;
                    case 231 -> 192;
                    case 232 -> 12;
                    case 233 -> 24;
                    case 234 -> 5;
                    case 235 -> 112;
                    case 236 -> 216;
                    case 237 -> 45;
                    case 238 -> 248;
                    case 239 -> 151;
                    case 240 -> 211;
                    case 241 -> 40;
                    case 242 -> 91;
                    case 243 -> 83;
                    case 244 -> 174;
                    case 245 -> 184;
                    case 246 -> 72;
                    case 247 -> 14;
                    case 248 -> 210;
                    case 249 -> 15;
                    case 250 -> 56;
                    case 251 -> 161;
                    case 252 -> 214;
                    case 253 -> 250;
                    case 254 -> 229;
                    default -> 170;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 48834522681512L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-744477600 + -((char)-12683), -744477600 + -((char)-18482), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 98354155087300L;
                    int[] nArray = SshAgentIpcService.W();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(595975290 + 19468, -595975290 + -23305, (int)l2));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 11457294736575L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "G\u00f7\u00fc2\u00d2\u0003\u008fR\u00b3";
                var4_3 = "G\u00f7\u00fc2\u00d2\u0003\u008fR\u00b3".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 116;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 108;
                                break;
                            }
                            case 1: {
                                v11 = 12;
                                break;
                            }
                            case 2: {
                                v11 = 75;
                                break;
                            }
                            case 3: {
                                v11 = 82;
                                break;
                            }
                            case 4: {
                                v11 = 99;
                                break;
                            }
                            case 5: {
                                v11 = 95;
                                break;
                            }
                            default: {
                                v11 = 57;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFCD43) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 17;
                    case 1 -> 25;
                    case 2 -> 185;
                    case 3 -> 75;
                    case 4 -> 113;
                    case 5 -> 0;
                    case 6 -> 195;
                    case 7 -> 172;
                    case 8 -> 72;
                    case 9 -> 225;
                    case 10 -> 191;
                    case 11 -> 59;
                    case 12 -> 131;
                    case 13 -> 216;
                    case 14 -> 68;
                    case 15 -> 90;
                    case 16 -> 55;
                    case 17 -> 15;
                    case 18 -> 198;
                    case 19 -> 237;
                    case 20 -> 83;
                    case 21 -> 183;
                    case 22 -> 44;
                    case 23 -> 229;
                    case 24 -> 251;
                    case 25 -> 123;
                    case 26 -> 108;
                    case 27 -> 160;
                    case 28 -> 220;
                    case 29 -> 214;
                    case 30 -> 206;
                    case 31 -> 70;
                    case 32 -> 149;
                    case 33 -> 12;
                    case 34 -> 166;
                    case 35 -> 134;
                    case 36 -> 215;
                    case 37 -> 207;
                    case 38 -> 114;
                    case 39 -> 79;
                    case 40 -> 176;
                    case 41 -> 142;
                    case 42 -> 84;
                    case 43 -> 78;
                    case 44 -> 93;
                    case 45 -> 211;
                    case 46 -> 143;
                    case 47 -> 248;
                    case 48 -> 175;
                    case 49 -> 105;
                    case 50 -> 247;
                    case 51 -> 227;
                    case 52 -> 170;
                    case 53 -> 18;
                    case 54 -> 240;
                    case 55 -> 179;
                    case 56 -> 19;
                    case 57 -> 125;
                    case 58 -> 97;
                    case 59 -> 1;
                    case 60 -> 82;
                    case 61 -> 81;
                    case 62 -> 178;
                    case 63 -> 203;
                    case 64 -> 117;
                    case 65 -> 65;
                    case 66 -> 57;
                    case 67 -> 98;
                    case 68 -> 150;
                    case 69 -> 154;
                    case 70 -> 218;
                    case 71 -> 190;
                    case 72 -> 112;
                    case 73 -> 168;
                    case 74 -> 120;
                    case 75 -> 212;
                    case 76 -> 193;
                    case 77 -> 222;
                    case 78 -> 180;
                    case 79 -> 8;
                    case 80 -> 66;
                    case 81 -> 33;
                    case 82 -> 42;
                    case 83 -> 249;
                    case 84 -> 63;
                    case 85 -> 85;
                    case 86 -> 22;
                    case 87 -> 181;
                    case 88 -> 209;
                    case 89 -> 235;
                    case 90 -> 226;
                    case 91 -> 94;
                    case 92 -> 182;
                    case 93 -> 107;
                    case 94 -> 77;
                    case 95 -> 252;
                    case 96 -> 50;
                    case 97 -> 162;
                    case 98 -> 164;
                    case 99 -> 46;
                    case 100 -> 69;
                    case 101 -> 32;
                    case 102 -> 51;
                    case 103 -> 194;
                    case 104 -> 177;
                    case 105 -> 89;
                    case 106 -> 102;
                    case 107 -> 13;
                    case 108 -> 217;
                    case 109 -> 2;
                    case 110 -> 9;
                    case 111 -> 3;
                    case 112 -> 189;
                    case 113 -> 199;
                    case 114 -> 21;
                    case 115 -> 232;
                    case 116 -> 24;
                    case 117 -> 224;
                    case 118 -> 118;
                    case 119 -> 47;
                    case 120 -> 152;
                    case 121 -> 246;
                    case 122 -> 76;
                    case 123 -> 219;
                    case 124 -> 151;
                    case 125 -> 173;
                    case 126 -> 153;
                    case 127 -> 99;
                    case 128 -> 221;
                    case 129 -> 20;
                    case 130 -> 132;
                    case 131 -> 161;
                    case 132 -> 36;
                    case 133 -> 228;
                    case 134 -> 38;
                    case 135 -> 128;
                    case 136 -> 171;
                    case 137 -> 45;
                    case 138 -> 144;
                    case 139 -> 155;
                    case 140 -> 80;
                    case 141 -> 139;
                    case 142 -> 253;
                    case 143 -> 188;
                    case 144 -> 104;
                    case 145 -> 245;
                    case 146 -> 28;
                    case 147 -> 205;
                    case 148 -> 201;
                    case 149 -> 184;
                    case 150 -> 204;
                    case 151 -> 213;
                    case 152 -> 138;
                    case 153 -> 141;
                    case 154 -> 37;
                    case 155 -> 122;
                    case 156 -> 103;
                    case 157 -> 95;
                    case 158 -> 239;
                    case 159 -> 148;
                    case 160 -> 67;
                    case 161 -> 88;
                    case 162 -> 92;
                    case 163 -> 223;
                    case 164 -> 163;
                    case 165 -> 147;
                    case 166 -> 73;
                    case 167 -> 196;
                    case 168 -> 165;
                    case 169 -> 124;
                    case 170 -> 100;
                    case 171 -> 5;
                    case 172 -> 145;
                    case 173 -> 254;
                    case 174 -> 10;
                    case 175 -> 255;
                    case 176 -> 49;
                    case 177 -> 74;
                    case 178 -> 121;
                    case 179 -> 169;
                    case 180 -> 156;
                    case 181 -> 58;
                    case 182 -> 106;
                    case 183 -> 71;
                    case 184 -> 208;
                    case 185 -> 40;
                    case 186 -> 167;
                    case 187 -> 11;
                    case 188 -> 87;
                    case 189 -> 30;
                    case 190 -> 119;
                    case 191 -> 157;
                    case 192 -> 158;
                    case 193 -> 62;
                    case 194 -> 133;
                    case 195 -> 26;
                    case 196 -> 136;
                    case 197 -> 86;
                    case 198 -> 146;
                    case 199 -> 140;
                    case 200 -> 110;
                    case 201 -> 16;
                    case 202 -> 23;
                    case 203 -> 238;
                    case 204 -> 35;
                    case 205 -> 126;
                    case 206 -> 186;
                    case 207 -> 159;
                    case 208 -> 135;
                    case 209 -> 29;
                    case 210 -> 34;
                    case 211 -> 187;
                    case 212 -> 127;
                    case 213 -> 60;
                    case 214 -> 41;
                    case 215 -> 91;
                    case 216 -> 14;
                    case 217 -> 129;
                    case 218 -> 31;
                    case 219 -> 53;
                    case 220 -> 6;
                    case 221 -> 96;
                    case 222 -> 54;
                    case 223 -> 244;
                    case 224 -> 192;
                    case 225 -> 64;
                    case 226 -> 109;
                    case 227 -> 130;
                    case 228 -> 197;
                    case 229 -> 61;
                    case 230 -> 230;
                    case 231 -> 231;
                    case 232 -> 116;
                    case 233 -> 7;
                    case 234 -> 137;
                    case 235 -> 48;
                    case 236 -> 250;
                    case 237 -> 243;
                    case 238 -> 236;
                    case 239 -> 234;
                    case 240 -> 200;
                    case 241 -> 242;
                    case 242 -> 111;
                    case 243 -> 241;
                    case 244 -> 101;
                    case 245 -> 233;
                    case 246 -> 56;
                    case 247 -> 43;
                    case 248 -> 27;
                    case 249 -> 202;
                    case 250 -> 39;
                    case 251 -> 115;
                    case 252 -> 52;
                    case 253 -> 174;
                    case 254 -> 4;
                    default -> 210;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

