/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.introspector.jdbc;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.ClosableIt;
import com.intellij.database.dialects.base.introspector.jdbc.wrappers.DatabaseMetaDataWrapper;
import com.intellij.database.remote.jdbc.RemoteDatabaseMetaData;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgBaseMetadataWrapper
extends DatabaseMetaDataWrapper {
    PgBaseMetadataWrapper(@NotNull DatabaseConnectionCore connection, @NotNull RemoteDatabaseMetaData data) {
        if (connection == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(0);
        }
        if (data == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(1);
        }
        super(connection, data);
    }

    protected ClosableIt<String> catalogs() throws SQLException {
        ClosableIt.ResultSetDelegateIt resultSetDelegateIt;
        block9: {
            RemoteStatement statement = (RemoteStatement)JdbcNativeUtil.computeRemote(() -> this.getConnection().getRemoteConnection().createStatement());
            if (statement == null) {
                return ClosableIt.empty();
            }
            ClosableIt.AutoCloseableGuard g = ClosableIt.AutoCloseableGuard.guarded(() -> ((RemoteStatement)statement).close());
            try {
                ClosableIt.ResultSetDelegateIt res = this.setUp((ClosableIt.ResultSetDelegateIt)new ClosableIt.ResultSetDelegateIt<String>(this, (RemoteResultSet)JdbcNativeUtil.computeRemote(() -> statement.executeQuery("select datname as name from pg_catalog.pg_database")), g.get()){

                    protected String calcValue() throws SQLException {
                        return this.myRs.getString("name", 1);
                    }
                });
                g.release();
                resultSetDelegateIt = res;
                if (g == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (g != null) {
                        try {
                            g.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOG.debug((Throwable)e);
                    return super.catalogs();
                }
            }
            g.close();
        }
        return resultSetDelegateIt;
    }

    @NotNull
    public ClosableIt<? extends DatabaseMetaDataWrapper.Table> tables(@NotNull DatabaseMetaDataWrapper.Schema schema, @Nullable String name2, String @Nullable [] types) throws SQLException {
        if (schema == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(2);
        }
        ClosableIt tableIt = super.tables(schema, name2, types);
        tableIt.filter(tab -> !"INDEX".equals(tab.type));
        ClosableIt closableIt = tableIt;
        if (closableIt == null) {
            PgBaseMetadataWrapper.$$$reportNull$$$0(3);
        }
        return closableIt;
    }

    protected boolean isUnimplemented(SQLException e) {
        String message = e.getMessage();
        if (this.getDbms() == Dbms.COCKROACH && message != null && message.contains("pg_function_is_visible")) {
            return true;
        }
        return super.isUnimplemented(e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseMetadataWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseMetadataWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tables";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    extends DatabaseMetaDataWrapper.MDFactory {
        @NotNull
        public DatabaseMetaDataWrapper create(@NotNull DatabaseConnectionCore connection, @NotNull RemoteDatabaseMetaData metaData) {
            if (connection == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (metaData == null) {
                Factory.$$$reportNull$$$0(1);
            }
            return new PgBaseMetadataWrapper(connection, metaData);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "connection";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "metaData";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dialects/postgresbase/introspector/jdbc/PgBaseMetadataWrapper$Factory";
            objectArray[2] = "create";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

