/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.postgres.PgDdlParsing;
import com.intellij.sql.dialects.postgres.PgDialect;
import com.intellij.sql.dialects.postgres.PgDmlParsing;
import com.intellij.sql.dialects.postgres.PgElementTypes;
import com.intellij.sql.dialects.postgres.PgExpressionParsing;
import com.intellij.sql.dialects.postgres.PgGeneratedParser;
import com.intellij.sql.dialects.postgres.PgParserBase;
import com.intellij.sql.dialects.postgres.PgPlParsing;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class PgParser
extends PgParserBase {
    public PgParser(boolean pl) {
        super((SqlLanguageDialectEx)PgDialect.INSTANCE, pl);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return PgGeneratedParser.parse_root_(root, builder, level);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = PgExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, PgExpressionParsing::evaluable_expression);
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (this.isPlSql()) {
            return PgPlParsing.pl_statement(builder, level);
        }
        if (super.parseSqlStatement(builder, level)) {
            return true;
        }
        return PgGeneratedParser.statement(builder, level);
    }

    protected TokenSet[] getExtendsTokenSets() {
        return PgGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return PgDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return ext ? PgPlParsing.type_element_ext(builder, level) : PgDdlParsing.type_element(builder, level);
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        if (this.isPlSql() && SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_IDENT) && builder.getTokenText() != null && builder.getTokenText().startsWith("$")) {
            this.consumeIdentifier(builder);
            return SQL_VARIABLE_REFERENCE;
        }
        return super.consumeCustomParameterReference(builder);
    }

    public boolean parseParenContentQorV(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, PgExpressionParsing::parenthesized_values_expr, PgDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, PgExpressionParsing::row_element_list, (b, l) -> PgExpressionParsing.root_expr_0(b, l, -1) && PgExpressionParsing.row_element_list_separator(b, l) && PgExpressionParsing.row_element_list(b, l));
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, PgDmlParsing::parenthesized_aliased_join_expression, PgDmlParsing::top_query_expression, PgParser::parseTopQueryExpressionTail, (b, l) -> PgDmlParsing.join_expression(b, l, -1), (b, l) -> PgDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        if (PgGeneratedParser.within_group_clause(builder, level) | PgGeneratedParser.analytic_clause(builder, level)) {
            IElementType type;
            LighterASTNode ref = SqlGeneratedParserUtil.getExposedFunctionRef((PsiBuilder)builder);
            IElementType iElementType = type = ref == null ? null : ref.getTokenType();
            if (type == SQL_REFERENCE || type == SQL_ANY_CALLABLE_REFERENCE) {
                ((PsiBuilderImpl.ProductionMarker)ref).remapTokenType((IElementType)SQL_FUNCTION_REFERENCE);
            }
        }
        return true;
    }

    public boolean parseFunctionParametersEnd(PsiBuilder builder, int level, BuiltinFunction definition) {
        PgDmlParsing.order_by_clause(builder, level);
        return true;
    }

    protected boolean parseTypedReference(PsiBuilder builder, SqlReferenceElementType refType) {
        boolean result = super.parseTypedReference(builder, refType);
        if (!result && SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_STRING_TOKEN)) {
            PsiBuilder.Marker mark = builder.mark();
            builder.advanceLexer();
            mark.done((IElementType)SQL_STRING_LITERAL);
            result = true;
        }
        if (result && SqlParserUtil.consumeOptionalToken((PsiBuilder)builder, (IElementType)PG_OP_TYPE_CAST)) {
            PsiBuilder.Marker marker = Objects.requireNonNull((PsiBuilder.Marker)builder.getLatestDoneMarker());
            PgPlParsing.type_element_ext_inner(builder, 0);
            marker.precede().done((IElementType)SQL_BINARY_EXPRESSION);
        }
        return result;
    }

    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean variadic = SqlParserUtil.consumeToken((PsiBuilder)builder, (boolean)true, (IElementType)PgTypes.PG_VARIADIC);
        return super.parseFunctionArgument(builder, level, optional && !variadic, allowBoolean);
    }

    @Override
    @Nullable
    public IElementType getLazyCodeBlockType() {
        return PgElementTypes.Misc.PG_LAZY_CODE_BLOCK;
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        PgDmlParsing.query_expression_0(builder, level, -1);
        return PgDmlParsing.left_inner_table_op_tail(builder, level);
    }
}

