/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentPathChecker {
    private RunningState myRunningState = RunningState.READY;
    private Map<FileObjectHashCodedWrapper, FileObject> myProcessedPaths = null;

    public void initProcessing() {
        if (this.myRunningState != RunningState.READY) {
            throw new IllegalStateException("Cannot process paths twice with a single processor");
        }
        this.myRunningState = RunningState.STARTED;
        this.myProcessedPaths = new HashMap<FileObjectHashCodedWrapper, FileObject>();
    }

    @Nullable
    public FileObject getAlreadyProcessedFileObject(FileObject source) {
        return this.myProcessedPaths.put(new FileObjectHashCodedWrapper(source), source);
    }

    private static enum RunningState {
        READY,
        STARTED;

    }

    private static final class FileObjectHashCodedWrapper {
        private static final int MAX_PATH_LENGTH = 239;
        @NotNull
        private final FileObject myFileObject;

        private FileObjectHashCodedWrapper(@NotNull FileObject fileObject) {
            if (fileObject == null) {
                FileObjectHashCodedWrapper.$$$reportNull$$$0(0);
            }
            this.myFileObject = fileObject;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FileObjectHashCodedWrapper)) {
                return false;
            }
            FileObject otherFileObject = ((FileObjectHashCodedWrapper)other).myFileObject;
            FileName myName = this.myFileObject.getName();
            FileName otherName = otherFileObject.getName();
            if (myName.toString().equals(otherName.toString())) {
                return true;
            }
            if (!myName.getBaseName().equals(otherName.getBaseName())) {
                return false;
            }
            if (!myName.isDescendent(otherName) && !otherName.isDescendent(myName)) {
                return false;
            }
            return FileObjectHashCodedWrapper.isSymlinkPath(otherFileObject, this.myFileObject);
        }

        public int hashCode() {
            return this.myFileObject.getName().getBaseName().hashCode();
        }

        private static boolean isSymlinkPath(@NotNull FileObject ancestor, @NotNull FileObject descendant) {
            if (ancestor == null) {
                FileObjectHashCodedWrapper.$$$reportNull$$$0(1);
            }
            if (descendant == null) {
                FileObjectHashCodedWrapper.$$$reportNull$$$0(2);
            }
            try {
                if (!descendant.isSymbolicLink()) {
                    return false;
                }
                return descendant.getLinkDestination().equals((Object)ancestor);
            }
            catch (Exception exception) {
                return FileObjectHashCodedWrapper.isPseudoSymlinkPath(ancestor, descendant);
            }
        }

        private static boolean isPseudoSymlinkPath(FileObject ancestor, FileObject descendant) {
            FileName ancestorName = ancestor.getName();
            FileName descendantName = descendant.getName();
            try {
                String probablyIdPath = ancestorName.getRelativeName(descendantName);
                int idPathMultiplier = FileObjectHashCodedWrapper.calcAppendedPathMultiplier(ancestorName.getPath(), probablyIdPath);
                StringBuilder multipliedPath = new StringBuilder(probablyIdPath);
                for (int i = 1; i < idPathMultiplier; ++i) {
                    multipliedPath.append("/").append(probablyIdPath);
                }
                FileObject resolvedFile = ancestor.resolveFile(multipliedPath.toString());
                return resolvedFile.exists();
            }
            catch (FileSystemException e) {
                return false;
            }
        }

        private static int calcAppendedPathMultiplier(String basePath, String appendedPath) {
            int sep = "/".length();
            return Math.max(0, 239 - basePath.length() + sep) / (appendedPath.length() + sep);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileObject";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ancestor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descendant";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentPathChecker$FileObjectHashCodedWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSymlinkPath";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

