/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0081@\u00a2\u0006\u0002\u0010\u0004\u001a\u001e\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"resolveConfigForFile", "Lcom/intellij/prettierjs/PrettierLanguageService$ResolveConfigResult;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ensureConfigsSaved", "", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierConfigUtil.kt\ncom/intellij/prettierjs/PrettierConfigUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n1869#2,2:33\n*S KotlinDebug\n*F\n+ 1 PrettierConfigUtil.kt\ncom/intellij/prettierjs/PrettierConfigUtilKt\n*L\n26#1:33,2\n*E\n"})
public final class PrettierConfigUtilKt {
    @RequiresReadLock
    @Nullable
    public static final Object resolveConfigForFile(@NotNull PsiFile file, @NotNull Continuation<? super PrettierLanguageService.ResolveConfigResult> $completion) {
        String filePath;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        String string = filePath = file.isValid() ? file.getVirtualFile().getPath() : null;
        if (filePath == null) {
            return null;
        }
        NodePackage nodePackage = PrettierConfiguration.getInstance(project2).getPackage((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)nodePackage, (String)"getPackage(...)");
        NodePackage nodePackage2 = nodePackage;
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        PrettierLanguageService service = PrettierLanguageService.Companion.getInstance(project2, virtualFile, nodePackage2);
        CompletableFuture<PrettierLanguageService.ResolveConfigResult> future = service.resolveConfig(filePath, nodePackage2);
        return FutureKt.await((CompletionStage)future, $completion);
    }

    public static final void ensureConfigsSaved(@NotNull List<? extends VirtualFile> virtualFiles, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager documentManager = fileDocumentManager;
        Collection<VirtualFile> collection = PrettierUtil.lookupPossibleConfigFiles(virtualFiles, project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"lookupPossibleConfigFiles(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile config = (VirtualFile)element$iv;
            boolean bl = false;
            Document document = documentManager.getCachedDocument(config);
            if (document == null || !documentManager.isDocumentUnsaved(document)) continue;
            documentManager.saveDocument(document);
        }
    }
}

