/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath;

import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.xpath.XPathElementType;

public final class XPathTokenTypes {
    public static final IElementType WHITESPACE = TokenType.WHITE_SPACE;
    public static final IElementType BAD_CHARACTER = TokenType.BAD_CHARACTER;
    public static final IElementType PLUS = new XPathElementType("PLUS");
    public static final IElementType MINUS = new XPathElementType("MINUS");
    public static final IElementType MULT = new XPathElementType("MULT");
    public static final IElementType DIV = new XPathElementType("DIV");
    public static final IElementType MOD = new XPathElementType("MOD");
    public static final IElementType UNION = new XPathElementType("UNION");
    public static final IElementType STAR = new XPathElementType("STAR");
    public static final IElementType OR = new XPathElementType("OR");
    public static final IElementType AND = new XPathElementType("AND");
    public static final IElementType EQ = new XPathElementType("EQ");
    public static final IElementType LE = new XPathElementType("LE");
    public static final IElementType LT = new XPathElementType("LT");
    public static final IElementType GT = new XPathElementType("GT");
    public static final IElementType GE = new XPathElementType("GE");
    public static final IElementType NE = new XPathElementType("NE");
    public static final IElementType DOT = new XPathElementType("DOT");
    public static final IElementType DOTDOT = new XPathElementType("DOTDOT");
    public static final IElementType AT = new XPathElementType("AT");
    public static final IElementType COLCOL = new XPathElementType("COLCOL");
    public static final IElementType AXIS_NAME = new XPathElementType("AXIS_NAME");
    public static final IElementType BAD_AXIS_NAME = new XPathElementType("BAD_AXIS_NAME");
    public static final TokenSet AXIS = TokenSet.create((IElementType[])new IElementType[]{AXIS_NAME, BAD_AXIS_NAME});
    public static final IElementType COMMA = new XPathElementType("COMMA");
    public static final IElementType PATH = new XPathElementType("PATH");
    public static final IElementType ANY_PATH = new XPathElementType("ANY_PATH");
    public static final IElementType LBRACKET = new XPathElementType("LBRACKET");
    public static final IElementType RBRACKET = new XPathElementType("RBRACKET");
    public static final IElementType DOLLAR = new XPathElementType("DOLLAR");
    public static final IElementType VARIABLE_PREFIX = new XPathElementType("VARIABLE_PREFIX");
    public static final IElementType VARIABLE_NAME = new XPathElementType("VARIABLE_NAME");
    public static final IElementType LPAREN = new XPathElementType("LPAREN");
    public static final IElementType RPAREN = new XPathElementType("RPAREN");
    public static final IElementType STRING_LITERAL = new XPathElementType("STRING");
    public static final IElementType NUMBER = new XPathElementType("NUMBER");
    public static final IElementType NCNAME = new XPathElementType("NCNAME");
    public static final IElementType COL = new XPathElementType("COL");
    public static final IElementType LBRACE = new XPathElementType("LBRACE");
    public static final IElementType RBRACE = new XPathElementType("RBRACE");
    public static final IElementType NODE_TYPE = new XPathElementType("NODE_TYPE");
    public static final IElementType FUNCTION_NAME = new XPathElementType("FUNCTION_NAME");
    public static final IElementType EXT_PREFIX = new XPathElementType("EXT_PREFIX");
    public static final TokenSet EQUALITY_OPS = TokenSet.create((IElementType[])new IElementType[]{EQ, NE});
    public static final TokenSet REL_OPS = TokenSet.create((IElementType[])new IElementType[]{LT, GT, LE, GE});
    public static final TokenSet ADD_OPS = TokenSet.create((IElementType[])new IElementType[]{PLUS, MINUS});
    public static final TokenSet MUL_OPS = TokenSet.create((IElementType[])new IElementType[]{MULT, DIV, MOD});
    public static final TokenSet PATH_OPS = TokenSet.create((IElementType[])new IElementType[]{PATH, ANY_PATH});
    public static final TokenSet BOOLEAN_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{EQUALITY_OPS, REL_OPS, TokenSet.create((IElementType[])new IElementType[]{AND, OR})});
    public static final TokenSet NUMBER_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{ADD_OPS, MUL_OPS});
    public static final TokenSet BINARY_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{BOOLEAN_OPERATIONS, NUMBER_OPERATIONS, TokenSet.create((IElementType[])new IElementType[]{UNION})});
    public static final TokenSet KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{AND, OR, MOD, DIV, AXIS_NAME, NODE_TYPE, STAR});
    public static final TokenSet REST = TokenSet.create((IElementType[])new IElementType[]{WHITESPACE, DOT, DOT, AT, COL, COLCOL, COMMA, PATH, ANY_PATH});

    private XPathTokenTypes() {
    }
}

