/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.diagram;

import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.JpaVersion;
import com.intellij.jpa.RelationshipEditorDialog;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.model.common.persistence.mapping.JpaAttributeType;
import com.intellij.jpa.model.common.persistence.mapping.RelationAttributeBase;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.persistence.diagram.DefaultDiagramSupport;
import com.intellij.persistence.diagram.PersistenceDiagram;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentEmbeddable;
import com.intellij.persistence.model.PersistentEntity;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.PersistentRelationshipAttribute;
import com.intellij.psi.PsiNameHelper;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

final class JpaDiagramSupport
extends DefaultDiagramSupport {
    JpaDiagramSupport(PersistenceFacet facet) {
        super(facet);
    }

    public void uiDataSnapshot(@NotNull DataSink sink, @NotNull PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> diagram) {
        if (sink == null) {
            JpaDiagramSupport.$$$reportNull$$$0(0);
        }
        if (diagram == null) {
            JpaDiagramSupport.$$$reportNull$$$0(1);
        }
        super.uiDataSnapshot(sink, diagram);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"reference.persistencediagram");
    }

    public Icon getAttributeIcon(PersistentAttribute persistentAttribute, boolean forceId) {
        if (forceId) {
            return JpaAttributeType.ID.getIcon();
        }
        return super.getAttributeIcon(persistentAttribute, forceId);
    }

    public boolean processEditEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram) {
        RelationshipEditorDialog dialog;
        PersistentAttribute selectedAttribute = (PersistentAttribute)persistenceDiagram.getSelectedAttribute();
        if (selectedAttribute instanceof RelationAttributeBase && this.getModelBrowser().queryTargetPersistentObjects((PersistentRelationshipAttribute)((RelationAttributeBase)selectedAttribute)).findFirst() != null && (dialog = new RelationshipEditorDialog(persistenceDiagram.getProject(), (RelationAttributeBase)selectedAttribute)).isOkToShow()) {
            dialog.show();
            return true;
        }
        return false;
    }

    public void processCreateEdge(PersistenceDiagram<PersistencePackage, PersistentObject, PersistentAttribute> persistenceDiagram, PersistentObject sourceEntity, PersistentObject targetEntity) {
        boolean jpa2OrGt;
        PersistenceFacet facet = this.getFacet();
        boolean bl = jpa2OrGt = facet instanceof JpaFacet && JpaUtil.getJpaVersion((JpaFacet)facet).compareTo(JpaVersion.JPA_2_0) >= 0;
        if (targetEntity instanceof PersistentEntity) {
            if (sourceEntity instanceof PersistentEntityBase || jpa2OrGt) {
                RelationshipEditorDialog dialog = new RelationshipEditorDialog(persistenceDiagram.getProject(), sourceEntity, targetEntity);
                dialog.show();
            }
        } else if (targetEntity instanceof PersistentEmbeddable && (sourceEntity instanceof PersistentEntityBase || jpa2OrGt)) {
            JpaDiagramSupport.createEmbeddedAttribute(sourceEntity, (PersistentEmbeddable)targetEntity);
        }
    }

    private static void createEmbeddedAttribute(PersistentObject entity, PersistentEmbeddable embeddable) {
        Project project = entity.getPsiManager().getProject();
        final PsiNameHelper nameHelper = PsiNameHelper.getInstance((Project)project);
        final HashSet existingNames = new HashSet(ContainerUtil.mapNotNull((Collection)entity.getObjectModelHelper().getAttributes(), attributeBase -> (String)attributeBase.getName().getValue()));
        String attributeName = Messages.showInputDialog((Project)project, (String)JpaMessages.message("dialog.embedded.attribute.label", new Object[0]), (String)JpaMessages.message("dialog.embedded.title.create", new Object[0]), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return JpaUtil.isAttributeName(nameHelper, inputString) && !existingNames.contains(inputString);
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        });
        if (attributeName != null) {
            RelationshipEditorDialog.createEmbeddableAttribute(entity, attributeName, embeddable);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "sink";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "diagram";
                break;
            }
        }
        objectArray[1] = "com/intellij/jpa/diagram/JpaDiagramSupport";
        objectArray[2] = "uiDataSnapshot";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

