/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.selectWord;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SelectionRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0012H\u0007J\u0006\u0010\u0013\u001a\u00020\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/platform/lsp/impl/selectWord/LspSelectionRangeCache;", "", "LspSelectionRangeCache", "()V", "lastFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "lastPosition", "Lorg/eclipse/lsp4j/Position;", "lastPsiModificationCount", "", "lastResult", "Lorg/eclipse/lsp4j/SelectionRange;", "getOrCompute", "project", "Lcom/intellij/openapi/project/Project;", "file", "position", "compute", "Lkotlin/Function0;", "clearCache", "", "intellij.platform.lsp.impl"})
public final class LspSelectionRangeCache {
    @Nullable
    private VirtualFile lastFile;
    @Nullable
    private Position lastPosition;
    private long lastPsiModificationCount = -1L;
    @Nullable
    private SelectionRange lastResult;

    @RequiresBackgroundThread
    @Nullable
    public final synchronized SelectionRange getOrCompute(@NotNull Project project, @NotNull VirtualFile file, @NotNull Position position, @NotNull Function0<? extends SelectionRange> compute) {
        SelectionRange selectionRange;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(compute, (String)"compute");
        ProgressManager.checkCanceled();
        long l2 = PsiManager.getInstance((Project)project).getModificationTracker().getModificationCount();
        SelectionRange selectionRange2 = selectionRange = Intrinsics.areEqual((Object)this.lastFile, (Object)file) && Intrinsics.areEqual((Object)this.lastPosition, (Object)position) && this.lastPsiModificationCount == l2 ? this.lastResult : null;
        if (selectionRange != null) {
            return selectionRange;
        }
        SelectionRange selectionRange3 = (SelectionRange)compute.invoke();
        if (selectionRange3 == null) {
            return null;
        }
        SelectionRange selectionRange4 = selectionRange3;
        this.lastPsiModificationCount = l2;
        this.lastFile = file;
        this.lastPosition = position;
        this.lastResult = selectionRange4;
        return selectionRange4;
    }

    public final synchronized void clearCache() {
        this.lastPosition = null;
        this.lastFile = null;
        this.lastPsiModificationCount = -1L;
        this.lastResult = null;
    }
}

