/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.scriptingSupport.definitions;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.kotlin.jupyter.core.ide.handlers.KotlinPluginModeAwareHandler;
import com.intellij.kotlin.jupyter.core.util.FilesKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import kotlin.script.experimental.api.ScriptCompilationConfigurationKeys;
import kotlin.script.experimental.api.ScriptCompilationKt;
import kotlin.script.experimental.api.SourceCode;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0004R\u001b\u0010\u0006\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0010\u001a\u00020\f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0011\u0010\u000eR\u0012\u0010\u0017\u001a\u00020\u0018X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/KotlinNotebookScriptDefinitionsWrapper;", "Lcom/intellij/kotlin/jupyter/core/ide/handlers/KotlinPluginModeAwareHandler;", "scriptDefinition", "Lkotlin/script/experimental/host/ScriptDefinition;", "<init>", "(Lkotlin/script/experimental/host/ScriptDefinition;)V", "scriptDefinitionData", "getScriptDefinitionData", "()Lkotlin/script/experimental/host/ScriptDefinition;", "scriptDefinitionData$delegate", "Lkotlin/Lazy;", "fileExtension", "", "getFileExtension", "()Ljava/lang/String;", "fileExtension$delegate", "compiledFileSuffix", "getCompiledFileSuffix", "compiledFileSuffix$delegate", "isNotebookInjectedScript", "", "script", "Lkotlin/script/experimental/api/SourceCode;", "compilationScriptDefinition", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "getCompilationScriptDefinition", "()Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "Factory", "Companion", "intellij.kotlin.jupyter.core"})
public abstract class KotlinNotebookScriptDefinitionsWrapper
implements KotlinPluginModeAwareHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy scriptDefinitionData$delegate;
    @NotNull
    private final Lazy fileExtension$delegate;
    @NotNull
    private final Lazy compiledFileSuffix$delegate;

    public KotlinNotebookScriptDefinitionsWrapper(@NotNull kotlin.script.experimental.host.ScriptDefinition scriptDefinition) {
        Intrinsics.checkNotNullParameter((Object)scriptDefinition, (String)"scriptDefinition");
        this.scriptDefinitionData$delegate = LazyKt.lazy(() -> KotlinNotebookScriptDefinitionsWrapper.scriptDefinitionData_delegate$lambda$0(scriptDefinition));
        this.fileExtension$delegate = LazyKt.lazy(() -> KotlinNotebookScriptDefinitionsWrapper.fileExtension_delegate$lambda$0(scriptDefinition));
        this.compiledFileSuffix$delegate = LazyKt.lazy(() -> KotlinNotebookScriptDefinitionsWrapper.compiledFileSuffix_delegate$lambda$0(this));
    }

    @NotNull
    public final kotlin.script.experimental.host.ScriptDefinition getScriptDefinitionData() {
        Lazy lazy = this.scriptDefinitionData$delegate;
        return (kotlin.script.experimental.host.ScriptDefinition)lazy.getValue();
    }

    @NotNull
    protected final String getFileExtension() {
        Lazy lazy = this.fileExtension$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    protected final String getCompiledFileSuffix() {
        Lazy lazy = this.compiledFileSuffix$delegate;
        return (String)lazy.getValue();
    }

    protected final boolean isNotebookInjectedScript(@NotNull SourceCode script) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        VirtualFileScriptSource virtualFileScriptSource = script instanceof VirtualFileScriptSource ? (VirtualFileScriptSource)script : null;
        if (virtualFileScriptSource == null || (virtualFileScriptSource = virtualFileScriptSource.getVirtualFile()) == null) {
            return false;
        }
        VirtualFileScriptSource virtualFile = virtualFileScriptSource;
        VirtualFileScriptSource virtualFileScriptSource2 = virtualFile;
        if (virtualFileScriptSource2 instanceof VirtualFileWindow) {
            bl = FilesKt.toKotlinNotebookBackedFile(((VirtualFileWindow)virtualFile).getDelegate()) != null;
        } else if (virtualFileScriptSource2 instanceof LightVirtualFile) {
            String string = ((LightVirtualFile)virtualFile).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            bl = StringsKt.endsWith$default((String)string, (String)this.getFileExtension(), (boolean)false, (int)2, null);
        } else {
            bl = IsKotlinNotebookKt.isKotlinNotebook((VirtualFile)virtualFile);
        }
        return bl;
    }

    @NotNull
    public abstract ScriptDefinition getCompilationScriptDefinition();

    private static final kotlin.script.experimental.host.ScriptDefinition scriptDefinitionData_delegate$lambda$0(kotlin.script.experimental.host.ScriptDefinition $scriptDefinition) {
        return $scriptDefinition;
    }

    private static final String fileExtension_delegate$lambda$0(kotlin.script.experimental.host.ScriptDefinition $scriptDefinition) {
        String string = (String)$scriptDefinition.getCompilationConfiguration().get(ScriptCompilationKt.getFileExtension((ScriptCompilationConfigurationKeys)((ScriptCompilationConfigurationKeys)ScriptCompilationConfiguration.Companion)));
        if (string == null) {
            string = "jupyter.kts";
        }
        return string;
    }

    private static final String compiledFileSuffix_delegate$lambda$0(KotlinNotebookScriptDefinitionsWrapper this$0) {
        return StringsKt.substringBeforeLast$default((String)this$0.getFileExtension(), (char)'.', null, (int)2, null) + ".class";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/KotlinNotebookScriptDefinitionsWrapper$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/KotlinNotebookScriptDefinitionsWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "scriptDefinition", "Lkotlin/script/experimental/host/ScriptDefinition;", "intellij.kotlin.jupyter.core"})
    @SourceDebugExtension(value={"SMAP\nKotlinNotebookScriptDefinitionsWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinNotebookScriptDefinitionsWrapper.kt\ncom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/KotlinNotebookScriptDefinitionsWrapper$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n30#2,2:66\n*S KotlinDebug\n*F\n+ 1 KotlinNotebookScriptDefinitionsWrapper.kt\ncom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/KotlinNotebookScriptDefinitionsWrapper$Companion\n*L\n61#1:66,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KotlinNotebookScriptDefinitionsWrapper create(@NotNull Project project, @NotNull kotlin.script.experimental.host.ScriptDefinition scriptDefinition) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scriptDefinition, (String)"scriptDefinition");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<Factory> serviceClass$iv = Factory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return ((Factory)object).create(scriptDefinition);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/KotlinNotebookScriptDefinitionsWrapper$Factory;", "", "create", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/definitions/KotlinNotebookScriptDefinitionsWrapper;", "scriptDefinition", "Lkotlin/script/experimental/host/ScriptDefinition;", "intellij.kotlin.jupyter.core"})
    public static interface Factory {
        @NotNull
        public KotlinNotebookScriptDefinitionsWrapper create(@NotNull kotlin.script.experimental.host.ScriptDefinition var1);
    }
}

