/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.util;

import com.intellij.kotlin.jupyter.core.util.CursorProvider;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/RetargetingCursorProvider;", "Lcom/intellij/kotlin/jupyter/core/util/CursorProvider;", "component", "Ljava/awt/Component;", "boundsSource", "customCursorGetter", "Lkotlin/Function1;", "Ljava/awt/Cursor;", "<init>", "(Ljava/awt/Component;Ljava/awt/Component;Lkotlin/jvm/functions/Function1;)V", "provideCursor", "x", "", "y", "Factory", "intellij.kotlin.jupyter.core"})
public final class RetargetingCursorProvider
extends CursorProvider {
    @NotNull
    private final Component boundsSource;
    @NotNull
    private final Function1<Component, Cursor> customCursorGetter;

    public RetargetingCursorProvider(@NotNull Component component, @NotNull Component boundsSource, @NotNull Function1<? super Component, ? extends Cursor> customCursorGetter) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)boundsSource, (String)"boundsSource");
        Intrinsics.checkNotNullParameter(customCursorGetter, (String)"customCursorGetter");
        super(component);
        this.boundsSource = boundsSource;
        this.customCursorGetter = customCursorGetter;
    }

    public /* synthetic */ RetargetingCursorProvider(Component component, Component component2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(component, component2, (Function1<? super Component, ? extends Cursor>)function1);
    }

    @Override
    @Nullable
    public Cursor provideCursor(int x, int y) {
        Point pointWithinSource = SwingUtilities.convertPoint(this.getComponent(), x, y, this.boundsSource);
        Component component = SwingUtilities.getDeepestComponentAt(this.boundsSource, pointWithinSource.x, pointWithinSource.y);
        if (component == null) {
            return null;
        }
        Component cursorSource = component;
        Cursor cursor = (Cursor)this.customCursorGetter.invoke((Object)cursorSource);
        if (cursor == null) {
            cursor = cursorSource.getCursor();
        }
        return cursor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/util/RetargetingCursorProvider$Factory;", "Lcom/intellij/kotlin/jupyter/core/util/CursorProvider$Factory;", "boundsSource", "Ljava/awt/Component;", "customCursorGetter", "Lkotlin/Function1;", "Ljava/awt/Cursor;", "<init>", "(Ljava/awt/Component;Lkotlin/jvm/functions/Function1;)V", "create", "Lcom/intellij/kotlin/jupyter/core/util/CursorProvider;", "component", "intellij.kotlin.jupyter.core"})
    public static final class Factory
    implements CursorProvider.Factory {
        @NotNull
        private final Component boundsSource;
        @NotNull
        private final Function1<Component, Cursor> customCursorGetter;

        public Factory(@NotNull Component boundsSource, @NotNull Function1<? super Component, ? extends Cursor> customCursorGetter) {
            Intrinsics.checkNotNullParameter((Object)boundsSource, (String)"boundsSource");
            Intrinsics.checkNotNullParameter(customCursorGetter, (String)"customCursorGetter");
            this.boundsSource = boundsSource;
            this.customCursorGetter = customCursorGetter;
        }

        public /* synthetic */ Factory(Component component, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                function1 = 1.INSTANCE;
            }
            this(component, (Function1<? super Component, ? extends Cursor>)function1);
        }

        @Override
        @NotNull
        public CursorProvider create(@NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return new RetargetingCursorProvider(component, this.boundsSource, this.customCursorGetter);
        }
    }
}

