/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq.proto;

import java.util.Locale;
import java.util.regex.Pattern;
import org.zeromq.ZFrame;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;
import org.zeromq.ZMsg;
import org.zeromq.proto.ZNeedle;

public class ZPicture {
    private static final Pattern FORMAT = Pattern.compile("[i1248sbcfz]*m?");
    private static final Pattern BINARY_FORMAT = Pattern.compile("[1248sSbcf]*m?");

    public ZMsg msgBinaryPicture(String picture, Object ... args) {
        if (!BINARY_FORMAT.matcher(picture).matches()) {
            throw new ZMQException(picture + " is not in expected binary format " + BINARY_FORMAT.pattern(), 156384820);
        }
        ZMsg msg = new ZMsg();
        int frameSize = 0;
        block21: for (int index = 0; index < picture.length(); ++index) {
            char pattern = picture.charAt(index);
            switch (pattern) {
                case '1': {
                    ++frameSize;
                    continue block21;
                }
                case '2': {
                    frameSize += 2;
                    continue block21;
                }
                case '4': {
                    frameSize += 4;
                    continue block21;
                }
                case '8': {
                    frameSize += 8;
                    continue block21;
                }
                case 's': {
                    String string = (String)args[index];
                    frameSize += 1 + (string != null ? string.getBytes(ZMQ.CHARSET).length : 0);
                    continue block21;
                }
                case 'S': {
                    String string = (String)args[index];
                    frameSize += 4 + (string != null ? string.getBytes(ZMQ.CHARSET).length : 0);
                    continue block21;
                }
                case 'b': 
                case 'c': {
                    byte[] block = (byte[])args[index];
                    frameSize += 4 + block.length;
                    continue block21;
                }
                case 'f': {
                    ZFrame frame = (ZFrame)args[index];
                    msg.add(frame);
                    continue block21;
                }
                case 'm': {
                    ZMsg other = (ZMsg)args[index];
                    if (other == null) {
                        msg.add(new ZFrame((byte[])null));
                        continue block21;
                    }
                    msg.addAll(other);
                    continue block21;
                }
                default: {
                    assert (false) : "invalid picture element '" + pattern + "'";
                    continue block21;
                }
            }
        }
        ZFrame frame = new ZFrame(new byte[frameSize]);
        ZNeedle needle = new ZNeedle(frame);
        block22: for (int index = 0; index < picture.length(); ++index) {
            char pattern = picture.charAt(index);
            switch (pattern) {
                case '1': {
                    needle.putNumber1((Integer)args[index]);
                    continue block22;
                }
                case '2': {
                    needle.putNumber2((Integer)args[index]);
                    continue block22;
                }
                case '4': {
                    needle.putNumber4((Integer)args[index]);
                    continue block22;
                }
                case '8': {
                    needle.putNumber8((Long)args[index]);
                    continue block22;
                }
                case 's': {
                    needle.putString((String)args[index]);
                    continue block22;
                }
                case 'S': {
                    needle.putLongString((String)args[index]);
                    continue block22;
                }
                case 'b': 
                case 'c': {
                    byte[] block = (byte[])args[index];
                    needle.putNumber4(block.length);
                    needle.putBlock(block, block.length);
                    continue block22;
                }
                case 'f': 
                case 'm': {
                    continue block22;
                }
                default: {
                    assert (false) : "invalid picture element '" + pattern + "'";
                    continue block22;
                }
            }
        }
        msg.addFirst(frame);
        return msg;
    }

    public boolean sendBinaryPicture(ZMQ.Socket socket, String picture, Object ... args) {
        return this.msgBinaryPicture(picture, args).send(socket);
    }

    public Object[] recvBinaryPicture(ZMQ.Socket socket, String picture) {
        if (!BINARY_FORMAT.matcher(picture).matches()) {
            throw new ZMQException(picture + " is not in expected binary format " + BINARY_FORMAT.pattern(), 156384820);
        }
        ZFrame frame = ZFrame.recvFrame(socket);
        if (frame == null) {
            return null;
        }
        ZNeedle needle = new ZNeedle(frame);
        Object[] results = new Object[picture.length()];
        block11: for (int index = 0; index < picture.length(); ++index) {
            char pattern = picture.charAt(index);
            switch (pattern) {
                case '1': {
                    results[index] = needle.getNumber1();
                    continue block11;
                }
                case '2': {
                    results[index] = needle.getNumber2();
                    continue block11;
                }
                case '4': {
                    results[index] = needle.getNumber4();
                    continue block11;
                }
                case '8': {
                    results[index] = needle.getNumber8();
                    continue block11;
                }
                case 's': {
                    results[index] = needle.getString();
                    continue block11;
                }
                case 'S': {
                    results[index] = needle.getLongString();
                    continue block11;
                }
                case 'b': 
                case 'c': {
                    int size = needle.getNumber4();
                    results[index] = needle.getBlock(size);
                    continue block11;
                }
                case 'f': {
                    results[index] = ZFrame.recvFrame(socket);
                    continue block11;
                }
                case 'm': {
                    results[index] = ZMsg.recvMsg(socket);
                    continue block11;
                }
                default: {
                    assert (false) : "invalid picture element '" + pattern + "'";
                    continue block11;
                }
            }
        }
        return results;
    }

    public boolean sendPicture(ZMQ.Socket socket, String picture, Object ... args) {
        if (!FORMAT.matcher(picture).matches()) {
            throw new ZMQException(picture + " is not in expected format " + FORMAT.pattern(), 156384820);
        }
        ZMsg msg = new ZMsg();
        int pictureIndex = 0;
        int argIndex = 0;
        while (pictureIndex < picture.length()) {
            char pattern = picture.charAt(pictureIndex);
            switch (pattern) {
                case 'i': {
                    msg.add(String.format(Locale.ENGLISH, "%d", (int)((Integer)args[argIndex])));
                    break;
                }
                case '1': {
                    msg.add(String.format(Locale.ENGLISH, "%d", 0xFF & (Integer)args[argIndex]));
                    break;
                }
                case '2': {
                    msg.add(String.format(Locale.ENGLISH, "%d", 0xFFFF & (Integer)args[argIndex]));
                    break;
                }
                case '4': {
                    msg.add(String.format(Locale.ENGLISH, "%d", 0xFFFFFFFF & (Integer)args[argIndex]));
                    break;
                }
                case '8': {
                    msg.add(String.format(Locale.ENGLISH, "%d", (long)((Long)args[argIndex])));
                    break;
                }
                case 's': {
                    msg.add((String)args[argIndex]);
                    break;
                }
                case 'b': 
                case 'c': {
                    msg.add((byte[])args[argIndex]);
                    break;
                }
                case 'f': {
                    msg.add((ZFrame)args[argIndex]);
                    break;
                }
                case 'm': {
                    ZMsg msgParm = (ZMsg)args[argIndex];
                    while (!msgParm.isEmpty()) {
                        msg.add(msgParm.pop());
                    }
                    break;
                }
                case 'z': {
                    msg.add((byte[])null);
                    --argIndex;
                    break;
                }
                default: {
                    assert (false) : "invalid picture element '" + pattern + "'";
                    break;
                }
            }
            ++pictureIndex;
            ++argIndex;
        }
        return msg.send(socket, false);
    }

    public Object[] recvPicture(ZMQ.Socket socket, String picture) {
        if (!FORMAT.matcher(picture).matches()) {
            throw new ZMQException(picture + " is not in expected format " + FORMAT.pattern(), 156384820);
        }
        Object[] elements = new Object[picture.length()];
        block12: for (int index = 0; index < picture.length(); ++index) {
            char pattern = picture.charAt(index);
            switch (pattern) {
                case 'i': {
                    elements[index] = Integer.valueOf(socket.recvStr());
                    continue block12;
                }
                case '1': {
                    elements[index] = 0xFF & Integer.parseInt(socket.recvStr());
                    continue block12;
                }
                case '2': {
                    elements[index] = 0xFFFF & Integer.parseInt(socket.recvStr());
                    continue block12;
                }
                case '4': {
                    elements[index] = 0xFFFFFFFF & Integer.parseInt(socket.recvStr());
                    continue block12;
                }
                case '8': {
                    elements[index] = Long.valueOf(socket.recvStr());
                    continue block12;
                }
                case 's': {
                    elements[index] = socket.recvStr();
                    continue block12;
                }
                case 'b': 
                case 'c': {
                    elements[index] = socket.recv();
                    continue block12;
                }
                case 'f': {
                    elements[index] = ZFrame.recvFrame(socket);
                    continue block12;
                }
                case 'm': {
                    elements[index] = ZMsg.recvMsg(socket);
                    continue block12;
                }
                case 'z': {
                    ZFrame zeroFrame = ZFrame.recvFrame(socket);
                    if (zeroFrame == null || zeroFrame.size() > 0) {
                        throw new ZMQException("zero frame is not empty", 156384820);
                    }
                    elements[index] = new ZFrame((byte[])null);
                    continue block12;
                }
                default: {
                    assert (false) : "invalid picture element '" + pattern + "'";
                    continue block12;
                }
            }
        }
        return elements;
    }
}

