/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.base.AbstractDatabaseDialect;
import com.intellij.database.dialects.base.TypeHelper;
import com.intellij.database.extractors.ObjectFormatterUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbTable;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FastUtilHashingStrategies;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MysqlBaseDialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public MysqlBaseDialect() {
        super((TypeHelper)new TypeHelper.MySQLTypeHelper());
    }

    @NotNull
    public DdlBuilder sqlDropProcedure(@NotNull DdlBuilder builder, @NotNull DasRoutine procedure) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(0);
        }
        if (procedure == null) {
            MysqlBaseDialect.$$$reportNull$$$0(1);
        }
        DdlBuilder ddlBuilder = DialectUtils.sqlDropProcedure((DdlBuilder)builder, (DasRoutine)procedure, (boolean)true);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(2);
        }
        return ddlBuilder;
    }

    public boolean supportsTableInfo() {
        return true;
    }

    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            MysqlBaseDialect.$$$reportNull$$$0(3);
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        String schema = this.getNamingService().catToScript(current.getDisplayName(), current.kind, this.getCodeStyle().getQuotesPriority());
        return String.format("use %s", schema);
    }

    public boolean supportsInsertInto() {
        return super.supportsInsertInto();
    }

    @NotNull
    public static String getDBName(@NotNull DasObject qualifier) {
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(4);
        }
        String string = DasUtil.getName((DasObject)MysqlBaseDialect.getDB(qualifier));
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    private static DasObject getDB(@NotNull DasObject qualifier) {
        DasObject schema;
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(6);
        }
        return (schema = DasUtil.getSchemaObject((DasObject)qualifier)) != null && !StringUtil.isEmpty((String)schema.getName()) ? schema : DasUtil.getCatalogObject((DasObject)qualifier);
    }

    @NotNull
    public DdlBuilder qualifiedIdentifier(@NotNull DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (builder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(7);
        }
        if (identifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(8);
        }
        if (qualifier == null) {
            MysqlBaseDialect.$$$reportNull$$$0(9);
        }
        DasObject db = MysqlBaseDialect.getDB(qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, db, DasUtil.getName((DasObject)db), null, null, null, null);
        if (ddlBuilder == null) {
            MysqlBaseDialect.$$$reportNull$$$0(10);
        }
        return ddlBuilder;
    }

    @NotNull
    public String getBinaryLiteralString(byte @NotNull [] binaryData) {
        if (binaryData == null) {
            MysqlBaseDialect.$$$reportNull$$$0(11);
        }
        String string = "0x" + ObjectFormatterUtil.toHexString((byte[])binaryData);
        if (string == null) {
            MysqlBaseDialect.$$$reportNull$$$0(12);
        }
        return string;
    }

    public boolean supportsCommonTableExpression() {
        return true;
    }

    public boolean supportsLoadDatabaseList() {
        return true;
    }

    public boolean similarTo(@NotNull DatabaseDialect dialect) {
        if (dialect == null) {
            MysqlBaseDialect.$$$reportNull$$$0(13);
        }
        return dialect instanceof MysqlBaseDialect;
    }

    @NotNull
    public Map<String, Object> tryToLoadTableInfo(@NotNull DbTable element, @NotNull DatabaseConnectionCore connection) throws Exception {
        if (element == null) {
            MysqlBaseDialect.$$$reportNull$$$0(14);
        }
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(15);
        }
        Map res = DbImplUtilCore.resultRowAsMap((DatabaseConnectionCore)connection, (String)String.format("show table status from `%s` like '%s'", MysqlBaseDialect.getDBName((DasObject)element), DbImplUtilCore.escapeStr((String)element.getName())));
        Set set = CollectionFactory.createCaseInsensitiveStringSet();
        ContainerUtil.addAll((Collection)set, (Object[])new String[]{"TABLE_ROWS", "rows", "engine", "TABLE_COLLATION", "collation", "CREATE_TIME", "created", "data_length", "index_length"});
        Object2ObjectLinkedOpenCustomHashMap filtered = new Object2ObjectLinkedOpenCustomHashMap(FastUtilHashingStrategies.getCaseInsensitiveStringStrategy());
        for (Map.Entry entry : res.entrySet()) {
            String key = (String)entry.getKey();
            if (!set.contains(key)) continue;
            Object value = entry.getValue();
            if (value instanceof Number && (key.equalsIgnoreCase("data_length") || key.equalsIgnoreCase("index_length"))) {
                long v = ((Number)value).longValue();
                if (v == 0L) continue;
                value = StringUtil.formatFileSize((long)v);
            }
            filtered.put(key, value);
        }
        Object2ObjectLinkedOpenCustomHashMap object2ObjectLinkedOpenCustomHashMap = filtered;
        if (object2ObjectLinkedOpenCustomHashMap == null) {
            MysqlBaseDialect.$$$reportNull$$$0(16);
        }
        return object2ObjectLinkedOpenCustomHashMap;
    }

    public SearchPath tryToLoadSearchPath(@NotNull DatabaseConnectionCore connection) throws SQLException {
        Dbms dbms;
        String s;
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(17);
        }
        return StringUtil.isEmpty((String)(s = DbImplUtilCore.concatStringResults((DatabaseConnectionCore)connection, (Dbms)(dbms = connection.getDbms()), (String)"select database()", (int)1, (DbImplUtilCore.ConcatenationProps)DbImplUtilCore.ConcatenationProps.NO_CONCAT))) ? null : SearchPath.of((ObjectPath)ObjectPath.create((String)s, (ObjectKind)ObjectKind.SCHEMA));
    }

    @NotNull
    public List<String> tryToLoadDatabaseList(@NotNull DatabaseConnectionCore connection) throws SQLException {
        if (connection == null) {
            MysqlBaseDialect.$$$reportNull$$$0(18);
        }
        List list = (List)DbImplUtilCore.executeAndGetResult((DatabaseConnectionCore)connection, (String)"SHOW DATABASES", (ThrowableConvertor)DbImplUtilCore.RS_AS_STRING_LIST);
        if (list == null) {
            MysqlBaseDialect.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 10, 12, 16, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "procedure";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlBaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlDropProcedure";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDBName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "qualifiedIdentifier";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBinaryLiteralString";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadTableInfo";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "tryToLoadDatabaseList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "sqlDropProcedure";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 12: 
            case 16: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "sqlSetSearchPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDBName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDB";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "qualifiedIdentifier";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBinaryLiteralString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "similarTo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadTableInfo";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadSearchPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "tryToLoadDatabaseList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 10, 12, 16, 19 -> new IllegalStateException(string);
        };
    }
}

