/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionUnit;
import org.jetbrains.letsPlot.core.plot.base.geom.DimensionsUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.TipLayoutHint;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimGroup;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u0000 %2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0004J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J0\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016J0\u0010$\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006&"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TileGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "heightUnit", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getHeightUnit", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "setHeightUnit", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;)V", "widthUnit", "getWidthUnit", "setWidthUnit", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "heightSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "resolution", "isDiscrete", "", "widthSpan", "Companion", "plot-base"})
public class TileGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DimensionUnit widthUnit = DEF_WIDTH_UNIT;
    @NotNull
    private DimensionUnit heightUnit = DEF_HEIGHT_UNIT;
    public static final boolean HANDLES_GROUPS = false;
    @NotNull
    private static final DimensionUnit DEF_WIDTH_UNIT = DimensionUnit.RESOLUTION;
    @NotNull
    private static final DimensionUnit DEF_HEIGHT_UNIT = DimensionUnit.RESOLUTION;

    @NotNull
    public final DimensionUnit getWidthUnit() {
        return this.widthUnit;
    }

    public final void setWidthUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.widthUnit = dimensionUnit;
    }

    @NotNull
    public final DimensionUnit getHeightUnit() {
        return this.heightUnit;
    }

    public final void setHeightUnit(@NotNull DimensionUnit dimensionUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)dimensionUnit), (String)"<set-?>");
        this.heightUnit = dimensionUnit;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        RectangleTooltipHelper tooltipHelper2 = new RectangleTooltipHelper(pos, coord, ctx2, null, TipLayoutHint.Kind.CURSOR_TOOLTIP, null, null, 104, null);
        RectanglesHelper helper2 = new RectanglesHelper(aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)TileGeom.Companion.clientRectByDataPoint(this.widthUnit, this.heightUnit, geomHelper));
        RectanglesHelper.SvgRectHelper svgRectHelper = helper2.createSvgRectHelper();
        svgRectHelper.setResamplingEnabled(!coord.isLinear());
        svgRectHelper.onGeometry((Function3<? super DataPointAesthetics, ? super DoubleRectangle, ? super List<DoubleVector>, Unit>)((Function3)new Function3<DataPointAesthetics, DoubleRectangle, List<? extends DoubleVector>, Unit>(tooltipHelper2){
            final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
            {
                this.$tooltipHelper = $tooltipHelper;
                super(3);
            }

            public final void invoke(@NotNull DataPointAesthetics p, @Nullable DoubleRectangle rect2, @Nullable List<DoubleVector> polygon2) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                if (polygon2 != null) {
                    this.$tooltipHelper.addTarget(p, polygon2);
                } else if (rect2 != null) {
                    this.$tooltipHelper.addTarget(p, rect2);
                }
            }
        }));
        SvgSlimGroup slimGroup = svgRectHelper.createSlimRectangles();
        root.add(GeomBase.Companion.wrap(slimGroup));
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return DimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getWIDTH(), resolution, this.widthUnit);
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        return DimensionsUtil.INSTANCE.dimensionSpan(p, coordAes, Aes.Companion.getHEIGHT(), resolution, this.heightUnit);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\f2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/TileGeom$Companion;", "", "()V", "DEF_HEIGHT_UNIT", "Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "getDEF_HEIGHT_UNIT", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;", "DEF_WIDTH_UNIT", "getDEF_WIDTH_UNIT", "HANDLES_GROUPS", "", "clientRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "widthUnit", "heightUnit", "helper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DimensionUnit getDEF_WIDTH_UNIT() {
            return DEF_WIDTH_UNIT;
        }

        @NotNull
        public final DimensionUnit getDEF_HEIGHT_UNIT() {
            return DEF_HEIGHT_UNIT;
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> clientRectByDataPoint(DimensionUnit widthUnit, DimensionUnit heightUnit, GeomHelper helper2) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(helper2, widthUnit, heightUnit){
                final /* synthetic */ GeomHelper $helper;
                final /* synthetic */ DimensionUnit $widthUnit;
                final /* synthetic */ DimensionUnit $heightUnit;
                {
                    this.$helper = $helper;
                    this.$widthUnit = $widthUnit;
                    this.$heightUnit = $heightUnit;
                    super(1, Intrinsics.Kotlin.class, "factory", "clientRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;Lorg/jetbrains/letsPlot/core/plot/base/geom/DimensionUnit;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.TileGeom$Companion.access$clientRectByDataPoint$factory(this.$helper, this.$widthUnit, this.$heightUnit, p0);
                }
            };
        }

        private static final DoubleRectangle clientRectByDataPoint$factory(GeomHelper $helper, DimensionUnit $widthUnit, DimensionUnit $heightUnit, DataPointAesthetics p) {
            Double d = p.finiteOrNull(Aes.Companion.getX());
            if (d == null) {
                return null;
            }
            double x2 = d;
            Double d2 = p.finiteOrNull(Aes.Companion.getY());
            if (d2 == null) {
                return null;
            }
            double y2 = d2;
            Double d3 = p.finiteOrNull(Aes.Companion.getWIDTH());
            if (d3 == null) {
                return null;
            }
            double w = d3;
            Double d4 = p.finiteOrNull(Aes.Companion.getHEIGHT());
            if (d4 == null) {
                return null;
            }
            double h = d4;
            double width2 = w * $helper.getUnitResolution($widthUnit, Aes.Companion.getX());
            double height = h * $helper.getUnitResolution($heightUnit, Aes.Companion.getY());
            DoubleVector origin = new DoubleVector(x2 - width2 / (double)2, y2 - height / (double)2);
            DoubleVector dimensions = new DoubleVector(width2, height);
            return new DoubleRectangle(origin, dimensions);
        }

        public static final /* synthetic */ DoubleRectangle access$clientRectByDataPoint$factory(GeomHelper $helper, DimensionUnit $widthUnit, DimensionUnit $heightUnit, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.TileGeom$Companion.clientRectByDataPoint$factory($helper, $widthUnit, $heightUnit, p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

