/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.render.point.symbol;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.CircleGlyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.CrossGlyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.DiamondGlyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.Glyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.GlyphPair;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.PlusGlyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.SquareGlyph;
import org.jetbrains.letsPlot.core.plot.base.render.point.symbol.TriangleGlyph;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u001e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u001e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\bJ\u001e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bJ&\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J&\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/render/point/symbol/Glyphs;", "", "()V", "circle", "Lorg/jetbrains/letsPlot/core/plot/base/render/point/symbol/Glyph;", "location", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "width", "", "diamond", "square", "stickCircleCross", "size", "stroke", "stickCirclePlus", "stickCross", "stickDiamondPlus", "stickPlus", "stickSquareCross", "stickSquarePlus", "stickSquareTriangleUp", "stickStar", "stickTriangleUpDown", "triangleDown", "pinnedToCentroid", "", "triangleUp", "plot-base"})
public final class Glyphs {
    @NotNull
    public static final Glyphs INSTANCE = new Glyphs();

    private Glyphs() {
    }

    @NotNull
    public final Glyph square(@NotNull DoubleVector location2, double width2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new SquareGlyph(location2, width2);
    }

    @NotNull
    public final Glyph circle(@NotNull DoubleVector location2, double width2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new CircleGlyph(location2, width2);
    }

    @NotNull
    public final Glyph diamond(@NotNull DoubleVector location2, double width2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new DiamondGlyph(location2, width2);
    }

    @NotNull
    public final Glyph triangleUp(@NotNull DoubleVector location2, double width2, double stroke2, boolean pinnedToCentroid) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new TriangleGlyph(location2, width2, stroke2, true, pinnedToCentroid, false, 32, null);
    }

    @NotNull
    public final Glyph triangleDown(@NotNull DoubleVector location2, double width2, double stroke2, boolean pinnedToCentroid) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new TriangleGlyph(location2, width2, stroke2, false, pinnedToCentroid, false, 32, null);
    }

    @NotNull
    public final Glyph stickPlus(@NotNull DoubleVector location2, double width2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new PlusGlyph(location2, width2);
    }

    @NotNull
    public final Glyph stickCross(@NotNull DoubleVector location2, double width2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new CrossGlyph(location2, width2, false, 4, null);
    }

    @NotNull
    public final Glyph stickSquareCross(@NotNull DoubleVector location2, double size2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new SquareGlyph(location2, size2), new CrossGlyph(location2, size2, false));
    }

    @NotNull
    public final Glyph stickStar(@NotNull DoubleVector location2, double size2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new PlusGlyph(location2, size2), new CrossGlyph(location2, size2, false, 4, null));
    }

    @NotNull
    public final Glyph stickDiamondPlus(@NotNull DoubleVector location2, double size2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new DiamondGlyph(location2, size2), new PlusGlyph(location2, size2));
    }

    @NotNull
    public final Glyph stickCirclePlus(@NotNull DoubleVector location2, double size2, double stroke2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new CircleGlyph(location2, size2), new PlusGlyph(location2, size2 + stroke2));
    }

    @NotNull
    public final Glyph stickTriangleUpDown(@NotNull DoubleVector location2, double size2, double stroke2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new TriangleGlyph(location2, size2, stroke2, true, false, false, 48, null), new TriangleGlyph(location2, size2, stroke2, false, false, false, 48, null));
    }

    @NotNull
    public final Glyph stickSquarePlus(@NotNull DoubleVector location2, double size2, double stroke2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new SquareGlyph(location2, size2), new PlusGlyph(location2, size2 + stroke2));
    }

    @NotNull
    public final Glyph stickCircleCross(@NotNull DoubleVector location2, double size2, double stroke2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new CircleGlyph(location2, size2), new CrossGlyph(location2, size2 + stroke2, false, 4, null));
    }

    @NotNull
    public final Glyph stickSquareTriangleUp(@NotNull DoubleVector location2, double size2, double stroke2) {
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        return new GlyphPair(new SquareGlyph(location2, size2), new TriangleGlyph(location2, size2, stroke2, true, false, true));
    }
}

