/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.projection;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.utils.SpringDataBundle;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;

public final class SpringDataProjectionAnnotator
extends RelatedItemLineMarkerProvider {
    public String getId() {
        return "SpringDataProjectionAnnotator";
    }

    public String getName() {
        return SpringDataBundle.message("spring.data.projections.annotator", new Object[0]);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = SpringApiIcons.InfrastructureBean;
        if (icon == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(0);
        }
        return icon;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result) {
        PsiElement first;
        if (elements == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(2);
        }
        if ((first = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringDataUtil.hasSpringDataSupport(first.getProject())) {
            return;
        }
        boolean isDumb = DumbService.isDumb((Project)first.getProject());
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            UMethod uMethod;
            PsiMethod psiMethod;
            Set<PsiMember> members;
            UClass uClass;
            PsiElement element = elements.get(i);
            UElement uElement = DumbAwareLineMarkerUtilsKt.getUParentForIdentifierDumbAware((PsiElement)element, (boolean)isDumb);
            if (uElement == null) continue;
            if (uElement instanceof UClass && (uClass = (UClass)uElement).isInterface()) {
                PsiClass psiClass = uClass.getJavaPsi();
                Set<PsiClass> domainClasses = SpringDataProjectionUtil.getDomainProjectionClasses(psiClass);
                if (domainClasses.isEmpty()) continue;
                SpringDataProjectionAnnotator.annotateProjectionInterface(psiClass, result, domainClasses);
                continue;
            }
            if (!(uElement instanceof UMethod) || (members = SpringDataProjectionUtil.getDomainProjectionMembers(psiMethod = (uMethod = (UMethod)uElement).getJavaPsi())).isEmpty()) continue;
            SpringDataProjectionAnnotator.annotateProjectionMethod(psiMethod, result, members);
        }
    }

    private static void annotateProjectionInterface(PsiClass projectionInterfacesElement, Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull Set<? extends PsiClass> domainClasses) {
        if (domainClasses == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(3);
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.InfrastructureBean);
        builder.setPopupTitle(SpringDataBundle.message("spring.data.domain.class.select", new Object[0])).setEmptyPopupText(SpringDataBundle.message("spring.data.domain.class.from.projection", new Object[0])).setTooltipText(SpringDataBundle.message("spring.data.domain.class.from.projection", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> domainClasses));
        PsiIdentifier identifier = projectionInterfacesElement.getNameIdentifier();
        if (identifier != null) {
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void annotateProjectionMethod(PsiMethod projectionMethod, Collection<? super RelatedItemLineMarkerInfo<?>> result, @NotNull Set<? extends PsiMember> psiMembers) {
        if (psiMembers == null) {
            SpringDataProjectionAnnotator.$$$reportNull$$$0(4);
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.SpringBeanMethod);
        builder.setPopupTitle(SpringDataBundle.message("spring.data.domain.class.member.select", new Object[0])).setEmptyPopupText(SpringDataBundle.message("spring.data.domain.member.from.projection", new Object[0])).setTooltipText(SpringDataBundle.message("spring.data.domain.member.from.projection", new Object[0])).setTargets(NotNullLazyValue.lazy(() -> psiMembers));
        PsiIdentifier identifier = projectionMethod.getNameIdentifier();
        if (identifier != null) {
            result.add(builder.createSpringRelatedMergeableLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClasses";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/projection/SpringDataProjectionAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotateProjectionInterface";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotateProjectionMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

