/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.ide.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.ide.folding.ProtoFoldingUtils;
import com.intellij.protobuf.lang.psi.ProtoBlockBody;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtoFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    public FoldingDescriptor @NotNull [] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            ProtoFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ProtoFoldingBuilder.$$$reportNull$$$0(1);
        }
        Collection elements = PsiTreeUtil.findChildrenOfAnyType((PsiElement)root, (Class[])new Class[]{ProtoBlockBody.class, PsiComment.class});
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>(elements.size());
        ProtoFoldingUtils.ConsecutiveElementGrouper grouper = new ProtoFoldingUtils.ConsecutiveElementGrouper();
        for (PsiElement element : elements) {
            if (element instanceof ProtoBlockBody) {
                ProtoFoldingUtils.addIfNotNull(descriptors, ProtoFoldingBuilder.buildBlockDescriptor((ProtoBlockBody)element));
                continue;
            }
            if (ProtoTokenTypes.BLOCK_COMMENT.equals(element.getNode().getElementType())) {
                descriptors.add(new FoldingDescriptor(element.getNode(), element.getTextRange()));
                continue;
            }
            if (!ProtoTokenTypes.LINE_COMMENT.equals(element.getNode().getElementType()) || !ProtoFoldingUtils.isOnOwnLine(element, document)) continue;
            ProtoFoldingUtils.addIfNotNull(descriptors, grouper.pushElement(element));
        }
        ProtoFoldingUtils.addIfNotNull(descriptors, grouper.buildBlock());
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(FoldingDescriptor.EMPTY_ARRAY);
        if (foldingDescriptorArray == null) {
            ProtoFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            ProtoFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (ProtoTokenTypes.BLOCK_COMMENT.equals(node.getElementType())) {
            return "/*...*/";
        }
        if (ProtoTokenTypes.LINE_COMMENT.equals(node.getElementType())) {
            if (node.getChars().charAt(0) == '#') {
                return "#...";
            }
            return "//...";
        }
        return null;
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            ProtoFoldingBuilder.$$$reportNull$$$0(4);
        }
        return false;
    }

    private static FoldingDescriptor buildBlockDescriptor(ProtoBlockBody block) {
        PsiElement open = block.getStart();
        PsiElement close = block.getEnd();
        if (close != null) {
            String text = open.getText() + "..." + close.getText();
            return new FoldingDescriptor(block.getNode(), new TextRange(open.getNode().getStartOffset(), close.getNode().getStartOffset() + close.getTextLength()), null, text);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/protobuf/ide/folding/ProtoFoldingBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/protobuf/ide/folding/ProtoFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

