/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.ijent;

import com.intellij.docker.ijent.DockerEelMachine;
import com.intellij.docker.ijent.ShortedContainerId;
import com.intellij.docker.ijent.mrfs.EelDockerMrfsBackend;
import com.intellij.platform.eel.EelDescriptorWithoutNativeFileChooserSupport;
import com.intellij.platform.eel.EelPathBoundDescriptor;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/intellij/docker/ijent/DockerEelDescriptor;", "Lcom/intellij/platform/eel/EelDescriptorWithoutNativeFileChooserSupport;", "Lcom/intellij/platform/eel/EelPathBoundDescriptor;", "containerId", "Lcom/intellij/docker/ijent/ShortedContainerId;", "<init>", "(Lcom/intellij/docker/ijent/ShortedContainerId;)V", "", "(Ljava/lang/String;)V", "getContainerId", "()Lcom/intellij/docker/ijent/ShortedContainerId;", "rootPathString", "rootPath", "Ljava/nio/file/Path;", "getRootPath", "()Ljava/nio/file/Path;", "machine", "Lcom/intellij/docker/ijent/DockerEelMachine;", "getMachine", "()Lcom/intellij/docker/ijent/DockerEelMachine;", "equals", "", "other", "", "hashCode", "", "intellij.clouds.docker"})
@ApiStatus.Internal
public final class DockerEelDescriptor
implements EelDescriptorWithoutNativeFileChooserSupport,
EelPathBoundDescriptor {
    @NotNull
    private final ShortedContainerId containerId;
    @NotNull
    private final String rootPathString;
    @NotNull
    private final DockerEelMachine machine;

    public DockerEelDescriptor(@NotNull ShortedContainerId containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        this.containerId = containerId;
        this.rootPathString = EelDockerMrfsBackend.DOCKER_PATH_PREFIX + this.containerId;
        this.machine = new DockerEelMachine(this.containerId);
    }

    @NotNull
    public final ShortedContainerId getContainerId() {
        return this.containerId;
    }

    public DockerEelDescriptor(@NotNull String containerId) {
        Intrinsics.checkNotNullParameter((Object)containerId, (String)"containerId");
        this(new ShortedContainerId(containerId));
    }

    @NotNull
    public Path getRootPath() {
        Path path2 = Path.of(this.rootPathString, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        return path2;
    }

    @NotNull
    public DockerEelMachine getMachine() {
        return this.machine;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.docker.ijent.DockerEelDescriptor");
        DockerEelDescriptor cfr_ignored_0 = (DockerEelDescriptor)object2;
        if (!Intrinsics.areEqual((Object)this.rootPathString, (Object)((DockerEelDescriptor)other).rootPathString)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getMachine(), (Object)((DockerEelDescriptor)other).getMachine());
    }

    public int hashCode() {
        int result2 = this.rootPathString.hashCode();
        result2 = 31 * result2 + this.getMachine().hashCode();
        return result2;
    }
}

