/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.containers.ObjectIntMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLocalClassesHelper {
    private static final Key<ParameterizedCachedValue<Map<PsiClass, String>, PsiClass>> LOCAL_CLASS_NAME = Key.create((String)"LOCAL_CLASS_NAME");
    private static final LocalClassProvider LOCAL_CLASS_PROVIDER = new LocalClassProvider();

    @Nullable
    public static String getName(@NotNull PsiClass cls) {
        if (cls == null) {
            JavaLocalClassesHelper.$$$reportNull$$$0(0);
        }
        if (!PsiUtil.isLocalClass(cls)) {
            throw new IllegalArgumentException("class " + cls + " must be a local class");
        }
        PsiClass upper = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class);
        if (upper == null) {
            return null;
        }
        ParameterizedCachedValue value = (ParameterizedCachedValue)upper.getUserData(LOCAL_CLASS_NAME);
        if (value == null) {
            value = CachedValuesManager.getManager((Project)upper.getProject()).createParameterizedCachedValue((ParameterizedCachedValueProvider)LOCAL_CLASS_PROVIDER, false);
            upper.putUserData(LOCAL_CLASS_NAME, value);
        }
        return (String)((Map)value.getValue((Object)upper)).get(cls);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/intellij/ide/util/JavaLocalClassesHelper", "getName"));
    }

    private static final class LocalClassProvider
    implements ParameterizedCachedValueProvider<Map<PsiClass, String>, PsiClass> {
        private LocalClassProvider() {
        }

        public CachedValueProvider.Result<Map<PsiClass, String>> compute(final PsiClass upper) {
            final HashMap map2 = new HashMap();
            upper.accept(new JavaRecursiveElementWalkingVisitor(){
                final ObjectIntMap<String> indexByName = new ObjectIntHashMap();

                @Override
                public void visitClass(@NotNull PsiClass aClass) {
                    String name;
                    if (aClass == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (aClass == upper) {
                        super.visitClass(aClass);
                    } else if (PsiUtil.isLocalClass(aClass) && (name = aClass.getName()) != null) {
                        int index = this.indexByName.getOrDefault((Object)name, 0) + 1;
                        this.indexByName.put((Object)name, index);
                        map2.put(aClass, "$" + index + name);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/ide/util/JavaLocalClassesHelper$LocalClassProvider$1", "visitClass"));
                }
            });
            return CachedValueProvider.Result.create(map2, (Object[])new Object[]{upper});
        }
    }
}

