/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Predicates;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiElementFinder
implements PossiblyDumbAware {
    public static final ProjectExtensionPointName<PsiElementFinder> EP = new ProjectExtensionPointName("com.intellij.java.elementFinder");

    @Nullable
    public abstract PsiClass findClass(@NotNull String var1, @NotNull GlobalSearchScope var2);

    public abstract PsiClass @NotNull [] findClasses(@NotNull String var1, @NotNull GlobalSearchScope var2);

    public boolean hasClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope, @NotNull Predicate<PsiClass> filter) {
        if (qualifiedName == null) {
            PsiElementFinder.$$$reportNull$$$0(0);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(1);
        }
        if (filter == null) {
            PsiElementFinder.$$$reportNull$$$0(2);
        }
        PsiClass[] classes = this.findClasses(qualifiedName, scope);
        if (filter == Predicates.alwaysTrue()) {
            return classes.length > 0;
        }
        for (PsiClass aClass : classes) {
            if (!filter.test(aClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            PsiElementFinder.$$$reportNull$$$0(3);
        }
        return null;
    }

    public PsiPackage @NotNull [] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(5);
        }
        if (PsiPackage.EMPTY_ARRAY == null) {
            PsiElementFinder.$$$reportNull$$$0(6);
        }
        return PsiPackage.EMPTY_ARRAY;
    }

    public PsiClass @NotNull [] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(8);
        }
        if (PsiClass.EMPTY_ARRAY == null) {
            PsiElementFinder.$$$reportNull$$$0(9);
        }
        return PsiClass.EMPTY_ARRAY;
    }

    @Nullable
    public Predicate<PsiClass> getClassesFilter(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(10);
        }
        return null;
    }

    public PsiFile @NotNull [] getPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(12);
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            PsiElementFinder.$$$reportNull$$$0(13);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    @Nullable
    public Condition<PsiFile> getPackageFilesFilter(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(14);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(15);
        }
        return null;
    }

    @NotNull
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(17);
        }
        return PsiElementFinder.getClassNames(this.getClasses(psiPackage, scope));
    }

    @NotNull
    protected static Set<String> getClassNames(PsiClass @NotNull [] classes) {
        if (classes == null) {
            PsiElementFinder.$$$reportNull$$$0(18);
        }
        if (classes.length == 0) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PsiElementFinder.$$$reportNull$$$0(19);
            }
            return set;
        }
        HashSet<String> names = new HashSet<String>(classes.length);
        for (PsiClass aClass : classes) {
            ContainerUtil.addIfNotNull(names, (Object)aClass.getName());
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            PsiElementFinder.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            PsiElementFinder.$$$reportNull$$$0(23);
        }
        return this.processPackageDirectories(psiPackage, scope, consumer, false);
    }

    public boolean processPackageDirectories(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiDirectory> consumer, boolean includeLibrarySources) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            PsiElementFinder.$$$reportNull$$$0(26);
        }
        return true;
    }

    public boolean processPackageFiles(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope, @NotNull Processor<? super PsiFile> consumer) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(27);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(28);
        }
        if (consumer == null) {
            PsiElementFinder.$$$reportNull$$$0(29);
        }
        return true;
    }

    public PsiClass @NotNull [] getClasses(@Nullable String className, @NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        if (psiPackage == null) {
            PsiElementFinder.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            PsiElementFinder.$$$reportNull$$$0(31);
        }
        PsiClass[] allClasses = this.getClasses(psiPackage, scope);
        if (className == null) {
            if (allClasses == null) {
                PsiElementFinder.$$$reportNull$$$0(32);
            }
            return allClasses;
        }
        return PsiElementFinder.filterByName(className, allClasses);
    }

    public static PsiClass @NotNull [] filterByName(@NotNull String className, PsiClass @NotNull [] classes) {
        if (className == null) {
            PsiElementFinder.$$$reportNull$$$0(33);
        }
        if (classes == null) {
            PsiElementFinder.$$$reportNull$$$0(34);
        }
        if (classes.length == 0) {
            if (PsiClass.EMPTY_ARRAY == null) {
                PsiElementFinder.$$$reportNull$$$0(35);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        if (classes.length == 1) {
            PsiClass[] psiClassArray = className.equals(classes[0].getName()) ? classes : PsiClass.EMPTY_ARRAY;
            if (psiClassArray == null) {
                PsiElementFinder.$$$reportNull$$$0(36);
            }
            return psiClassArray;
        }
        SmartList foundClasses = new SmartList();
        for (PsiClass psiClass : classes) {
            if (!className.equals(psiClass.getName())) continue;
            foundClasses.add(psiClass);
        }
        PsiClass[] psiClassArray = foundClasses.isEmpty() ? PsiClass.EMPTY_ARRAY : foundClasses.toArray(PsiClass.EMPTY_ARRAY);
        if (psiClassArray == null) {
            PsiElementFinder.$$$reportNull$$$0(37);
        }
        return psiClassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 19: 
            case 20: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 19: 
            case 20: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 17: 
            case 22: 
            case 25: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 16: 
            case 21: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiPackage";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 19: 
            case 20: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/PsiElementFinder";
                break;
            }
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 23: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/PsiElementFinder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubPackages";
                break;
            }
            case 9: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasses";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNames";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasClass";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPackage";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSubPackages";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 19: 
            case 20: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 7: 
            case 8: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getClasses";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getClassesFilter";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFiles";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPackageFilesFilter";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getClassNames";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processPackageDirectories";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processPackageFiles";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "filterByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 19: 
            case 20: 
            case 32: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

