/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionProfileConvertor {
    private final HashMap<String, HighlightDisplayLevel> myDisplayLevelMap = new HashMap();
    @NonNls
    public static final String OLD_HIGHTLIGHTING_SETTINGS_PROFILE = "EditorHighlightingSettings";
    @NonNls
    public static final String OLD_DEFAUL_PROFILE = "OldDefaultProfile";
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettingsConvertor");
    @NonNls
    private static final String INSPECTIONS_TAG = "inspections";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String INSP_TOOL_TAG = "inspection_tool";
    @NonNls
    private static final String CLASS_ATT = "class";
    @NonNls
    private static final String VERSION_ATT = "version";
    @NonNls
    private static final String PROFILE_NAME_ATT = "profile_name";
    @NonNls
    private static final String OPTION_TAG = "option";
    @NonNls
    private static final String DISPLAY_LEVEL_MAP_OPTION = "DISPLAY_LEVEL_MAP";
    @NonNls
    protected static final String VALUE_ATT = "value";
    @NonNls
    private static final String DEFAULT_XML = "Default.xml";
    @NonNls
    private static final String XML_EXTENSION = ".xml";
    @NonNls
    public static final String LEVEL_ATT = "level";
    private final InspectionProfileManager myManager;

    public InspectionProfileConvertor(InspectionProfileManager manager) {
        this.myManager = manager;
        InspectionProfileConvertor.renameOldDefaultsProfile();
    }

    private boolean retrieveOldSettings(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/InspectionProfileConvertor", "retrieveOldSettings"));
        }
        boolean hasOldSettings = false;
        for (Element obj : element.getChildren(OPTION_TAG)) {
            Element option = obj;
            String name = option.getAttributeValue(NAME_ATT);
            if (name == null) continue;
            hasOldSettings |= this.processElement(option, name);
        }
        return hasOldSettings;
    }

    protected boolean processElement(Element option, String name) {
        if (name.equals(DISPLAY_LEVEL_MAP_OPTION)) {
            Element levelMap = option.getChild(VALUE_ATT);
            Iterator i$ = levelMap.getChildren().iterator();
            while (i$.hasNext()) {
                HighlightDisplayLevel level;
                Element o;
                Element e = o = (Element)i$.next();
                String key = e.getName();
                String levelName = e.getAttributeValue(LEVEL_ATT);
                HighlightSeverity severity = this.myManager.getSeverityRegistrar().getSeverity(levelName);
                HighlightDisplayLevel highlightDisplayLevel = level = severity == null ? null : HighlightDisplayLevel.find(severity);
                if (level == null) continue;
                this.myDisplayLevelMap.put(key, level);
            }
            return true;
        }
        return false;
    }

    public void storeEditorHighlightingProfile(@NotNull Element element, @NotNull InspectionProfile editorProfile) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/InspectionProfileConvertor", "storeEditorHighlightingProfile"));
        }
        if (editorProfile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorProfile", "com/intellij/codeInsight/daemon/InspectionProfileConvertor", "storeEditorHighlightingProfile"));
        }
        if (this.retrieveOldSettings(element)) {
            ModifiableModel editorProfileModel = editorProfile.getModifiableModel();
            this.fillErrorLevels(editorProfileModel);
            try {
                editorProfileModel.commit();
            }
            catch (IOException e) {
                LOG.error(e);
            }
        }
    }

    public static Element convertToNewFormat(Element profileFile, InspectionProfile profile) {
        Element rootElement = new Element(INSPECTIONS_TAG);
        rootElement.setAttribute(NAME_ATT, profile.getName());
        InspectionToolWrapper[] tools = profile.getInspectionTools(null);
        for (Element o : profileFile.getChildren(INSP_TOOL_TAG)) {
            Element toolElement = o.clone();
            String toolClassName = toolElement.getAttributeValue(CLASS_ATT);
            String shortName = InspectionProfileConvertor.convertToShortName(toolClassName, tools);
            if (shortName == null) continue;
            toolElement.setAttribute(CLASS_ATT, shortName);
            rootElement.addContent(toolElement);
        }
        return rootElement;
    }

    private static void renameOldDefaultsProfile() {
        String directoryPath = PathManager.getConfigPath() + File.separator + "inspection";
        File profileDirectory = new File(directoryPath);
        if (!profileDirectory.exists()) {
            return;
        }
        File[] files = profileDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(@NotNull File pathname) {
                if (pathname == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathname", "com/intellij/codeInsight/daemon/InspectionProfileConvertor$1", "accept"));
                }
                return pathname.getPath().endsWith(File.separator + InspectionProfileConvertor.DEFAULT_XML);
            }
        });
        if (files == null || files.length != 1 || !files[0].isFile()) {
            return;
        }
        try {
            Document doc = JDOMUtil.loadDocument(files[0]);
            Element root = doc.getRootElement();
            if (root.getAttributeValue(VERSION_ATT) == null) {
                root.setAttribute(PROFILE_NAME_ATT, OLD_DEFAUL_PROFILE);
                JDOMUtil.writeDocument(doc, new File(profileDirectory, "OldDefaultProfile.xml"), "\n");
                FileUtil.delete(files[0]);
            }
        }
        catch (IOException e) {
            LOG.error(e);
        }
        catch (JDOMException e) {
            LOG.error(e);
        }
    }

    protected void fillErrorLevels(ModifiableModel profile) {
        InspectionToolWrapper[] toolWrappers = profile.getInspectionTools(null);
        LOG.assertTrue(toolWrappers != null, "Profile was not correctly init");
        for (String shortName : this.myDisplayLevelMap.keySet()) {
            HighlightDisplayLevel level = this.myDisplayLevelMap.get(shortName);
            HighlightDisplayKey key = HighlightDisplayKey.find(shortName);
            if (key == null) continue;
            if (level != HighlightDisplayLevel.DO_NOT_SHOW) {
                profile.enableTool(shortName, null, null);
            }
            if (level == null || level == HighlightDisplayLevel.DO_NOT_SHOW) {
                level = HighlightDisplayLevel.WARNING;
            }
            profile.setErrorLevel(key, level, null);
        }
    }

    @Nullable
    private static String convertToShortName(String displayName, InspectionToolWrapper[] tools) {
        if (displayName == null) {
            return null;
        }
        for (InspectionToolWrapper tool : tools) {
            if (!displayName.equals(tool.getDisplayName())) continue;
            return tool.getShortName();
        }
        return null;
    }
}

