/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.embedding;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.embedding.MasqueradingLexer;
import com.intellij.embedding.MasqueradingPsiBuilderAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.ILazyParseableElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbeddedLazyParseableElementType
extends ILazyParseableElementType
implements EmbeddingElementType {
    public EmbeddedLazyParseableElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugName", "com/intellij/embedding/EmbeddedLazyParseableElementType", "<init>"));
        }
        super(debugName, language);
    }

    public Lexer createLexer(@NotNull ASTNode chameleon, @NotNull Project project, @NotNull Language parentLanguage) {
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/embedding/EmbeddedLazyParseableElementType", "createLexer"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/embedding/EmbeddedLazyParseableElementType", "createLexer"));
        }
        if (parentLanguage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentLanguage", "com/intellij/embedding/EmbeddedLazyParseableElementType", "createLexer"));
        }
        Language language = chameleon.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        return parserDefinition.createLexer(project);
    }

    public ASTNode parseAndGetTree(@NotNull PsiBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/embedding/EmbeddedLazyParseableElementType", "parseAndGetTree"));
        }
        PsiParser parser = ((ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(this.getLanguage())).createParser(builder.getProject());
        return parser.parse(this, builder);
    }

    @Override
    protected ASTNode doParseContents(@NotNull ASTNode chameleon, @NotNull PsiElement psi) {
        if (chameleon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chameleon", "com/intellij/embedding/EmbeddedLazyParseableElementType", "doParseContents"));
        }
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "com/intellij/embedding/EmbeddedLazyParseableElementType", "doParseContents"));
        }
        PsiFile file = psi.getContainingFile();
        assert (file != null) : chameleon;
        Project project = file.getProject();
        Language language = chameleon.getElementType().getLanguage();
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(language);
        Lexer lexer = this.createLexer(chameleon, project, psi.getLanguage());
        PsiBuilder builder = this.getBuilder(chameleon, project, parserDefinition, lexer);
        return this.parseAndGetTree(builder).getFirstChildNode();
    }

    public PsiBuilder getBuilder(ASTNode chameleon, Project project, ParserDefinition parserDefinition, Lexer lexer) {
        PsiBuilder builder = lexer instanceof MasqueradingLexer ? new MasqueradingPsiBuilderAdapter(project, parserDefinition, (MasqueradingLexer)lexer, chameleon, chameleon.getChars()) : new PsiBuilderImpl(project, parserDefinition, lexer, chameleon, chameleon.getChars());
        return builder;
    }
}

