/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.StateMap;
import com.intellij.openapi.components.impl.stores.StorageData;
import com.intellij.openapi.components.impl.stores.StorageDataBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.StringInterner;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryStorageData
extends StorageDataBase {
    private static final Logger LOG = Logger.getInstance(DirectoryStorageData.class);
    public static final String DEFAULT_EXT = ".xml";
    private final Map<String, StateMap> myStates;

    public DirectoryStorageData() {
        this((Map<String, StateMap>)new THashMap());
    }

    private DirectoryStorageData(@NotNull Map<String, StateMap> states) {
        if (states == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "states", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "<init>"));
        }
        this.myStates = states;
    }

    @Override
    @NotNull
    public Set<String> getComponentNames() {
        Set<String> set = this.myStates.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "getComponentNames"));
        }
        return set;
    }

    boolean isEmpty() {
        return this.myStates.isEmpty();
    }

    public static boolean isStorageFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "isStorageFile"));
        }
        return StringUtilRt.endsWithIgnoreCase(file.getNameSequence(), DEFAULT_EXT);
    }

    public void loadFrom(@Nullable VirtualFile dir, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        if (dir == null || !dir.exists()) {
            return;
        }
        StringInterner interner = new StringInterner();
        for (VirtualFile file : dir.getChildren()) {
            if (!DirectoryStorageData.isStorageFile(file)) continue;
            try {
                Element element = JDOMUtil.loadDocument(file.contentsToByteArray()).getRootElement();
                String name = StorageData.getComponentNameIfValid(element);
                if (name == null) continue;
                if (!element.getName().equals("component")) {
                    LOG.error("Incorrect root tag name (" + element.getName() + ") in " + file.getPresentableUrl());
                    continue;
                }
                List elementChildren = element.getChildren();
                if (elementChildren.isEmpty()) continue;
                Element state = (Element)((Element)elementChildren.get(0)).detach();
                JDOMUtil.internElement(state, interner);
                if (pathMacroSubstitutor != null) {
                    pathMacroSubstitutor.expandPaths(state);
                    pathMacroSubstitutor.addUnknownMacros(name, PathMacrosCollector.getMacroNames(state));
                }
                this.setState(name, file.getName(), state);
            }
            catch (IOException e) {
                LOG.info("Unable to load state", e);
            }
            catch (JDOMException e) {
                LOG.info("Unable to load state", e);
            }
        }
    }

    @Nullable
    public static DirectoryStorageData setStateAndCloneIfNeed(@NotNull String componentName, @Nullable String fileName, @Nullable Element newState, @NotNull DirectoryStorageData storageData) {
        Object oldState;
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "setStateAndCloneIfNeed"));
        }
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "setStateAndCloneIfNeed"));
        }
        StateMap fileToState = storageData.myStates.get(componentName);
        Object object = oldState = fileToState == null || fileName == null ? null : fileToState.get(fileName);
        if (fileName == null || newState == null || JDOMUtil.isEmpty(newState)) {
            if (fileName == null ? fileToState == null : oldState == null) {
                return null;
            }
            DirectoryStorageData newStorageData = storageData.clone();
            if (fileName == null) {
                newStorageData.myStates.remove(componentName);
            } else {
                StateMap clonedFileToState = newStorageData.myStates.get(componentName);
                if (clonedFileToState.size() == 1) {
                    newStorageData.myStates.remove(componentName);
                } else {
                    clonedFileToState.remove(fileName);
                    if (clonedFileToState.isEmpty()) {
                        newStorageData.myStates.remove(componentName);
                    }
                }
            }
            return newStorageData;
        }
        byte[] newBytes = null;
        if (oldState instanceof Element ? JDOMUtil.areElementsEqual((Element)oldState, newState) : oldState != null && (newBytes = StateMap.getNewByteIfDiffers(componentName, newState, (byte[])oldState)) == null) {
            return null;
        }
        DirectoryStorageData newStorageData = storageData.clone();
        newStorageData.put(componentName, fileName, newBytes == null ? newState : (Element)newBytes);
        return newStorageData;
    }

    @Nullable
    public Object setState(@NotNull String componentName, @Nullable String fileName, @Nullable Element newState) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "setState"));
        }
        StateMap fileToState = this.myStates.get(componentName);
        if (fileName == null || newState == null || JDOMUtil.isEmpty(newState)) {
            if (fileToState == null) {
                return null;
            }
            if (fileName == null) {
                return this.myStates.remove(componentName);
            }
            Object oldState = fileToState.remove(fileName);
            if (fileToState.isEmpty()) {
                this.myStates.remove(componentName);
            }
            return oldState;
        }
        if (fileToState == null) {
            fileToState = new StateMap();
            this.myStates.put(componentName, fileToState);
            fileToState.put(fileName, newState);
        } else {
            Object oldState = fileToState.get(fileName);
            byte[] newBytes = null;
            if (oldState instanceof Element ? JDOMUtil.areElementsEqual((Element)oldState, newState) : oldState != null && (newBytes = StateMap.getNewByteIfDiffers(fileName, newState, (byte[])oldState)) == null) {
                return null;
            }
            fileToState.put(fileName, newBytes == null ? newState : newBytes);
        }
        return newState;
    }

    private void put(@NotNull String componentName, @NotNull String fileName, @NotNull Object state) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "put"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "put"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "put"));
        }
        StateMap fileToState = this.myStates.get(componentName);
        if (fileToState == null) {
            fileToState = new StateMap();
            this.myStates.put(componentName, fileToState);
        }
        fileToState.put(fileName, state);
    }

    void processComponent(@NotNull String componentName, @NotNull TObjectObjectProcedure<String, Object> consumer) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "processComponent"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "processComponent"));
        }
        StateMap map = this.myStates.get(componentName);
        if (map != null) {
            map.forEachEntry(consumer);
        }
    }

    protected DirectoryStorageData clone() {
        return new DirectoryStorageData((Map<String, StateMap>)new THashMap(this.myStates));
    }

    public void clear() {
        this.myStates.clear();
    }

    @Override
    public boolean hasState(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "hasState"));
        }
        StateMap fileToState = this.myStates.get(componentName);
        return fileToState != null && fileToState.hasStates();
    }

    @Nullable
    public Element getCompositeStateAndArchive(@NotNull String componentName, @NotNull StateSplitter splitter) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "getCompositeStateAndArchive"));
        }
        if (splitter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "splitter", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "getCompositeStateAndArchive"));
        }
        StateMap fileToState = this.myStates.get(componentName);
        Element state = new Element("component");
        if (fileToState == null || fileToState.isEmpty()) {
            return state;
        }
        if (splitter instanceof StateSplitterEx) {
            StateSplitterEx splitterEx = (StateSplitterEx)splitter;
            for (String fileName : fileToState.keys()) {
                Element subState = fileToState.getStateAndArchive(fileName);
                if (subState == null) {
                    return null;
                }
                splitterEx.mergeStateInto(state, subState);
            }
        } else {
            SmartList<Element> subElements = new SmartList<Element>();
            for (String fileName : fileToState.keys()) {
                Element subState = fileToState.getStateAndArchive(fileName);
                if (subState == null) {
                    return null;
                }
                subElements.add(subState);
            }
            if (!subElements.isEmpty()) {
                splitter.mergeStatesInto(state, subElements.toArray(new Element[subElements.size()]));
            }
        }
        return state;
    }

    @NotNull
    public Element stateToElement(@NotNull String key, @Nullable Object state) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "stateToElement"));
        }
        Element element = StateMap.stateToElement(key, state, Collections.<String, Element>emptyMap());
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "stateToElement"));
        }
        return element;
    }

    @NotNull
    public Set<String> getFileNames(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "getFileNames"));
        }
        StateMap fileToState = this.myStates.get(componentName);
        Set<String> set = fileToState == null || fileToState.isEmpty() ? Collections.emptySet() : fileToState.keys();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/DirectoryStorageData", "getFileNames"));
        }
        return set;
    }
}

