/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLock;
import com.intellij.psi.impl.source.xml.XmlEntityCache;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttlistDecl;
import com.intellij.psi.xml.XmlAttributeDecl;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlEnumeratedType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.InclusionProvider;
import com.intellij.xml.util.XmlIncludeHandler;
import org.jetbrains.annotations.NonNls;

public class XmlPsiUtil {
    private static final Key<CachedValue<PsiElement>> PARSED_DECL_KEY = Key.create("PARSED_DECL_KEY");
    @NonNls
    public static final String XINCLUDE_URI = "http://www.w3.org/2001/XInclude";

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag) {
        return XmlPsiUtil.processXmlElements(element, processor, deepFlag, false);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag) {
        if (element == null) {
            return true;
        }
        PsiFile baseFile = element.isValid() ? element.getContainingFile() : null;
        return XmlPsiUtil.processXmlElements(element, processor, deepFlag, wideFlag, baseFile);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag, PsiFile baseFile) {
        return XmlPsiUtil.processXmlElements(element, processor, deepFlag, wideFlag, baseFile, true);
    }

    public static boolean processXmlElements(XmlElement element, PsiElementProcessor processor, boolean deepFlag, boolean wideFlag, PsiFile baseFile, boolean processIncludes) {
        return new XmlElementProcessor(processor, baseFile).processXmlElements(element, deepFlag, wideFlag, processIncludes);
    }

    public static boolean processXmlElementChildren(XmlElement element, PsiElementProcessor processor, boolean deepFlag) {
        XmlElementProcessor p = new XmlElementProcessor(processor, element.getContainingFile());
        boolean wideFlag = false;
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (p.processElement(child, deepFlag, false, true)) continue;
            return false;
        }
        return true;
    }

    private static PsiElement parseEntityRef(PsiFile targetFile, XmlEntityRef ref) {
        PsiElement element;
        XmlEntityDecl entityDecl;
        XmlEntityDecl.EntityContextType type = XmlPsiUtil.getContextType(ref);
        XmlEntityDecl entityDecl2 = ref.resolve(targetFile);
        if (entityDecl2 != null) {
            return XmlPsiUtil.parseEntityDecl(entityDecl2, targetFile, type, ref);
        }
        PsiElement e = ref;
        while (e != null) {
            if (e.getUserData(XmlElement.INCLUDING_ELEMENT) != null) {
                PsiFile f = (e = (PsiElement)e.getUserData(XmlElement.INCLUDING_ELEMENT)).getContainingFile();
                if (f == null || (entityDecl = ref.resolve(targetFile)) == null) continue;
                return XmlPsiUtil.parseEntityDecl(entityDecl, targetFile, type, ref);
            }
            if (e instanceof PsiFile) {
                PsiFile refFile = (PsiFile)e;
                entityDecl = ref.resolve(refFile);
                if (entityDecl == null) break;
                return XmlPsiUtil.parseEntityDecl(entityDecl, targetFile, type, ref);
            }
            e = e.getParent();
        }
        if ((element = ref.getUserData(XmlElement.DEPENDING_ELEMENT)) instanceof XmlFile && (entityDecl = ref.resolve((PsiFile)element)) != null) {
            return XmlPsiUtil.parseEntityDecl(entityDecl, targetFile, type, ref);
        }
        return null;
    }

    private static XmlEntityDecl.EntityContextType getContextType(XmlEntityRef ref) {
        XmlEntityDecl.EntityContextType type = XmlEntityDecl.EntityContextType.GENERIC_XML;
        for (PsiElement temp = ref; temp != null; temp = temp.getContext()) {
            if (temp instanceof XmlAttributeDecl) {
                type = XmlEntityDecl.EntityContextType.ATTRIBUTE_SPEC;
                break;
            }
            if (temp instanceof XmlElementDecl) {
                type = XmlEntityDecl.EntityContextType.ELEMENT_CONTENT_SPEC;
                break;
            }
            if (temp instanceof XmlAttlistDecl) {
                type = XmlEntityDecl.EntityContextType.ATTLIST_SPEC;
                break;
            }
            if (temp instanceof XmlEntityDecl) {
                type = XmlEntityDecl.EntityContextType.ENTITY_DECL_CONTENT;
                break;
            }
            if (temp instanceof XmlEnumeratedType) {
                type = XmlEntityDecl.EntityContextType.ENUMERATED_TYPE;
                break;
            }
            if (!(temp instanceof XmlAttributeValue)) continue;
            type = XmlEntityDecl.EntityContextType.ATTR_VALUE;
            break;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PsiElement parseEntityDecl(final XmlEntityDecl entityDecl, final PsiFile targetFile, final XmlEntityDecl.EntityContextType type, final XmlEntityRef entityRef) {
        Object object = PsiLock.LOCK;
        synchronized (object) {
            CachedValue<PsiElement> value = entityRef.getUserData(PARSED_DECL_KEY);
            if (value == null) {
                value = CachedValuesManager.getManager(entityDecl.getProject()).createCachedValue(new CachedValueProvider<PsiElement>(){

                    @Override
                    public CachedValueProvider.Result<PsiElement> compute() {
                        PsiElement res = entityDecl.parse(targetFile, type, entityRef);
                        if (res == null) {
                            return new CachedValueProvider.Result<PsiElement>(res, targetFile);
                        }
                        if (!entityDecl.isInternalReference()) {
                            XmlEntityCache.copyEntityCaches(res.getContainingFile(), targetFile);
                        }
                        return new CachedValueProvider.Result<PsiElement>(res, res.getUserData(XmlElement.DEPENDING_ELEMENT), entityDecl, targetFile, entityRef);
                    }
                }, false);
                entityRef.putUserData(PARSED_DECL_KEY, value);
            }
            return value.getValue();
        }
    }

    private static class XmlElementProcessor {
        private final PsiElementProcessor processor;
        private final PsiFile targetFile;

        XmlElementProcessor(PsiElementProcessor _processor, PsiFile _targetFile) {
            this.processor = _processor;
            this.targetFile = _targetFile;
        }

        private boolean processXmlElements(PsiElement element, boolean deepFlag, boolean wideFlag, boolean processIncludes) {
            if (deepFlag && !this.processor.execute(element)) {
                return false;
            }
            PsiElement startFrom = element.getFirstChild();
            if (element instanceof XmlEntityRef) {
                XmlEntityRef ref = (XmlEntityRef)element;
                for (PsiElement newElement = XmlPsiUtil.parseEntityRef(this.targetFile, ref); newElement != null; newElement = newElement.getNextSibling()) {
                    if (this.processElement(newElement, deepFlag, wideFlag, processIncludes)) continue;
                    return false;
                }
                return true;
            }
            if (element instanceof XmlConditionalSection) {
                XmlConditionalSection xmlConditionalSection = (XmlConditionalSection)element;
                if (!xmlConditionalSection.isIncluded(this.targetFile)) {
                    return true;
                }
                startFrom = xmlConditionalSection.getBodyStart();
            } else if (processIncludes && XmlIncludeHandler.isXInclude(element)) {
                for (PsiElement psiElement : InclusionProvider.getIncludedTags((XmlTag)element)) {
                    if (this.processElement(psiElement, deepFlag, wideFlag, true)) continue;
                    return false;
                }
            }
            for (PsiElement child = startFrom; child != null; child = child.getNextSibling()) {
                if (this.processElement(child, deepFlag, wideFlag, processIncludes) || wideFlag) continue;
                return false;
            }
            return true;
        }

        private boolean processElement(PsiElement child, boolean deepFlag, boolean wideFlag, boolean processIncludes) {
            if (deepFlag ? !this.processXmlElements(child, true, wideFlag, processIncludes) : (child instanceof XmlEntityRef ? !this.processXmlElements(child, false, wideFlag, processIncludes) : (child instanceof XmlConditionalSection ? !this.processXmlElements(child, false, wideFlag, processIncludes) : (processIncludes && XmlIncludeHandler.isXInclude(child) ? !this.processXmlElements(child, false, wideFlag, processIncludes) : !this.processor.execute(child))))) {
                return false;
            }
            if (this.targetFile != null && child instanceof XmlEntityDecl) {
                XmlEntityDecl xmlEntityDecl = (XmlEntityDecl)child;
                XmlEntityCache.cacheParticularEntity(this.targetFile, xmlEntityDecl);
            }
            return true;
        }
    }
}

