/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ComparatorMethodParameterNotUsedInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("comparator.method.parameter.not.used.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ComparatorMethodParameterNotUsedInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("comparator.method.parameter.not.used.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ComparatorMethodParameterNotUsedInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CompareMethodDoesNotUseParameterVisitor();
    }

    private static class CompareMethodDoesNotUseParameterVisitor
    extends BaseInspectionVisitor {
        private CompareMethodDoesNotUseParameterVisitor() {
        }

        @Override
        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!MethodUtils.methodMatches(method, "java.util.Comparator", (PsiType)PsiType.INT, "compare", PsiType.NULL, PsiType.NULL)) {
                return;
            }
            PsiCodeBlock body = method.getBody();
            if (body == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            ParameterAccessVisitor visitor = new ParameterAccessVisitor(parameters);
            body.accept(visitor);
            Collection<PsiParameter> unusedParameters = visitor.getUnusedParameters();
            for (PsiParameter unusedParameter : unusedParameters) {
                this.registerVariableError(unusedParameter, new Object[0]);
            }
        }

        private static class ParameterAccessVisitor
        extends JavaRecursiveElementVisitor {
            private final Set<PsiParameter> parameters;

            ParameterAccessVisitor(@NotNull PsiParameter[] parameters) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/siyeh/ig/bugs/ComparatorMethodParameterNotUsedInspection$CompareMethodDoesNotUseParameterVisitor$ParameterAccessVisitor", "<init>"));
                }
                this.parameters = new HashSet<PsiParameter>(Arrays.asList(parameters));
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (this.parameters.isEmpty()) {
                    return;
                }
                if (expression.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (!(target instanceof PsiParameter)) {
                    return;
                }
                PsiParameter parameter = (PsiParameter)target;
                this.parameters.remove(parameter);
            }

            public Collection<PsiParameter> getUnusedParameters() {
                return Collections.unmodifiableSet(this.parameters);
            }
        }
    }
}

