/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.NotNull;

public class ThrowableResultOfMethodCallIgnoredInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("throwable.result.of.method.call.ignored.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ThrowableResultOfMethodCallIgnoredInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("throwable.result.of.method.call.ignored.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/bugs/ThrowableResultOfMethodCallIgnoredInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ThrowableResultOfMethodCallIgnoredVisitor();
    }

    private static class ThrowableResultOfMethodCallIgnoredVisitor
    extends BaseInspectionVisitor {
        private ThrowableResultOfMethodCallIgnoredVisitor() {
        }

        @Override
        public void visitMethodCallExpression(PsiMethodCallExpression expression) {
            PsiLocalVariable variable;
            PsiClass containingClass;
            super.visitMethodCallExpression(expression);
            PsiElement parent = expression.getParent();
            while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiReturnStatement || parent instanceof PsiThrowStatement || parent instanceof PsiExpressionList) {
                return;
            }
            if (!TypeUtils.expressionHasTypeOrSubtype((PsiExpression)expression, "java.lang.Throwable")) {
                return;
            }
            PsiMethod method = expression.resolveMethod();
            if (method == null) {
                return;
            }
            if (!method.hasModifierProperty("static") && InheritanceUtil.isInheritor(containingClass = method.getContainingClass(), "java.lang.Throwable")) {
                return;
            }
            if ("propagate".equals(method.getName()) && method.getContainingClass() != null && "com.google.common.base.Throwables".equals(method.getContainingClass().getQualifiedName())) {
                return;
            }
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression rhs = assignmentExpression.getRExpression();
                if (!PsiTreeUtil.isAncestor(rhs, expression, false)) {
                    return;
                }
                PsiExpression lhs = assignmentExpression.getLExpression();
                if (!(lhs instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)lhs;
                PsiElement target = referenceExpression.resolve();
                if (!(target instanceof PsiLocalVariable)) {
                    return;
                }
                variable = (PsiLocalVariable)target;
            } else if (parent instanceof PsiVariable) {
                if (!(parent instanceof PsiLocalVariable)) {
                    return;
                }
                variable = (PsiLocalVariable)parent;
            } else {
                variable = null;
            }
            if (variable != null) {
                Query<PsiReference> query = ReferencesSearch.search(variable, variable.getUseScope());
                for (PsiReference reference : query) {
                    PsiElement usage = reference.getElement();
                    PsiElement usageParent = usage.getParent();
                    while (usageParent instanceof PsiParenthesizedExpression) {
                        usageParent = usageParent.getParent();
                    }
                    if (!(usageParent instanceof PsiThrowStatement) && !(usageParent instanceof PsiReturnStatement) && !(usageParent instanceof PsiExpressionList)) continue;
                    return;
                }
            }
            this.registerMethodCallError(expression, new Object[0]);
        }
    }
}

